/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.layout.editor.popups;

import com.github.gwtbootstrap.client.ui.AccordionGroup;
import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.HelpInline;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.github.gwtbootstrap.client.ui.event.HiddenEvent;
import com.github.gwtbootstrap.client.ui.event.HiddenHandler;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.uberfire.ext.layout.editor.client.LayoutEditorPluginAPI;
import org.uberfire.ext.layout.editor.client.structure.EditorWidget;
import org.uberfire.ext.plugin.client.resources.i18n.CommonConstants;
import org.uberfire.ext.plugin.client.validation.NameValidator;
import org.uberfire.ext.properties.editor.client.PropertyEditorWidget;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.properties.editor.model.PropertyEditorEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;
import org.uberfire.ext.properties.editor.model.PropertyEditorType;
import org.uberfire.ext.properties.editor.model.validators.PropertyFieldValidator;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class EditScreen
extends BaseModal {
    public static String PROPERTY_EDITOR_KEY = "LayoutEditor";
    private final LayoutEditorPluginAPI layoutEditorPluginAPI;
    private EditorWidget parent;
    @UiField
    TextBox key;
    @UiField
    AccordionGroup paramAccordion;
    @UiField
    ControlGroup paramKeyControlGroup;
    @UiField
    HelpInline paramKeyInline;
    @UiField
    TextBox value;
    @UiField
    PropertyEditorWidget propertyEditor;
    private Boolean revertChanges = Boolean.TRUE;
    private Map<String, String> lastParametersSaved = new HashMap<String, String>();
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);

    public EditScreen(EditorWidget parent, LayoutEditorPluginAPI layoutEditorPluginAPI) {
        this.clearModal();
        this.layoutEditorPluginAPI = layoutEditorPluginAPI;
        this.setTitle(CommonConstants.INSTANCE.EditComponent());
        this.setMaxHeigth("350px");
        this.add((Widget)uiBinder.createAndBindUi((Object)this));
        this.parent = parent;
        this.propertyEditor.setLastOpenAccordionGroupTitle("Screen Editors");
        this.propertyEditor.handle(this.generateEvent(this.defaultScreenProperties()));
        this.saveOriginalState();
        this.add((Widget)new ModalFooterOKCancelButtons(new Command(){

            public void execute() {
                EditScreen.this.okButton();
            }
        }, new Command(){

            public void execute() {
                EditScreen.this.cancelButton();
            }
        }));
        this.paramAccordion.addHiddenHandler(new HiddenHandler(){

            public void onHidden(HiddenEvent hiddenEvent) {
                hiddenEvent.stopPropagation();
            }
        });
        this.addHiddlenHandler();
    }

    private void clearModal() {
    }

    private void saveOriginalState() {
        this.lastParametersSaved = new HashMap<String, String>();
        Map layoutComponentProperties = this.layoutEditorPluginAPI.getLayoutComponentProperties(this.parent);
        for (String key : layoutComponentProperties.keySet()) {
            this.lastParametersSaved.put(key, (String)layoutComponentProperties.get(key));
        }
    }

    private void addHiddlenHandler() {
        this.addHiddenHandler(new HiddenHandler(){

            public void onHidden(HiddenEvent hiddenEvent) {
                if (EditScreen.this.userPressCloseOrCancel()) {
                    EditScreen.this.revertChanges();
                }
            }
        });
    }

    private void revertChanges() {
        this.layoutEditorPluginAPI.resetLayoutComponentProperties(this.parent);
        for (String key : this.lastParametersSaved.keySet()) {
            this.layoutEditorPluginAPI.addLayoutComponentProperty(this.parent, key, this.lastParametersSaved.get(key));
        }
    }

    private boolean userPressCloseOrCancel() {
        return this.revertChanges;
    }

    public void show() {
        super.show();
    }

    void okButton() {
        super.hide();
        this.revertChanges = Boolean.FALSE;
    }

    void cancelButton() {
        super.hide();
    }

    public void hide() {
        super.hide();
    }

    @UiHandler(value={"add"})
    void add(ClickEvent event) {
        PropertyEditorCategory property = this.addProperty();
        if (property == null) {
            return;
        }
        this.propertyEditor.setLastOpenAccordionGroupTitle("Screen Editors");
        this.propertyEditor.handle(this.generateEvent(property));
        this.key.setText("");
        this.value.setText("");
    }

    private PropertyEditorCategory addProperty() {
        this.paramKeyInline.setText("");
        this.paramKeyControlGroup.setType(ControlGroupType.NONE);
        NameValidator validator = NameValidator.parameterNameValidator();
        if (!validator.isValid(this.key.getText())) {
            this.paramKeyControlGroup.setType(ControlGroupType.ERROR);
            this.paramKeyInline.setText(validator.getValidationError());
            return null;
        }
        Map properties = this.layoutEditorPluginAPI.getLayoutComponentProperties(this.parent);
        for (String parameterKey : properties.keySet()) {
            if (!this.key.getText().equals(parameterKey)) continue;
            this.paramKeyControlGroup.setType(ControlGroupType.ERROR);
            this.paramKeyInline.setText(CommonConstants.INSTANCE.DuplicateParameterName());
            return null;
        }
        this.layoutEditorPluginAPI.addLayoutComponentProperty(this.parent, this.key.getText(), this.value.getText());
        return this.defaultScreenProperties();
    }

    private PropertyEditorCategory defaultScreenProperties() {
        PropertyEditorCategory category = new PropertyEditorCategory("Screen Editors"){

            public List<PropertyEditorFieldInfo> getFields() {
                return new ArrayList<PropertyEditorFieldInfo>((Collection)super.getFields()){

                    @Override
                    public boolean remove(Object o) {
                        if (o instanceof PropertyEditorFieldInfo) {
                            PropertyEditorFieldInfo info = (PropertyEditorFieldInfo)o;
                            EditScreen.this.layoutEditorPluginAPI.removeLayoutComponentProperty(EditScreen.this.parent, info.getLabel());
                        }
                        return super.remove(o);
                    }
                };
            }
        };
        boolean alreadyHasScreenNameParameter = false;
        Map parameters = this.layoutEditorPluginAPI.getLayoutComponentProperties(this.parent);
        for (String key : parameters.keySet()) {
            if (key.equals("Place Name")) {
                alreadyHasScreenNameParameter = true;
            }
            category.withField(new PropertyEditorFieldInfo(key, (String)parameters.get(key), PropertyEditorType.TEXT).withKey(this.parent.hashCode() + "").withRemovalSupported(!key.equals("Place Name")).withValidators(new PropertyFieldValidator[]{new PropertyFieldValidator(){

                public boolean validate(Object value) {
                    return true;
                }

                public String getValidatorErrorMessage() {
                    return "";
                }
            }}));
        }
        if (!alreadyHasScreenNameParameter) {
            category.withField(new PropertyEditorFieldInfo("Place Name", "", PropertyEditorType.TEXT).withKey(this.parent.hashCode() + "").withValidators(new PropertyFieldValidator[]{new PropertyFieldValidator(){

                public boolean validate(Object value) {
                    return true;
                }

                public String getValidatorErrorMessage() {
                    return "";
                }
            }}));
        }
        return category;
    }

    private PropertyEditorEvent generateEvent(PropertyEditorCategory category) {
        PropertyEditorEvent event = new PropertyEditorEvent(PROPERTY_EDITOR_KEY, category);
        return event;
    }

    static interface Binder
    extends UiBinder<Widget, EditScreen> {
    }
}

