/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.ext.editor.commons.client.BaseEditor;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.ext.editor.commons.client.file.SaveOperationService;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.editor.commons.service.support.SupportsCopy;
import org.uberfire.ext.editor.commons.service.support.SupportsDelete;
import org.uberfire.ext.editor.commons.service.support.SupportsRename;
import org.uberfire.ext.plugin.client.editor.DynamicMenuEditorView;
import org.uberfire.ext.plugin.client.type.DynamicMenuResourceType;
import org.uberfire.ext.plugin.event.PluginRenamed;
import org.uberfire.ext.plugin.model.DynamicMenu;
import org.uberfire.ext.plugin.model.DynamicMenuItem;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.plugin.service.PluginServices;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="Dynamic Menu Editor", supportedTypes={DynamicMenuResourceType.class}, priority=0x7FFFFFFF)
public class DynamicMenuEditorPresenter
extends BaseEditor {
    @Inject
    private DynamicMenuResourceType resourceType;
    @Inject
    private Caller<PluginServices> pluginServices;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    private ActivityBeansCache activityBeansCache;
    private ListDataProvider<DynamicMenuItem> dataProvider = new ListDataProvider();
    private DynamicMenu menuItem;
    private Plugin plugin;

    @Inject
    public DynamicMenuEditorPresenter(DynamicMenuEditorView baseView) {
        super((BaseEditorView)baseView);
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        this.init(path, place, this.resourceType, true, false, new MenuItems[]{MenuItems.SAVE, MenuItems.COPY, MenuItems.RENAME, MenuItems.DELETE});
        this.plugin = new Plugin(place.getParameter("name", ""), PluginType.DYNAMIC_MENU, (Path)path);
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return "Dynamic Menu Editor [" + this.plugin.getName() + "]";
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }

    protected void onPlugInRenamed(@Observes PluginRenamed pluginRenamed) {
        if (pluginRenamed.getOldPluginName().equals(this.plugin.getName()) && pluginRenamed.getPlugin().getType().equals((Object)this.plugin.getType())) {
            this.plugin = new Plugin(pluginRenamed.getPlugin().getName(), PluginType.DYNAMIC_MENU, pluginRenamed.getPlugin().getPath());
            this.changeTitleNotification.fire((Object)new ChangeTitleWidgetEvent(this.place, this.getTitleText(), this.getTitle()));
        }
    }

    public void addMenuItem(DynamicMenuItem menuItem) {
        DynamicMenuItem existingItem = null;
        for (DynamicMenuItem item : this.dataProvider.getList()) {
            if (!menuItem.getMenuLabel().equals(item.getMenuLabel())) continue;
            existingItem = item;
            break;
        }
        if (existingItem == null) {
            this.dataProvider.getList().add(menuItem);
        } else {
            this.dataProvider.refresh();
        }
        this.dataProvider.flush();
    }

    public void removeObject(DynamicMenuItem object) {
        this.dataProvider.getList().remove(object);
    }

    public void updateIndex(DynamicMenuItem object, int index, UpdateIndexOperation operation) {
        int newIndex;
        if (index < 0) {
            return;
        }
        int n = newIndex = operation.equals((Object)UpdateIndexOperation.UP) ? index - 1 : index + 1;
        if (newIndex < 0 || newIndex > this.dataProvider.getList().size()) {
            return;
        }
        DynamicMenuItem oldItem = this.dataProvider.getList().set(newIndex, object);
        if (oldItem != null) {
            this.dataProvider.getList().set(index, oldItem);
        }
    }

    public void setDataDisplay(HasData<DynamicMenuItem> display) {
        this.dataProvider.addDataDisplay(display);
    }

    protected void loadContent() {
        ((PluginServices)this.pluginServices.call((RemoteCallback)new RemoteCallback<DynamicMenu>(){

            public void callback(DynamicMenu response) {
                DynamicMenuEditorPresenter.this.setOriginalHash(response.hashCode());
                DynamicMenuEditorPresenter.this.menuItem = response;
                DynamicMenuEditorPresenter.this.dataProvider.getList().clear();
                for (DynamicMenuItem menuItem : response.getMenuItems()) {
                    DynamicMenuEditorPresenter.this.dataProvider.getList().add(menuItem);
                }
                DynamicMenuEditorPresenter.this.baseView.hideBusyIndicator();
            }
        })).getDynamicMenuContent((Path)this.versionRecordManager.getCurrentPath());
    }

    protected Command onValidate() {
        return new Command(){

            public void execute() {
                HashSet<String> invalidActivities = new HashSet<String>();
                for (DynamicMenuItem dynamicMenuItem : DynamicMenuEditorPresenter.this.dataProvider.getList()) {
                    if (DynamicMenuEditorPresenter.this.activityBeansCache.getActivity(dynamicMenuItem.getActivityId()) != null) continue;
                    invalidActivities.add(dynamicMenuItem.getActivityId());
                }
                if (invalidActivities.isEmpty()) {
                    DynamicMenuEditorPresenter.this.notification.fire((Object)new NotificationEvent("Item Validated Successfully", NotificationEvent.NotificationType.SUCCESS));
                } else {
                    DynamicMenuEditorPresenter.this.notification.fire((Object)new NotificationEvent("Activity(ies) not found: '" + DynamicMenuEditorPresenter.this.toString(invalidActivities) + "'", NotificationEvent.NotificationType.ERROR));
                }
            }
        };
    }

    private String toString(Collection<String> invalidActivities) {
        StringBuilder result = new StringBuilder();
        for (String string : invalidActivities) {
            result.append(string).append(",");
        }
        return result.length() > 0 ? result.substring(0, result.length() - 1) : "";
    }

    protected void save() {
        new SaveOperationService().save((Path)this.versionRecordManager.getCurrentPath(), (ParameterizedCommand)new ParameterizedCommand<String>(){

            public void execute(String commitMessage) {
                ((PluginServices)DynamicMenuEditorPresenter.this.pluginServices.call(DynamicMenuEditorPresenter.this.getSaveSuccessCallback(DynamicMenuEditorPresenter.this.getContent().hashCode()))).saveMenu(DynamicMenuEditorPresenter.this.getContent(), commitMessage);
            }
        });
        this.concurrentUpdateSessionInfo = null;
    }

    @WorkbenchPartView
    public UberView<DynamicMenuEditorPresenter> getWidget() {
        return (UberView)this.baseView;
    }

    @OnMayClose
    public boolean onMayClose() {
        return super.mayClose(Integer.valueOf(this.getContent().hashCode()));
    }

    public DynamicMenu getContent() {
        return new DynamicMenu(this.menuItem.getName(), PluginType.DYNAMIC_MENU, (Path)this.versionRecordManager.getCurrentPath(), new ArrayList(this.dataProvider.getList()));
    }

    protected Caller<? extends SupportsDelete> getDeleteServiceCaller() {
        return this.pluginServices;
    }

    protected Caller<? extends SupportsRename> getRenameServiceCaller() {
        return this.pluginServices;
    }

    protected Caller<? extends SupportsCopy> getCopyServiceCaller() {
        return this.pluginServices;
    }

    static enum UpdateIndexOperation {
        UP,
        DOWN;

    }
}

