/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.editor;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.ButtonCell;
import com.github.gwtbootstrap.client.ui.CellTable;
import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.HelpInline;
import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.TooltipCellDecorator;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.SimpleBeanEditorDriver;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.editor.commons.client.BaseEditorViewImpl;
import org.uberfire.ext.plugin.client.editor.DynamicMenuEditorPresenter;
import org.uberfire.ext.plugin.client.resources.i18n.CommonConstants;
import org.uberfire.ext.plugin.client.validation.NameValidator;
import org.uberfire.ext.plugin.client.widget.cell.IconCell;
import org.uberfire.ext.plugin.model.DynamicMenuItem;

@Dependent
public class DynamicMenuEditorView
extends BaseEditorViewImpl
implements UberView<DynamicMenuEditorPresenter>,
Editor<DynamicMenuItem> {
    private final Driver driver = (Driver)GWT.create(Driver.class);
    private static final ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    private static final NameValidator activityIdValidator = NameValidator.activityIdValidator();
    private static final NameValidator menuLabelValidator = NameValidator.menuLabelValidator();
    @UiField
    TextBox activityId;
    @UiField
    ControlGroup activityIdControlGroup;
    @UiField
    @Editor.Ignore
    HelpInline activityIdHelpInline;
    @UiField
    TextBox menuLabel;
    @UiField
    ControlGroup menuLabelControlGroup;
    @UiField
    @Editor.Ignore
    HelpInline menuLabelHelpInline;
    private final ProvidesKey<DynamicMenuItem> keyProvider = new ProvidesKey<DynamicMenuItem>(){

        public Object getKey(DynamicMenuItem item) {
            return item.getActivityId() + item.getMenuLabel();
        }
    };
    private final SingleSelectionModel<DynamicMenuItem> selectionModel = new SingleSelectionModel(this.keyProvider);
    @UiField(provided=true)
    CellTable<DynamicMenuItem> menuItems = new CellTable(500, (CellTable.Resources)GWT.create(CellTable.SelectableResources.class), this.keyProvider);
    @UiField
    Button okButton;
    @UiField
    Button cancelButton;
    private DynamicMenuEditorPresenter presenter;

    @PostConstruct
    public void init() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    public void init(DynamicMenuEditorPresenter presenter) {
        this.presenter = presenter;
        this.driver.initialize(this);
        this.setMenuItem(new DynamicMenuItem());
        this.initTable((AbstractCellTable<DynamicMenuItem>)this.menuItems);
    }

    private void initTable(AbstractCellTable<DynamicMenuItem> dynamicMenuTable) {
        dynamicMenuTable.setEmptyTableWidget((Widget)new Label(CommonConstants.INSTANCE.MenusNoMenuItems()));
        DefaultSelectionEventManager manager = DefaultSelectionEventManager.createBlacklistManager((int[])new int[]{4});
        dynamicMenuTable.setSelectionModel(this.selectionModel, (CellPreviewEvent.Handler)manager);
        dynamicMenuTable.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED);
        IconCell iCell = new IconCell(IconType.ARROW_UP);
        iCell.setTooltip(CommonConstants.INSTANCE.MenusMoveUpHint());
        Column iconColumn = new Column<DynamicMenuItem, String>((Cell)iCell){

            public String getValue(DynamicMenuItem object) {
                return "";
            }
        };
        iconColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<DynamicMenuItem, String>(){

            public void update(int index, DynamicMenuItem object, String value) {
                DynamicMenuEditorView.this.presenter.updateIndex(object, index, DynamicMenuEditorPresenter.UpdateIndexOperation.UP);
            }
        });
        dynamicMenuTable.addColumn(iconColumn);
        dynamicMenuTable.setColumnWidth(iconColumn, "25px");
        iCell = new IconCell(IconType.ARROW_DOWN);
        iCell.setTooltip(CommonConstants.INSTANCE.MenusMoveDownHint());
        iconColumn = new Column<DynamicMenuItem, String>((Cell)iCell){

            public String getValue(DynamicMenuItem object) {
                return "";
            }
        };
        iconColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<DynamicMenuItem, String>(){

            public void update(int index, DynamicMenuItem object, String value) {
                DynamicMenuEditorView.this.presenter.updateIndex(object, index, DynamicMenuEditorPresenter.UpdateIndexOperation.DOWN);
            }
        });
        dynamicMenuTable.addColumn(iconColumn);
        dynamicMenuTable.setColumnWidth(iconColumn, "25px");
        TextColumn<DynamicMenuItem> activityCol = new TextColumn<DynamicMenuItem>(){

            public String getValue(DynamicMenuItem object) {
                return String.valueOf(object.getActivityId());
            }
        };
        dynamicMenuTable.addColumn((Column)activityCol, CommonConstants.INSTANCE.MenusActivityID());
        TextColumn<DynamicMenuItem> labelCol = new TextColumn<DynamicMenuItem>(){

            public String getValue(DynamicMenuItem object) {
                return object.getMenuLabel();
            }
        };
        dynamicMenuTable.addColumn((Column)labelCol, CommonConstants.INSTANCE.MenusLabel());
        ButtonCell buttonCell = new ButtonCell(IconType.REMOVE, ButtonType.DANGER, ButtonSize.MINI);
        TooltipCellDecorator decorator = new TooltipCellDecorator((Cell)buttonCell);
        decorator.setText(CommonConstants.INSTANCE.MenusDeleteHint());
        Column<DynamicMenuItem, String> buttonCol = new Column<DynamicMenuItem, String>((Cell)decorator){

            public String getValue(DynamicMenuItem object) {
                return CommonConstants.INSTANCE.MenusDelete();
            }
        };
        buttonCol.setFieldUpdater((FieldUpdater)new FieldUpdater<DynamicMenuItem, String>(){

            public void update(int index, DynamicMenuItem object, String value) {
                if (DynamicMenuEditorView.this.selectionModel.isSelected((Object)object)) {
                    DynamicMenuEditorView.this.selectionModel.clear();
                }
                DynamicMenuEditorView.this.presenter.removeObject(object);
            }
        });
        dynamicMenuTable.addColumn((Column)buttonCol);
        dynamicMenuTable.setColumnWidth((Column)buttonCol, "80px");
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                if (DynamicMenuEditorView.this.selectionModel.getSelectedObject() == null) {
                    DynamicMenuEditorView.this.driver.edit(new DynamicMenuItem());
                } else {
                    DynamicMenuEditorView.this.driver.edit(DynamicMenuEditorView.this.selectionModel.getSelectedObject());
                }
            }
        });
        this.presenter.setDataDisplay((HasData<DynamicMenuItem>)dynamicMenuTable);
    }

    @UiHandler(value={"okButton"})
    public void onClick(ClickEvent e) {
        DynamicMenuItem menuItem = (DynamicMenuItem)this.driver.flush();
        boolean hasError = false;
        if (menuItem.getActivityId() == null || menuItem.getActivityId().trim().isEmpty()) {
            this.activityIdControlGroup.setType(ControlGroupType.ERROR);
            this.activityIdHelpInline.setText(CommonConstants.INSTANCE.MenusActivityIDIsManatory());
            hasError = true;
        } else if (!activityIdValidator.isValid(menuItem.getActivityId())) {
            this.activityIdControlGroup.setType(ControlGroupType.ERROR);
            this.activityIdHelpInline.setText(activityIdValidator.getValidationError());
            hasError = true;
        } else {
            this.activityIdControlGroup.setType(ControlGroupType.NONE);
            this.activityIdHelpInline.setText("");
        }
        if (menuItem.getMenuLabel() == null || menuItem.getMenuLabel().trim().isEmpty()) {
            this.menuLabelControlGroup.setType(ControlGroupType.ERROR);
            this.menuLabelHelpInline.setText(CommonConstants.INSTANCE.MenusLabelIsManatory());
            hasError = true;
        } else if (!menuLabelValidator.isValid(menuItem.getMenuLabel())) {
            this.menuLabelControlGroup.setType(ControlGroupType.ERROR);
            this.menuLabelHelpInline.setText(menuLabelValidator.getValidationError());
            hasError = true;
        } else {
            this.menuLabelControlGroup.setType(ControlGroupType.NONE);
            this.menuLabelHelpInline.setText("");
        }
        if (hasError) {
            return;
        }
        this.presenter.addMenuItem(menuItem);
        this.setMenuItem(new DynamicMenuItem());
    }

    @UiHandler(value={"cancelButton"})
    public void onCancel(ClickEvent e) {
        this.setMenuItem(new DynamicMenuItem());
    }

    public void setMenuItem(DynamicMenuItem menuItem) {
        this.driver.edit(menuItem);
        this.activityIdControlGroup.setType(ControlGroupType.NONE);
        this.activityIdHelpInline.setText("");
        this.menuLabelControlGroup.setType(ControlGroupType.NONE);
        this.menuLabelHelpInline.setText("");
    }

    static interface Driver
    extends SimpleBeanEditorDriver<DynamicMenuItem, DynamicMenuEditorView> {
    }

    static interface ViewBinder
    extends UiBinder<Widget, DynamicMenuEditorView> {
    }
}

