/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.layout.editor.popups;

import com.github.gwtbootstrap.client.ui.TextArea;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.ext.layout.editor.client.components.ModalConfigurationContext;
import org.uberfire.ext.plugin.client.resources.i18n.CommonConstants;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class EditHTML
extends BaseModal {
    private ModalConfigurationContext configContext;
    private static final String DEFAULT_HTML = "Add your HTML here...";
    @UiField
    TextArea textArea;
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);

    public EditHTML(ModalConfigurationContext ctx) {
        this.configContext = ctx;
        this.setTitle(CommonConstants.INSTANCE.EditHtml());
        this.add((Widget)uiBinder.createAndBindUi((Object)this));
        this.setupHTMLEditor();
        this.add((Widget)new ModalFooterOKCancelButtons(new Command(){

            public void execute() {
                EditHTML.this.okButton();
            }
        }, new Command(){

            public void execute() {
                EditHTML.this.cancelButton();
            }
        }));
    }

    protected KeyDownHandler getEnterDomHandler() {
        return new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                if (!this.isInsideEditHTMLWidget(event) && event.getNativeKeyCode() == 13 && EditHTML.this.handleDefaultAction()) {
                    event.preventDefault();
                    event.stopPropagation();
                }
            }

            private boolean isInsideEditHTMLWidget(KeyDownEvent event) {
                return event.getSource() == EditHTML.this;
            }
        };
    }

    private void setupHTMLEditor() {
        String html = this.configContext.getComponentProperty("HTML_CODE");
        if (html == null || html.isEmpty()) {
            this.textArea.setText(DEFAULT_HTML);
        } else {
            this.textArea.setText(html);
        }
    }

    public void show() {
        super.show();
    }

    void cancelButton() {
        super.hide();
        this.configContext.configurationCancelled();
    }

    void okButton() {
        super.hide();
        this.configContext.setComponentProperty("HTML_CODE", this.textArea.getText());
        this.configContext.configurationFinished();
    }

    static interface Binder
    extends UiBinder<Widget, EditHTML> {
    }

    public static interface Listener {
        public void onSave();

        public void onClose();
    }
}

