/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.explorer;

import com.github.gwtbootstrap.client.ui.DropdownButton;
import com.github.gwtbootstrap.client.ui.NavLink;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.ext.plugin.client.widget.navigator.PluginNavList;
import org.uberfire.ext.plugin.client.widget.popup.NewPluginPopUp;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.plugin.service.PluginServices;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuVisitor;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@Dependent
@WorkbenchScreen(identifier="Plugins Explorer")
public class PluginExplorerScreen
extends Composite {
    private static ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    @UiField
    FlowPanel htmlPanel;
    @Inject
    private NewPluginPopUp newPluginPopUp;
    @Inject
    private PluginNavList pluginNavList;
    @Inject
    private Caller<PluginServices> pluginServices;

    @PostConstruct
    public void init() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        ((PluginServices)this.pluginServices.call((RemoteCallback)new RemoteCallback<Collection<Plugin>>(){

            public void callback(Collection<Plugin> response) {
                PluginExplorerScreen.this.pluginNavList.setup(response);
            }
        })).listPlugins();
        this.htmlPanel.add((Widget)this.pluginNavList);
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Plugins Explorer";
    }

    @WorkbenchMenu
    public Menus buildMenu() {
        return ((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public void accept(MenuVisitor visitor) {
                        visitor.visit((MenuCustom)this);
                    }

                    public IsWidget build() {
                        return PluginExplorerScreen.this.getNewButton();
                    }
                };
            }
        }).endMenu()).build();
    }

    public IsWidget getNewButton() {
        return new DropdownButton("New..."){
            {
                this.setSize(ButtonSize.MINI);
                this.setRightDropdown(true);
                this.add((Widget)new NavLink("New Perspective"){
                    {
                        this.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                PluginExplorerScreen.this.newPluginPopUp.show(PluginType.PERSPECTIVE_LAYOUT);
                            }
                        });
                    }
                });
                this.add((Widget)new NavLink("New Screen"){
                    {
                        this.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                PluginExplorerScreen.this.newPluginPopUp.show(PluginType.SCREEN);
                            }
                        });
                    }
                });
                this.add((Widget)new NavLink("New Editor"){
                    {
                        this.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                PluginExplorerScreen.this.newPluginPopUp.show(PluginType.EDITOR);
                            }
                        });
                    }
                });
                this.add((Widget)new NavLink("New SplashScreen"){
                    {
                        this.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                PluginExplorerScreen.this.newPluginPopUp.show(PluginType.SPLASH);
                            }
                        });
                    }
                });
                this.add((Widget)new NavLink("New Dynamic Menu"){
                    {
                        this.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                PluginExplorerScreen.this.newPluginPopUp.show(PluginType.DYNAMIC_MENU);
                            }
                        });
                    }
                });
            }
        };
    }

    static interface ViewBinder
    extends UiBinder<Widget, PluginExplorerScreen> {
    }
}

