/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.widget.cell;

import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.cell.client.AbstractSafeHtmlCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.text.shared.SafeHtmlRenderer;
import com.google.gwt.text.shared.SimpleSafeHtmlRenderer;

public class IconCell
extends AbstractSafeHtmlCell<String> {
    private IconType iconType;
    private IconSize iconSize;
    private String tooltip;

    public IconCell(IconType iconType) {
        this(iconType, IconSize.DEFAULT);
    }

    public IconCell(IconType iconType, IconSize iconSize) {
        super((SafeHtmlRenderer)SimpleSafeHtmlRenderer.getInstance(), new String[]{"click", "keydown"});
        this.iconType = iconType;
        this.iconSize = iconSize;
    }

    public IconType getIconType() {
        return this.iconType;
    }

    public void setIconType(IconType iconType) {
        this.iconType = iconType;
    }

    public IconSize getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(IconSize iconSize) {
        this.iconSize = iconSize;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    protected void render(Cell.Context context, SafeHtml data, SafeHtmlBuilder sb) {
        sb.appendHtmlConstant("<i" + (this.tooltip == null ? "" : " title=\"" + this.tooltip + "\"") + " class=\"" + this.iconType.get() + " " + this.iconSize.get() + "\"></i>");
    }

    public void onBrowserEvent(Cell.Context context, Element parent, String value, NativeEvent event, ValueUpdater<String> valueUpdater) {
        super.onBrowserEvent(context, parent, (Object)value, event, valueUpdater);
        if ("click".equals(event.getType())) {
            EventTarget eventTarget = event.getEventTarget();
            if (!Element.is((JavaScriptObject)eventTarget)) {
                return;
            }
            if (parent.getFirstChildElement().isOrHasChild((Node)Element.as((JavaScriptObject)eventTarget))) {
                this.onEnterKeyDown(context, parent, value, event, valueUpdater);
            }
        }
    }

    protected void onEnterKeyDown(Cell.Context context, Element parent, String value, NativeEvent event, ValueUpdater<String> valueUpdater) {
        if (valueUpdater != null) {
            valueUpdater.update((Object)value);
        }
    }
}

