/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.layout.editor.popups;

import com.google.gwt.event.shared.SimpleEventBus;
import com.google.gwt.user.client.Event;
import com.google.gwtmockito.GwtMockito;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import com.google.gwtmockito.fakes.FakeProvider;
import java.util.ArrayList;
import org.gwtbootstrap3.client.shared.event.ModalHiddenEvent;
import org.gwtbootstrap3.client.shared.event.ModalHiddenHandler;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.html.Text;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.layout.editor.client.components.ModalConfigurationContext;
import org.uberfire.ext.plugin.client.perspective.editor.layout.editor.popups.EditScreen;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Text.class})
public class EditScreenTest {
    private EditScreenFake editScreen;
    private ModalConfigurationContext ctx;
    private SimpleEventBus simpleEventBus = new SimpleEventBus();
    private ModalHiddenHandler modalHiddenHandler;

    @Before
    public void setup() {
        GwtMockito.useProviderForType(SimpleEventBus.class, (FakeProvider)new FakeProvider(){

            public Object getFake(Class aClass) {
                return EditScreenTest.this.simpleEventBus;
            }
        });
        this.ctx = (ModalConfigurationContext)Mockito.mock(ModalConfigurationContext.class);
        this.editScreen = (EditScreenFake)((Object)Mockito.spy((Object)((Object)new EditScreenFake(this.ctx))));
        Mockito.when((Object)this.editScreen.addHiddenHandler((ModalHiddenHandler)Mockito.any(ModalHiddenHandler.class))).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock aInvocation) throws Throwable {
                EditScreenTest.this.modalHiddenHandler = (ModalHiddenHandler)aInvocation.getArguments()[0];
                return null;
            }
        });
        this.editScreen.realAddHiddenHandler();
    }

    @Test
    public void okButtonClickHandlerTest() {
        this.editScreen.okButton();
        ((EditScreenFake)((Object)Mockito.verify((Object)((Object)this.editScreen)))).hide();
        this.modalHiddenHandler.onHidden(new ModalHiddenEvent((Modal)this.editScreen, new Event(){}));
        ((ModalConfigurationContext)Mockito.verify((Object)this.editScreen.getConfigContext(), (VerificationMode)Mockito.never())).configurationCancelled();
        ((ModalConfigurationContext)Mockito.verify((Object)this.editScreen.getConfigContext())).configurationFinished();
    }

    @Test
    public void cancelButtonClickHandlerTest() {
        this.editScreen.cancelButton();
        ((EditScreenFake)((Object)Mockito.verify((Object)((Object)this.editScreen)))).hide();
        this.modalHiddenHandler.onHidden(new ModalHiddenEvent((Modal)this.editScreen, new Event(){}));
        ((ModalConfigurationContext)Mockito.verify((Object)this.editScreen.getConfigContext())).configurationCancelled();
        ((ModalConfigurationContext)Mockito.verify((Object)this.editScreen.getConfigContext(), (VerificationMode)Mockito.never())).configurationFinished();
    }

    @Test
    public void closeButtonClickHandlerTest() {
        this.modalHiddenHandler.onHidden(new ModalHiddenEvent((Modal)this.editScreen, new Event(){}));
        ((ModalConfigurationContext)Mockito.verify((Object)this.editScreen.getConfigContext())).configurationCancelled();
        ((ModalConfigurationContext)Mockito.verify((Object)this.editScreen.getConfigContext(), (VerificationMode)Mockito.never())).configurationFinished();
    }

    private class EditScreenFake
    extends EditScreen {
        public EditScreenFake(ModalConfigurationContext ctx) {
            super(ctx);
        }

        public void realAddHiddenHandler() {
            super.addHiddenHandler();
        }

        public void addHiddenHandler() {
        }

        protected void getScreensId() {
            this.availableWorkbenchScreensIds = new ArrayList();
            this.availableWorkbenchScreensIds.add("screen");
        }
    }
}

