/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.ext.editor.commons.client.BaseEditor;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.service.support.SupportsCopy;
import org.uberfire.ext.editor.commons.service.support.SupportsDelete;
import org.uberfire.ext.editor.commons.service.support.SupportsRename;
import org.uberfire.ext.layout.editor.client.LayoutEditorPlugin;
import org.uberfire.ext.layout.editor.client.components.LayoutDragComponent;
import org.uberfire.ext.plugin.client.perspective.editor.api.PerspectiveEditorDragComponent;
import org.uberfire.ext.plugin.client.perspective.editor.components.popup.AddTag;
import org.uberfire.ext.plugin.client.perspective.editor.generator.PerspectiveEditorGenerator;
import org.uberfire.ext.plugin.client.type.PerspectiveLayoutPluginResourceType;
import org.uberfire.ext.plugin.client.validation.PluginNameValidator;
import org.uberfire.ext.plugin.event.PluginRenamed;
import org.uberfire.ext.plugin.model.LayoutEditorModel;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.plugin.service.PluginServices;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="Perspective Editor", supportedTypes={PerspectiveLayoutPluginResourceType.class}, priority=0x7FFFFFFF)
public class PerspectiveEditorPresenter
extends BaseEditor {
    private final View perspectiveEditorView;
    @Inject
    private PerspectiveEditorGenerator perspectiveEditorGenerator;
    @Inject
    private LayoutEditorPlugin layoutEditorPlugin;
    @Inject
    private Event<NotificationEvent> ufNotification;
    @Inject
    private PerspectiveLayoutPluginResourceType resourceType;
    @Inject
    private Caller<PluginServices> pluginServices;
    @Inject
    private PluginNameValidator pluginNameValidator;
    private Plugin plugin;

    @Inject
    public PerspectiveEditorPresenter(View perspectiveEditorView) {
        super((BaseEditorView)perspectiveEditorView);
        this.perspectiveEditorView = perspectiveEditorView;
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        this.init(path, place, this.resourceType, true, false, new MenuItems[]{MenuItems.SAVE, MenuItems.COPY, MenuItems.RENAME, MenuItems.DELETE});
        String name = place.getParameter("name", "");
        this.plugin = new Plugin(name, PluginType.PERSPECTIVE_LAYOUT, (Path)path);
        this.layoutEditorPlugin.init(name, this.lookupPerspectiveDragComponents());
        this.perspectiveEditorView.setupLayoutEditor(this.layoutEditorPlugin.asWidget());
    }

    protected List<LayoutDragComponent> lookupPerspectiveDragComponents() {
        ArrayList<LayoutDragComponent> result = new ArrayList<LayoutDragComponent>();
        Collection beanDefs = IOC.getBeanManager().lookupBeans(PerspectiveEditorDragComponent.class);
        for (IOCBeanDef beanDef : beanDefs) {
            PerspectiveEditorDragComponent dragComponent = (PerspectiveEditorDragComponent)beanDef.getInstance();
            result.add(dragComponent);
        }
        return result;
    }

    protected void makeMenuBar() {
        super.makeMenuBar();
        this.menuBuilder.addNewTopLevelMenu((MenuItem)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)CommonConstants.INSTANCE.Tags()).respondsWith(new Command(){

            public void execute() {
                AddTag addTag = new AddTag(PerspectiveEditorPresenter.this);
                addTag.show();
            }
        })).endMenu()).build().getItems().get(0));
    }

    @OnMayClose
    public boolean onMayClose() {
        return super.mayClose(Integer.valueOf(this.getCurrentModelHash()));
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return org.uberfire.ext.plugin.client.resources.i18n.CommonConstants.INSTANCE.PerspectiveEditor() + " [" + this.plugin.getName() + "]";
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }

    @WorkbenchPartView
    public UberView<PerspectiveEditorPresenter> getWidget() {
        return (UberView)this.baseView;
    }

    protected void loadContent() {
        this.baseView.hideBusyIndicator();
        this.layoutEditorPlugin.load(PluginType.PERSPECTIVE_LAYOUT, (Path)this.versionRecordManager.getCurrentPath(), (ParameterizedCommand)new ParameterizedCommand<LayoutEditorModel>(){

            public void execute(LayoutEditorModel layoutEditorModel) {
                PerspectiveEditorPresenter.this.setOriginalHash(PerspectiveEditorPresenter.this.getCurrentModelHash());
                PerspectiveEditorPresenter.this.plugin = (Plugin)layoutEditorModel;
            }
        });
    }

    protected void save() {
        this.layoutEditorPlugin.save((Path)this.versionRecordManager.getCurrentPath(), this.getSaveSuccessCallback(this.getCurrentModelHash()));
        this.concurrentUpdateSessionInfo = null;
    }

    protected RemoteCallback<Path> getSaveSuccessCallback(int newHash) {
        return new RemoteCallback<Path>(){

            public void callback(Path path) {
                RemoteCallback saveSuccessCallback = PerspectiveEditorPresenter.super.getSaveSuccessCallback(PerspectiveEditorPresenter.this.getCurrentModelHash());
                saveSuccessCallback.callback((Object)path);
                PerspectiveEditorPresenter.this.perspectiveEditorGenerator.generate(PerspectiveEditorPresenter.this.layoutEditorPlugin.getLayout());
            }
        };
    }

    public int getCurrentModelHash() {
        return this.layoutEditorPlugin.getLayout().hashCode();
    }

    protected void onPlugInRenamed(@Observes PluginRenamed pluginRenamed) {
        if (pluginRenamed.getOldPluginName().equals(this.plugin.getName()) && pluginRenamed.getPlugin().getType().equals((Object)this.plugin.getType())) {
            this.plugin = new Plugin(pluginRenamed.getPlugin().getName(), PluginType.PERSPECTIVE_LAYOUT, pluginRenamed.getPlugin().getPath());
            this.changeTitleNotification.fire((Object)new ChangeTitleWidgetEvent(this.place, this.getTitleText(), this.getTitle()));
        }
    }

    public Validator getRenameValidator() {
        return this.pluginNameValidator;
    }

    public Validator getCopyValidator() {
        return this.pluginNameValidator;
    }

    protected Caller<? extends SupportsDelete> getDeleteServiceCaller() {
        return this.pluginServices;
    }

    protected Caller<? extends SupportsRename> getRenameServiceCaller() {
        return this.pluginServices;
    }

    protected Caller<? extends SupportsCopy> getCopyServiceCaller() {
        return this.pluginServices;
    }

    public void saveProperty(String key, String value) {
        this.layoutEditorPlugin.addLayoutProperty(key, value);
    }

    public String getLayoutProperty(String key) {
        return this.layoutEditorPlugin.getLayoutProperty(key);
    }

    public static interface View
    extends BaseEditorView {
        public void setupLayoutEditor(Widget var1);
    }
}

