/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.generator;

import java.lang.annotation.Annotation;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.QualifierUtil;
import org.jboss.errai.ioc.client.api.AfterInitialization;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManagerImpl;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.WorkbenchScreenActivity;
import org.uberfire.ext.layout.editor.api.LayoutServices;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.client.generator.LayoutGenerator;
import org.uberfire.ext.plugin.client.perspective.editor.generator.PerspectiveEditorActivity;
import org.uberfire.ext.plugin.client.perspective.editor.generator.PerspectiveEditorScreenActivity;
import org.uberfire.ext.plugin.model.LayoutEditorModel;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.plugin.service.PluginServices;

@ApplicationScoped
public class PerspectiveEditorGenerator {
    private SyncBeanManagerImpl beanManager;
    private ActivityBeansCache activityBeansCache;
    @Inject
    private LayoutGenerator layoutGenerator;
    @Inject
    private Caller<PluginServices> pluginServices;
    @Inject
    private Caller<LayoutServices> layoutServices;

    @PostConstruct
    public void setup() {
        this.beanManager = (SyncBeanManagerImpl)IOC.getBeanManager();
        this.activityBeansCache = (ActivityBeansCache)this.beanManager.lookupBean(ActivityBeansCache.class, new Annotation[0]).getInstance();
    }

    @AfterInitialization
    public void loadPerspectives() {
        ((PluginServices)this.pluginServices.call((RemoteCallback)new RemoteCallback<Collection<LayoutEditorModel>>(){

            public void callback(Collection<LayoutEditorModel> response) {
                for (LayoutEditorModel layoutEditorModel : response) {
                    PerspectiveEditorGenerator.this.generatePerspective(layoutEditorModel);
                }
            }
        })).listLayoutEditor(PluginType.PERSPECTIVE_LAYOUT);
    }

    private void generatePerspective(LayoutEditorModel model) {
        ((LayoutServices)this.layoutServices.call((RemoteCallback)new RemoteCallback<LayoutTemplate>(){

            public void callback(LayoutTemplate perspective) {
                if (perspective != null) {
                    PerspectiveEditorGenerator.this.generate(perspective);
                }
            }
        })).convertLayoutFromString(model.getLayoutEditorModel());
    }

    public void generate(LayoutTemplate layoutTemplate) {
        if (this.isANewPerspective(layoutTemplate)) {
            PerspectiveEditorScreenActivity screen = this.createNewScreen(layoutTemplate);
            this.createNewPerspective(layoutTemplate, screen);
        } else {
            PerspectiveEditorScreenActivity screen = this.updateScreen(layoutTemplate);
            this.updatePerspective(layoutTemplate, screen);
        }
    }

    private void updatePerspective(LayoutTemplate layoutTemplate, PerspectiveEditorScreenActivity screen) {
        IOCBeanDef activity = this.activityBeansCache.getActivity(layoutTemplate.getName());
        PerspectiveEditorActivity perspectiveEditorActivity = (PerspectiveEditorActivity)activity.getInstance();
        perspectiveEditorActivity.update(layoutTemplate, screen);
    }

    private PerspectiveEditorScreenActivity updateScreen(LayoutTemplate layoutTemplate) {
        IOCBeanDef activity = this.activityBeansCache.getActivity(layoutTemplate.getName() + PerspectiveEditorScreenActivity.screenSufix());
        PerspectiveEditorScreenActivity screenActivity = (PerspectiveEditorScreenActivity)activity.getInstance();
        screenActivity.setLayoutTemplate(layoutTemplate);
        return screenActivity;
    }

    private void createNewPerspective(LayoutTemplate perspective, PerspectiveEditorScreenActivity screen) {
        PerspectiveEditorActivity activity = new PerspectiveEditorActivity(perspective, screen);
        this.beanManager.addBean(PerspectiveActivity.class, PerspectiveEditorActivity.class, null, (Object)activity, QualifierUtil.DEFAULT_QUALIFIERS, perspective.getName(), true, null);
        this.activityBeansCache.addNewPerspectiveActivity((IOCBeanDef)this.beanManager.lookupBeans(perspective.getName()).iterator().next());
    }

    private PerspectiveEditorScreenActivity createNewScreen(LayoutTemplate perspective) {
        PerspectiveEditorScreenActivity activity = new PerspectiveEditorScreenActivity(perspective, this.layoutGenerator);
        this.beanManager.addBean(Activity.class, PerspectiveEditorScreenActivity.class, null, (Object)activity, QualifierUtil.DEFAULT_QUALIFIERS, activity.getIdentifier(), true, null);
        this.beanManager.addBean(WorkbenchScreenActivity.class, PerspectiveEditorScreenActivity.class, null, (Object)activity, QualifierUtil.DEFAULT_QUALIFIERS, activity.getIdentifier(), true, null);
        this.beanManager.addBean(PerspectiveEditorScreenActivity.class, PerspectiveEditorScreenActivity.class, null, (Object)activity, QualifierUtil.DEFAULT_QUALIFIERS, activity.getIdentifier(), true, null);
        this.activityBeansCache.addNewScreenActivity((IOCBeanDef)this.beanManager.lookupBeans(activity.getIdentifier()).iterator().next());
        return activity;
    }

    private boolean isANewPerspective(LayoutTemplate layoutTemplate) {
        IOCBeanDef activity = this.activityBeansCache.getActivity(layoutTemplate.getName());
        return activity == null;
    }
}

