/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.layout.editor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.InputSize;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.layout.editor.client.components.HasModalConfiguration;
import org.uberfire.ext.layout.editor.client.components.ModalConfigurationContext;
import org.uberfire.ext.layout.editor.client.components.RenderingContext;
import org.uberfire.ext.plugin.client.perspective.editor.api.PerspectiveEditorDragComponent;
import org.uberfire.ext.plugin.client.perspective.editor.layout.editor.popups.EditScreen;
import org.uberfire.ext.plugin.client.resources.i18n.CommonConstants;
import org.uberfire.ext.properties.editor.model.PropertyEditorChangeEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@ApplicationScoped
public class ScreenLayoutDragComponent
implements PerspectiveEditorDragComponent,
HasModalConfiguration {
    public static final String PLACE_NAME_PARAMETER = "Place Name";
    @Inject
    private PlaceManager placeManager;
    private ModalConfigurationContext configContext;

    public IsWidget getDragWidget() {
        TextBox textBox = (TextBox)GWT.create(TextBox.class);
        textBox.setPlaceholder(CommonConstants.INSTANCE.ScreenComponent());
        textBox.setReadOnly(true);
        textBox.setSize(InputSize.DEFAULT);
        return textBox;
    }

    public IsWidget getPreviewWidget(RenderingContext ctx) {
        Map properties = ctx.getComponent().getProperties();
        String placeName = (String)properties.get(PLACE_NAME_PARAMETER);
        if (placeName == null) {
            return null;
        }
        FlowPanel panel = new FlowPanel();
        panel.setWidth("95%");
        panel.setHeight("500px");
        this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest(placeName, properties), (HasWidgets)panel);
        return panel;
    }

    public IsWidget getShowWidget(RenderingContext ctx) {
        Map properties = ctx.getComponent().getProperties();
        String placeName = (String)properties.get(PLACE_NAME_PARAMETER);
        if (placeName == null) {
            return null;
        }
        FlowPanel panel = new FlowPanel();
        panel.setWidth("95%");
        panel.setHeight("500px");
        this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest(placeName, properties), (HasWidgets)panel);
        return panel;
    }

    public Modal getConfigurationModal(ModalConfigurationContext ctx) {
        this.configContext = ctx;
        return new EditScreen(ctx);
    }

    public void observeEditComponentEventFromPropertyEditor(@Observes PropertyEditorChangeEvent event) {
        PropertyEditorFieldInfo property = event.getProperty();
        if (property.getEventId().equalsIgnoreCase(EditScreen.PROPERTY_EDITOR_KEY)) {
            this.configContext.setComponentProperty(property.getLabel(), property.getCurrentStringValue());
        }
    }
}

