/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.validation;

import java.util.Collection;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.ext.editor.commons.client.validation.DefaultFileNameValidator;
import org.uberfire.ext.editor.commons.client.validation.ValidationErrorReason;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;
import org.uberfire.ext.plugin.client.info.PluginsInfo;
import org.uberfire.ext.plugin.client.validation.NameValidator;
import org.uberfire.ext.plugin.client.validation.RuleValidator;
import org.uberfire.ext.plugin.model.Activity;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.service.PluginServices;

@ApplicationScoped
public class PluginNameValidator
implements Validator {
    @Inject
    private PluginsInfo pluginsInfo;
    @Inject
    private DefaultFileNameValidator defaultFileNameValidator;
    @Inject
    Caller<PluginServices> pluginServices;

    public void validate(final String name, final ValidatorCallback callback) {
        this.validateName(name, new ValidatorWithReasonCallback(){

            public void onFailure(String reason) {
                if (PluginNameValidator.this.shouldGiveReasonOfValidationError(callback)) {
                    ((ValidatorWithReasonCallback)callback).onFailure(reason);
                } else {
                    callback.onFailure();
                }
            }

            public void onSuccess() {
                PluginNameValidator.this.defaultFileNameValidator.validate(name, callback);
            }

            public void onFailure() {
                callback.onFailure();
            }
        });
    }

    private boolean shouldGiveReasonOfValidationError(ValidatorCallback callback) {
        return callback instanceof ValidatorWithReasonCallback;
    }

    protected void validateName(String name, final ValidatorWithReasonCallback callback) {
        final String nameWithoutExtension = name.lastIndexOf(".") >= 0 ? name.substring(0, name.lastIndexOf(".")) : name;
        RuleValidator nameValidator = this.getNameValidator();
        if (!nameValidator.isValid(nameWithoutExtension)) {
            callback.onFailure(nameValidator.getValidationError());
            return;
        }
        ((PluginServices)this.pluginServices.call((RemoteCallback)new RemoteCallback<Collection<Plugin>>(){

            public void callback(Collection<Plugin> plugins) {
                Set<Activity> activities = PluginNameValidator.this.pluginsInfo.getAllPlugins(plugins);
                for (Activity activity : activities) {
                    if (!activity.getName().equalsIgnoreCase(nameWithoutExtension)) continue;
                    callback.onFailure(ValidationErrorReason.DUPLICATED_NAME.name());
                    return;
                }
                callback.onSuccess();
            }
        })).listPlugins();
    }

    private RuleValidator getNameValidator() {
        return NameValidator.createNameValidator(ValidationErrorReason.EMPTY_NAME.name(), ValidationErrorReason.INVALID_NAME.name());
    }
}

