/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.explorer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.ext.plugin.client.resources.i18n.CommonConstants;
import org.uberfire.ext.plugin.client.security.PluginController;
import org.uberfire.ext.plugin.client.widget.navigator.PluginNavList;
import org.uberfire.ext.plugin.client.widget.popup.NewPluginPopUp;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.plugin.service.PluginServices;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuVisitor;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@Dependent
@WorkbenchScreen(identifier="Plugins Explorer")
public class PluginExplorerScreen
extends Composite {
    private static ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    private CommonConstants constants = CommonConstants.INSTANCE;
    @UiField
    FlowPanel htmlPanel;
    @Inject
    private NewPluginPopUp newPluginPopUp;
    @Inject
    private PluginNavList pluginNavList;
    @Inject
    private Caller<PluginServices> pluginServices;
    @Inject
    private PluginController pluginController;

    @PostConstruct
    public void init() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        ((PluginServices)this.pluginServices.call((RemoteCallback)new RemoteCallback<Collection<Plugin>>(){

            public void callback(Collection<Plugin> plugins) {
                PluginExplorerScreen.this.pluginNavList.setup(plugins);
            }
        })).listPlugins();
        this.htmlPanel.add((Widget)this.pluginNavList);
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.PluginsExplorer();
    }

    @WorkbenchMenu
    public Menus buildMenu() {
        return ((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public void accept(MenuVisitor visitor) {
                        visitor.visit((MenuCustom)this);
                    }

                    public IsWidget build() {
                        return PluginExplorerScreen.this.getNewButton();
                    }
                };
            }
        }).endMenu()).build();
    }

    public IsWidget getNewButton() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.addStyleName("pull-right");
        buttonGroup.add((Widget)new Button(){
            {
                this.setSize(ButtonSize.SMALL);
                this.setDataToggle(Toggle.DROPDOWN);
            }
        });
        DropDownMenu dropDownMenu = new DropDownMenu();
        this.addNewAnchorLink(dropDownMenu, CommonConstants.INSTANCE.NewPerspective(), PluginType.PERSPECTIVE_LAYOUT, this.pluginController.canCreatePerspectives());
        this.addNewAnchorLink(dropDownMenu, CommonConstants.INSTANCE.NewScreen(), PluginType.SCREEN, true);
        this.addNewAnchorLink(dropDownMenu, CommonConstants.INSTANCE.NewEditor(), PluginType.EDITOR, true);
        this.addNewAnchorLink(dropDownMenu, CommonConstants.INSTANCE.NewSplashScreen(), PluginType.SPLASH, true);
        this.addNewAnchorLink(dropDownMenu, CommonConstants.INSTANCE.NewDynamicMenu(), PluginType.DYNAMIC_MENU, true);
        buttonGroup.add((Widget)dropDownMenu);
        return buttonGroup;
    }

    private void addNewAnchorLink(DropDownMenu dropDownMenu, String text, PluginType pluginType, boolean available) {
        if (available) {
            AnchorListItem anchor = new AnchorListItem(text);
            anchor.addClickHandler(event -> this.newPluginPopUp.show(pluginType));
            dropDownMenu.add((Widget)anchor);
        }
    }

    static interface ViewBinder
    extends UiBinder<Widget, PluginExplorerScreen> {
    }
}

