/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.layout.editor.popups;

import com.google.gwt.user.client.Event;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Modal;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.TemplateWidgetMapper;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.SinkNative;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.ext.editor.commons.client.file.popups.CommonModalBuilder;
import org.uberfire.ext.plugin.client.perspective.editor.layout.editor.popups.EditHTMLPresenter;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.ButtonPressed;

@Dependent
@Templated
public class EditHTMLView
implements EditHTMLPresenter.View {
    private final TranslationService translationService;
    private EditHTMLPresenter presenter;
    private BaseModal modal;
    private ButtonPressed buttonPressed = ButtonPressed.CLOSE;
    @Inject
    @DataField(value="body")
    Div body;
    @Inject
    @DataField(value="footer")
    Div footer;

    @Inject
    public EditHTMLView(TranslationService translationService) {
        this.translationService = translationService;
    }

    public void init(EditHTMLPresenter presenter) {
        this.presenter = presenter;
        this.modalSetup();
    }

    private void modalSetup() {
        this.body.appendChild((Node)this.presenter.getHtmlEditorView().getElement());
        this.modal = new CommonModalBuilder().addHeader(this.translationService.format("EditHTMLView.Title", new Object[0])).addBody((HTMLElement)this.body).addFooter((HTMLElement)this.footer).build();
        this.modal.addHiddenHandler(hiddenEvent -> {
            if (ButtonPressed.CLOSE.equals((Object)this.buttonPressed)) {
                this.presenter.closeClick();
            }
        });
        this.modal.setWidth("960px");
    }

    @Override
    public void show() {
        this.modal.show();
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    @Override
    public String getHtmlEditorPlaceHolder() {
        return this.translationService.format("EditHTMLView.HtmlPlaceHolder", new Object[0]);
    }

    @Override
    public Modal getModal() {
        return this.modal;
    }

    public HTMLElement getElement() {
        return (HTMLElement)TemplateWidgetMapper.get((Object)this.modal).getElement().cast();
    }

    @SinkNative(value=1)
    @EventHandler(value={"okButton"})
    public void okClick(Event event) {
        this.buttonPressed = ButtonPressed.OK;
        this.presenter.okClick();
    }

    @SinkNative(value=1)
    @EventHandler(value={"cancelButton"})
    public void cancelClick(Event event) {
        this.buttonPressed = ButtonPressed.CANCEL;
        this.presenter.cancelClick();
    }
}

