/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.widget.media;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Caption;
import org.gwtbootstrap3.client.ui.Column;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.Image;
import org.gwtbootstrap3.client.ui.Row;
import org.gwtbootstrap3.client.ui.ThumbnailPanel;
import org.gwtbootstrap3.client.ui.base.form.AbstractForm;
import org.gwtbootstrap3.client.ui.constants.ColumnSize;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.ImageType;
import org.gwtbootstrap3.client.ui.html.Paragraph;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.plugin.client.config.PluginConfigService;
import org.uberfire.ext.plugin.event.MediaAdded;
import org.uberfire.ext.plugin.event.MediaDeleted;
import org.uberfire.ext.plugin.model.Media;
import org.uberfire.ext.widgets.common.client.common.FileUpload;
import org.uberfire.ext.widgets.common.client.common.FileUploadFormEncoder;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
public class MediaLibraryWidget
extends Composite
implements RequiresResize {
    private static ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    private FileUploadFormEncoder formEncoder = new FileUploadFormEncoder();
    @UiField
    FlowPanel content;
    @UiField
    Form form;
    @UiField(provided=true)
    FileUpload fileUpload;
    @UiField
    Row library;
    @Inject
    private PluginConfigService pluginConfigService;
    private String pluginName;
    private ParameterizedCommand<Media> onMediaDelete;
    private Map<Path, IsWidget> mediaRef = new HashMap<Path, IsWidget>();
    private List<Command> updateMediaOnSaveCommands = new ArrayList<Command>();
    private List<Command> updateMediaOnCloseCommands = new ArrayList<Command>();

    @PostConstruct
    public void init() {
        this.fileUpload = this.createFileUpload();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.form.setEncoding("multipart/form-data");
        this.form.setMethod("post");
        this.formEncoder.addUtf8Charset(this.form);
        this.form.addSubmitHandler(new AbstractForm.SubmitHandler(){

            public void onSubmit(AbstractForm.SubmitEvent event) {
                String fileName = MediaLibraryWidget.this.fileUpload.getFilename();
                if (this.isNullOrEmpty(fileName)) {
                    event.cancel();
                }
            }

            private boolean isNullOrEmpty(String fileName) {
                return fileName == null || "".equals(fileName);
            }
        });
        this.form.addSubmitCompleteHandler(new AbstractForm.SubmitCompleteHandler(){

            public void onSubmitComplete(AbstractForm.SubmitCompleteEvent event) {
                if ("OK".equalsIgnoreCase(event.getResults())) {
                    Window.alert((String)"Upload Success");
                } else if ("FAIL".equalsIgnoreCase(event.getResults())) {
                    Window.alert((String)"Upload Failed");
                } else if ("FAIL - ALREADY EXISTS".equalsIgnoreCase(event.getResults())) {
                    Window.alert((String)"File already exists");
                }
            }
        });
    }

    public void setup(String pluginName, Collection<Media> mediaLibrary, ParameterizedCommand<Media> onMediaDelete) {
        this.pluginName = pluginName;
        this.onMediaDelete = onMediaDelete;
        this.mediaRef.clear();
        this.library.clear();
        for (Media media : mediaLibrary) {
            this.addMedia(media);
        }
    }

    private FileUpload createFileUpload() {
        return new FileUpload(new Command(){

            public void execute() {
                MediaLibraryWidget.this.form.setAction(GWT.getHostPageBaseURL().replaceAll("/" + GWT.getModuleName(), "") + MediaLibraryWidget.this.pluginConfigService.getMediaServletURI() + MediaLibraryWidget.this.pluginName);
                MediaLibraryWidget.this.form.submit();
            }
        }, true);
    }

    public void onResize() {
        this.getParent().getElement().getStyle().setBackgroundColor("#F6F6F6");
        this.content.getElement().getStyle().setTop(60.0, Style.Unit.PX);
    }

    public void onNewMedia(@Observes MediaAdded mediaAddedEvent) {
        if (mediaAddedEvent.getPluginName().equals(this.pluginName)) {
            final Media media = mediaAddedEvent.getMedia();
            this.addMedia(media);
            this.updateMediaOnCloseCommands.add(new Command(){

                public void execute() {
                    MediaLibraryWidget.this.onMediaDelete.execute((Object)media);
                }
            });
        }
    }

    public void onMediaDelete(@Observes MediaDeleted mediaDeleted) {
        IsWidget thumb;
        if (mediaDeleted.getPluginName().equals(this.pluginName) && (thumb = this.mediaRef.get(mediaDeleted.getMedia().getPath())) != null) {
            this.library.remove(thumb);
        }
    }

    public void addMedia(final Media media) {
        Column column = new Column(ColumnSize.XS_4, new ColumnSize[0]);
        final Button trash = new Button();
        trash.setIcon(IconType.TRASH);
        ThumbnailPanel thumbnail = new ThumbnailPanel(){
            {
                this.add((Widget)new Image(media.getPreviewURI()){
                    {
                        this.setType(ImageType.CIRCLE);
                        this.setHeight("140px");
                        this.setWidth("140px");
                    }
                });
                this.add((Widget)new Caption(){
                    {
                        this.add((Widget)new Paragraph(media.getExternalURI()){
                            {
                                this.getElement().getStyle().setProperty("maxWidth", "180px");
                            }
                        });
                        this.add((Widget)new Paragraph(){
                            {
                                this.add((Widget)trash);
                            }
                        });
                    }
                });
            }
        };
        trash.addClickHandler(this.getTrashClickHandler(media, column));
        column.add((Widget)thumbnail);
        this.library.add((Widget)column);
        this.mediaRef.put(media.getPath(), (IsWidget)column);
    }

    private ClickHandler getTrashClickHandler(final Media media, Column column) {
        return event -> {
            this.mediaRef.remove(media.getPath());
            this.updateMediaOnSaveCommands.add(new Command(){

                public void execute() {
                    MediaLibraryWidget.this.onMediaDelete.execute((Object)media);
                }
            });
            this.library.remove((Widget)column);
        };
    }

    public void updateMediaOnClose() {
        for (Command command : this.updateMediaOnCloseCommands) {
            command.execute();
        }
    }

    public void updateMediaOnSave() {
        for (Command command : this.updateMediaOnSaveCommands) {
            command.execute();
        }
        this.updateMediaOnCloseCommands = new ArrayList<Command>();
    }

    static interface ViewBinder
    extends UiBinder<Widget, MediaLibraryWidget> {
    }
}

