/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.widget.plugin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.NavPills;
import org.uberfire.ext.plugin.client.code.CodeElement;
import org.uberfire.ext.plugin.client.widget.media.MediaLibraryWidget;
import org.uberfire.ext.plugin.client.widget.split.HorizontalSplit;
import org.uberfire.ext.plugin.client.widget.split.VerticalSplit;
import org.uberfire.ext.plugin.model.CodeType;
import org.uberfire.ext.plugin.model.Media;
import org.uberfire.ext.plugin.model.PluginContent;
import org.uberfire.ext.widgets.common.client.ace.AceEditor;
import org.uberfire.ext.widgets.common.client.ace.AceEditorMode;
import org.uberfire.ext.widgets.common.client.ace.AceEditorTheme;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
public class GeneralPluginEditor
extends Composite
implements RequiresResize {
    private static ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    @UiField
    FlowPanel content;
    @UiField
    VerticalSplit verticalSplit;
    @UiField
    HorizontalSplit leftHorizontalSplit;
    @UiField
    HorizontalSplit rightHorizontalSplit;
    @UiField
    FlowPanel leftArea;
    @UiField
    FlowPanel leftTopArea;
    @UiField
    FlowPanel leftTopContent;
    @UiField
    FlowPanel leftBottomArea;
    @UiField
    FlowPanel leftBottomContent;
    @UiField
    FlowPanel rightArea;
    @UiField
    FlowPanel rightTopArea;
    @UiField
    FlowPanel rightTopContent;
    @UiField
    FlowPanel rightBottomArea;
    @UiField
    NavPills lifecycleHolder;
    @UiField
    Button lifecycle;
    @UiField
    DropDownMenu lifecycles;
    @UiField
    FlowPanel rightBottomContent;
    @Inject
    private MediaLibraryWidget mediaLibraryWidget;
    @Inject
    private AceEditor templateEditor;
    @Inject
    private AceEditor cssEditor;
    @Inject
    private AceEditor jsEditor;
    private Map<CodeType, String> codeMap = new HashMap<CodeType, String>();
    private CodeType currentElement = null;
    private PluginContent pluginContent;
    final Command editorResizing = new Command(){

        public void execute() {
            GeneralPluginEditor.this.templateEditor.redisplay();
            GeneralPluginEditor.this.cssEditor.redisplay();
            Double editorHeight = 100.0 - (double)GeneralPluginEditor.this.lifecycleHolder.getOffsetHeight() / (double)GeneralPluginEditor.this.leftBottomArea.getOffsetHeight() * 100.0;
            if (Double.isNaN(editorHeight) || editorHeight <= 0.0) {
                return;
            }
            GeneralPluginEditor.this.jsEditor.setHeight(editorHeight + "%");
            GeneralPluginEditor.this.jsEditor.redisplay();
        }
    };
    final ParameterizedCommand<CodeType> codeChange = new ParameterizedCommand<CodeType>(){

        public void execute(CodeType parameter) {
            GeneralPluginEditor.this.codeMap.put(GeneralPluginEditor.this.currentElement, GeneralPluginEditor.this.jsEditor.getText());
            GeneralPluginEditor.this.currentElement = parameter;
            String content = (String)GeneralPluginEditor.this.codeMap.get(GeneralPluginEditor.this.currentElement);
            if (content != null) {
                GeneralPluginEditor.this.jsEditor.setText(content);
            } else {
                GeneralPluginEditor.this.jsEditor.setText("");
            }
            GeneralPluginEditor.this.jsEditor.setFocus();
        }
    };

    @PostConstruct
    public void init() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.rightBottomContent.add((Widget)this.mediaLibraryWidget);
        this.verticalSplit.init((Widget)this.leftArea, (Widget)this.rightArea, (Widget)this.content, this.editorResizing);
        this.leftHorizontalSplit.init((Widget)this.leftTopArea, (Widget)this.leftBottomArea, (Widget)this.content, this.editorResizing);
        this.rightHorizontalSplit.init((Widget)this.rightTopArea, (Widget)this.rightBottomArea, (Widget)this.content, this.editorResizing);
        this.setupEditor(this.templateEditor, this.leftTopContent);
        this.setupEditor(this.cssEditor, this.rightTopContent);
        this.setupEditor(this.jsEditor, this.leftBottomContent);
        this.templateEditor.startEditor();
        this.templateEditor.setMode(AceEditorMode.HTML);
        this.templateEditor.setTheme(AceEditorTheme.CHROME);
        this.cssEditor.startEditor();
        this.cssEditor.setMode(AceEditorMode.CSS);
        this.cssEditor.setTheme(AceEditorTheme.CHROME);
        this.jsEditor.startEditor();
        this.jsEditor.setMode(AceEditorMode.JAVASCRIPT);
        this.jsEditor.setTheme(AceEditorTheme.CHROME);
    }

    public void setup(CodeElement ... elements) {
        this.lifecycle.setIcon(elements[0].getIcon());
        this.lifecycle.setText(elements[0].toString());
        this.currentElement = elements[0].getType();
        for (CodeElement element : elements) {
            element.addNav(this.lifecycles, this.lifecycle, this.codeChange);
        }
    }

    public void setupContent(PluginContent pluginContent, ParameterizedCommand<Media> onMediaDelete) {
        this.codeMap.clear();
        for (Map.Entry entry : pluginContent.getCodeMap().entrySet()) {
            this.codeMap.put((CodeType)entry.getKey(), (String)entry.getValue());
        }
        this.jsEditor.setText(this.codeMap.get(this.currentElement));
        this.templateEditor.setText(pluginContent.getTemplate());
        this.cssEditor.setText(pluginContent.getCss());
        this.mediaLibraryWidget.setup(pluginContent.getName(), pluginContent.getMediaLibrary(), onMediaDelete);
        this.pluginContent = pluginContent;
    }

    private void setupEditor(AceEditor editor, FlowPanel content) {
        editor.setWidth("100%");
        editor.setHeight("100%");
        content.add((Widget)editor);
    }

    public PluginContent getContent() {
        return this.pluginContent;
    }

    public boolean isDirty() {
        return false;
    }

    public Map<CodeType, String> getCodeMap() {
        this.codeMap.put(this.currentElement, this.jsEditor.getText());
        return this.codeMap;
    }

    public String getTemplate() {
        return this.templateEditor.getText();
    }

    public String getCss() {
        return this.cssEditor.getText();
    }

    public void onResize() {
        this.getParent().getElement().getStyle().setBackgroundColor("#F6F6F6");
        this.content.getElement().getStyle().setTop(60.0, Style.Unit.PX);
        this.verticalSplit.getElement().getStyle().setLeft((double)(this.leftArea.getOffsetWidth() - 3), Style.Unit.PX);
        this.leftHorizontalSplit.getElement().getStyle().setTop((double)(this.leftTopArea.getOffsetHeight() - 6), Style.Unit.PX);
        this.rightHorizontalSplit.getElement().getStyle().setTop((double)(this.rightTopArea.getOffsetHeight() - 6), Style.Unit.PX);
        this.editorResizing.execute();
    }

    public void onSave() {
        this.mediaLibraryWidget.updateMediaOnSave();
    }

    public void onClose() {
        this.mediaLibraryWidget.updateMediaOnClose();
    }

    static interface ViewBinder
    extends UiBinder<Widget, GeneralPluginEditor> {
    }
}

