/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.layout.editor;

import java.util.ArrayList;
import org.jgroups.util.Util;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.client.mvp.ActivityBeansInfo;
import org.uberfire.ext.plugin.client.perspective.editor.layout.editor.ScreenLayoutDragComponent;
import org.uberfire.ext.plugin.event.NewPluginRegistered;
import org.uberfire.ext.plugin.event.PluginUnregistered;
import org.uberfire.ext.plugin.model.PluginType;

public class ScreenLayoutDragComponentTest {
    private ScreenLayoutDragComponent screenLayoutDragComponent;
    private ActivityBeansInfo activityBeansInfo;

    @Before
    public void setup() {
        this.screenLayoutDragComponent = (ScreenLayoutDragComponent)Mockito.spy((Object)new ScreenLayoutDragComponent());
        this.activityBeansInfo = (ActivityBeansInfo)Mockito.spy((Object)new ActivityBeansInfo());
        ArrayList<String> availableWorkbenchScreensIds = new ArrayList<String>();
        availableWorkbenchScreensIds.add("screen1");
        availableWorkbenchScreensIds.add("screen2");
        availableWorkbenchScreensIds.add("screen3");
        ((ActivityBeansInfo)Mockito.doReturn(availableWorkbenchScreensIds).when((Object)this.activityBeansInfo)).getAvailableWorkbenchScreensIds();
        ((ScreenLayoutDragComponent)Mockito.doReturn((Object)this.activityBeansInfo).when((Object)this.screenLayoutDragComponent)).getActivityBeansInfo();
        this.screenLayoutDragComponent.setup();
    }

    @Test
    public void newNotScreenPluginRegisteredTest() {
        this.screenLayoutDragComponent.onNewPluginRegistered(new NewPluginRegistered("newPlugin", PluginType.EDITOR));
        Util.assertEquals((Object)3, (Object)this.screenLayoutDragComponent.getAvailableWorkbenchScreensIds().size());
    }

    @Test
    public void existingScreenRegisteredTest() {
        this.screenLayoutDragComponent.onNewPluginRegistered(new NewPluginRegistered("screen1", PluginType.SCREEN));
        Util.assertEquals((Object)3, (Object)this.screenLayoutDragComponent.getAvailableWorkbenchScreensIds().size());
    }

    @Test
    public void newScreenRegisteredTest() {
        this.screenLayoutDragComponent.onNewPluginRegistered(new NewPluginRegistered("newScreen", PluginType.SCREEN));
        Util.assertEquals((Object)4, (Object)this.screenLayoutDragComponent.getAvailableWorkbenchScreensIds().size());
    }

    @Test
    public void notScreenPluginUnregisteredTest() {
        this.screenLayoutDragComponent.onPluginUnregistered(new PluginUnregistered("screen1", PluginType.EDITOR));
        Util.assertEquals((Object)3, (Object)this.screenLayoutDragComponent.getAvailableWorkbenchScreensIds().size());
    }

    @Test
    public void existingScreenUnregisteredTest() {
        this.screenLayoutDragComponent.onPluginUnregistered(new PluginUnregistered("screen1", PluginType.SCREEN));
        Util.assertEquals((Object)2, (Object)this.screenLayoutDragComponent.getAvailableWorkbenchScreensIds().size());
    }

    @Test
    public void unexistingScreenUnregisteredTest() {
        this.screenLayoutDragComponent.onPluginUnregistered(new PluginUnregistered("unexistingPlugin", PluginType.SCREEN));
        Util.assertEquals((Object)3, (Object)this.screenLayoutDragComponent.getAvailableWorkbenchScreensIds().size());
    }
}

