/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.generator;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.QualifierUtil;
import org.jboss.errai.ioc.client.api.EntryPoint;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.exporter.SingletonBeanDef;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.WorkbenchScreenActivity;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.layout.editor.api.LayoutServices;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.client.generator.LayoutGenerator;
import org.uberfire.ext.plugin.client.perspective.editor.generator.PerspectiveEditorActivity;
import org.uberfire.ext.plugin.client.perspective.editor.generator.PerspectiveEditorScreenActivity;
import org.uberfire.ext.plugin.event.PluginDeleted;
import org.uberfire.ext.plugin.model.LayoutEditorModel;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.plugin.service.PluginServices;

@EntryPoint
public class PerspectiveEditorGenerator {
    @Inject
    private SyncBeanManager beanManager;
    @Inject
    private ActivityBeansCache activityBeansCache;
    @Inject
    private LayoutGenerator layoutGenerator;
    @Inject
    private Caller<PluginServices> pluginServices;
    @Inject
    private Caller<LayoutServices> layoutServices;

    @PostConstruct
    public void loadPerspectives() {
        ((PluginServices)this.pluginServices.call((RemoteCallback)new RemoteCallback<Collection<LayoutEditorModel>>(){

            public void callback(Collection<LayoutEditorModel> response) {
                for (LayoutEditorModel layoutEditorModel : response) {
                    PerspectiveEditorGenerator.this.generatePerspective(layoutEditorModel.getLayoutEditorModel());
                }
            }
        })).listLayoutEditor(PluginType.PERSPECTIVE_LAYOUT);
    }

    public void generatePerspective(String layoutEditorModel) {
        ((LayoutServices)this.layoutServices.call((RemoteCallback)new RemoteCallback<LayoutTemplate>(){

            public void callback(LayoutTemplate perspective) {
                if (perspective != null) {
                    PerspectiveEditorGenerator.this.generate(perspective);
                }
            }
        })).convertLayoutFromString(layoutEditorModel);
    }

    public void generate(LayoutTemplate layoutTemplate) {
        if (this.isANewPerspective(layoutTemplate)) {
            PerspectiveEditorScreenActivity screen = this.createNewScreen(layoutTemplate);
            this.createNewPerspective(layoutTemplate, screen);
        } else {
            PerspectiveEditorScreenActivity screen = this.updateScreen(layoutTemplate);
            this.updatePerspective(layoutTemplate, screen);
        }
    }

    private void updatePerspective(LayoutTemplate layoutTemplate, PerspectiveEditorScreenActivity screen) {
        SyncBeanDef activity = this.activityBeansCache.getActivity(layoutTemplate.getName());
        PerspectiveEditorActivity perspectiveEditorActivity = (PerspectiveEditorActivity)activity.getInstance();
        perspectiveEditorActivity.update(layoutTemplate, screen);
    }

    private PerspectiveEditorScreenActivity updateScreen(LayoutTemplate layoutTemplate) {
        SyncBeanDef activity = this.activityBeansCache.getActivity(layoutTemplate.getName() + PerspectiveEditorScreenActivity.screenSufix());
        PerspectiveEditorScreenActivity screenActivity = (PerspectiveEditorScreenActivity)activity.getInstance();
        screenActivity.setLayoutTemplate(layoutTemplate);
        return screenActivity;
    }

    private void createNewPerspective(LayoutTemplate perspective, PerspectiveEditorScreenActivity screen) {
        PerspectiveEditorActivity activity = new PerspectiveEditorActivity(perspective, screen);
        this.beanManager.registerBean((SyncBeanDef)new SingletonBeanDef((Object)activity, PerspectiveActivity.class, new HashSet<Annotation>(Arrays.asList(QualifierUtil.DEFAULT_QUALIFIERS)), perspective.getName(), true, new Class[0]));
        this.activityBeansCache.addNewPerspectiveActivity((SyncBeanDef)this.beanManager.lookupBeans(perspective.getName()).iterator().next());
    }

    private PerspectiveEditorScreenActivity createNewScreen(LayoutTemplate perspective) {
        PerspectiveEditorScreenActivity activity = new PerspectiveEditorScreenActivity(perspective, this.layoutGenerator);
        HashSet<Annotation> qualifiers = new HashSet<Annotation>(Arrays.asList(QualifierUtil.DEFAULT_QUALIFIERS));
        SingletonBeanDef beanDef = new SingletonBeanDef((Object)activity, PerspectiveEditorScreenActivity.class, qualifiers, activity.getIdentifier(), true, new Class[]{WorkbenchScreenActivity.class, Activity.class});
        this.beanManager.registerBean((SyncBeanDef)beanDef);
        this.beanManager.registerBeanTypeAlias((SyncBeanDef)beanDef, Activity.class);
        this.beanManager.registerBeanTypeAlias((SyncBeanDef)beanDef, WorkbenchScreenActivity.class);
        this.activityBeansCache.addNewScreenActivity((SyncBeanDef)this.beanManager.lookupBeans(activity.getIdentifier()).iterator().next());
        return activity;
    }

    private boolean isANewPerspective(LayoutTemplate layoutTemplate) {
        SyncBeanDef activity = this.activityBeansCache.getActivity(layoutTemplate.getName());
        return activity == null;
    }

    private void onPlugInDeleted(@Observes PluginDeleted event) {
        PortablePreconditions.checkNotNull((String)"PluginDeleted event", (Object)event);
        if (PluginType.PERSPECTIVE_LAYOUT.equals((Object)event.getPluginType())) {
            String pluginName = event.getPluginName();
            this.activityBeansCache.removeActivity(pluginName);
        }
    }
}

