/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.editor;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.ext.plugin.client.editor.DynamicMenuEditorPresenter;
import org.uberfire.ext.plugin.client.validation.RuleValidator;
import org.uberfire.ext.plugin.model.DynamicMenuItem;

public class DynamicMenuEditorPresenterTest {
    private DynamicMenuEditorPresenter presenter;
    private DynamicMenuEditorPresenter.View view;
    private DynamicMenuItem existingMenuItem;

    @Before
    public void setup() {
        this.view = (DynamicMenuEditorPresenter.View)Mockito.mock(DynamicMenuEditorPresenter.View.class);
        this.presenter = this.createDynamicMenuEditorPresenter();
        Mockito.when((Object)this.view.emptyActivityID()).thenReturn((Object)"e1");
        Mockito.when((Object)this.view.invalidActivityID()).thenReturn((Object)"e2");
        Mockito.when((Object)this.view.emptyMenuLabel()).thenReturn((Object)"e3");
        Mockito.when((Object)this.view.invalidMenuLabel()).thenReturn((Object)"e4");
        Mockito.when((Object)this.view.duplicatedMenuLabel()).thenReturn((Object)"e5");
        this.existingMenuItem = new DynamicMenuItem("existingActivityId", "existingMenuLabel");
    }

    @Test
    public void validateMenuItemActivityId() {
        RuleValidator activityIdValidator = this.presenter.getMenuItemActivityIdValidator();
        Assert.assertFalse((boolean)activityIdValidator.isValid(null));
        Assert.assertFalse((boolean)activityIdValidator.isValid(""));
        Assert.assertTrue((boolean)activityIdValidator.isValid("existingActivityId"));
        Assert.assertTrue((boolean)activityIdValidator.isValid("newActivityId"));
    }

    @Test
    public void validateNewMenuItemLabel() {
        RuleValidator labelValidator = this.presenter.getMenuItemLabelValidator(new DynamicMenuItem(null, null), null);
        Assert.assertFalse((boolean)labelValidator.isValid(null));
        labelValidator = this.presenter.getMenuItemLabelValidator(new DynamicMenuItem("", ""), null);
        Assert.assertFalse((boolean)labelValidator.isValid(""));
        labelValidator = this.presenter.getMenuItemLabelValidator(new DynamicMenuItem("existingActivityId", "existingMenuLabel"), null);
        Assert.assertFalse((boolean)labelValidator.isValid("existingMenuLabel"));
        labelValidator = this.presenter.getMenuItemLabelValidator(new DynamicMenuItem("newActivityId", "newMenuLabel"), null);
        Assert.assertTrue((boolean)labelValidator.isValid("newMenuLabel"));
    }

    @Test
    public void validateEditedMenuItemLabel() {
        RuleValidator labelValidator = this.presenter.getMenuItemLabelValidator(new DynamicMenuItem("existingActivityId", "existingMenuLabel"), this.existingMenuItem);
        Assert.assertTrue((boolean)labelValidator.isValid("newMenuLabel"));
        Assert.assertTrue((boolean)labelValidator.isValid("existingMenuLabel"));
    }

    private DynamicMenuEditorPresenter createDynamicMenuEditorPresenter() {
        return new DynamicMenuEditorPresenter(this.view){

            public List<DynamicMenuItem> getDynamicMenuItems() {
                ArrayList<DynamicMenuItem> dynamicMenuItems = new ArrayList<DynamicMenuItem>();
                dynamicMenuItems.add(DynamicMenuEditorPresenterTest.this.existingMenuItem);
                return dynamicMenuItems;
            }
        };
    }
}

