/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.widget.media;

import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.ArrayList;
import java.util.Collection;
import org.gwtbootstrap3.client.ui.Row;
import org.gwtbootstrap3.client.ui.html.Text;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.plugin.client.widget.media.MediaLibraryWidget;
import org.uberfire.ext.plugin.event.MediaAdded;
import org.uberfire.ext.plugin.model.Media;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Text.class})
public class MediaLibraryWidgetTest {
    public static final String PLUGIN_NAME = "plugin";
    private MediaLibraryWidget mediaLibraryWidget;
    private Media media;
    private Collection<Media> existentMedia;
    private ParameterizedCommand<Media> onMediaDelete;

    @Before
    public void setup() {
        this.mediaLibraryWidget = new MediaLibraryWidget();
        this.mediaLibraryWidget.library = (Row)Mockito.mock(Row.class);
        this.media = (Media)Mockito.mock(Media.class);
        this.existentMedia = new ArrayList<Media>();
        this.onMediaDelete = (ParameterizedCommand)Mockito.spy((Object)new ParameterizedCommand<Media>(){

            public void execute(Media parameter) {
            }
        });
    }

    @Test
    public void newMediaDeletedOnCloseTest() {
        this.mediaLibraryWidget.setup(PLUGIN_NAME, this.existentMedia, this.onMediaDelete);
        this.mediaLibraryWidget.onNewMedia(new MediaAdded(PLUGIN_NAME, this.media));
        this.mediaLibraryWidget.updateMediaOnClose();
        ((ParameterizedCommand)Mockito.verify(this.onMediaDelete)).execute((Object)this.media);
    }

    @Test
    public void newMediaNotDeletedOnSaveTest() {
        this.mediaLibraryWidget.setup(PLUGIN_NAME, this.existentMedia, this.onMediaDelete);
        this.mediaLibraryWidget.onNewMedia(new MediaAdded(PLUGIN_NAME, this.media));
        this.mediaLibraryWidget.updateMediaOnSave();
        ((ParameterizedCommand)Mockito.verify(this.onMediaDelete, (VerificationMode)Mockito.never())).execute((Object)this.media);
    }

    @Test
    public void existentMediaNotDeletedOnCloseTest() {
        this.existentMedia.add((Media)Mockito.mock(Media.class));
        this.existentMedia.add((Media)Mockito.mock(Media.class));
        this.mediaLibraryWidget.setup(PLUGIN_NAME, this.existentMedia, this.onMediaDelete);
        this.mediaLibraryWidget.onNewMedia(new MediaAdded(PLUGIN_NAME, this.media));
        this.mediaLibraryWidget.updateMediaOnClose();
        ((ParameterizedCommand)Mockito.verify(this.onMediaDelete, (VerificationMode)Mockito.times((int)1))).execute(Mockito.any(Media.class));
        ((ParameterizedCommand)Mockito.verify(this.onMediaDelete)).execute((Object)this.media);
    }

    @Test
    public void existentAndUnexistentMediaNotDeletedOnSaveTest() {
        this.existentMedia.add((Media)Mockito.mock(Media.class));
        this.existentMedia.add((Media)Mockito.mock(Media.class));
        this.mediaLibraryWidget.setup(PLUGIN_NAME, this.existentMedia, this.onMediaDelete);
        this.mediaLibraryWidget.onNewMedia(new MediaAdded(PLUGIN_NAME, this.media));
        this.mediaLibraryWidget.updateMediaOnSave();
        ((ParameterizedCommand)Mockito.verify(this.onMediaDelete, (VerificationMode)Mockito.never())).execute(Mockito.any(Media.class));
    }
}

