/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.layout.editor.popups;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.editor.commons.client.htmleditor.HtmlEditorPresenter;
import org.uberfire.ext.layout.editor.client.api.ModalConfigurationContext;
import org.uberfire.ext.plugin.client.perspective.editor.layout.editor.popups.EditHTMLPresenter;

public class EditHTMLPresenterTest {
    public static final String DEFAULT_CONTENT = "default content";
    public static final String SOME_CONTENT = "some content";
    private ModalConfigurationContext modalConfigurationContext;
    private HtmlEditorPresenter htmlEditor;
    private EditHTMLPresenter.View view;
    private EditHTMLPresenter presenter;

    @Before
    public void setup() {
        this.modalConfigurationContext = (ModalConfigurationContext)Mockito.mock(ModalConfigurationContext.class);
        this.htmlEditor = (HtmlEditorPresenter)Mockito.mock(HtmlEditorPresenter.class);
        this.view = (EditHTMLPresenter.View)Mockito.mock(EditHTMLPresenter.View.class);
        ((EditHTMLPresenter.View)Mockito.doReturn((Object)DEFAULT_CONTENT).when((Object)this.view)).getHtmlEditorPlaceHolder();
        this.presenter = (EditHTMLPresenter)Mockito.spy((Object)new EditHTMLPresenter(this.view, this.htmlEditor));
    }

    @Test
    public void setupEmptyHTMLEditorTest() {
        this.presenter.init(this.modalConfigurationContext);
        ((EditHTMLPresenter)Mockito.verify((Object)this.presenter)).setupHTMLEditor();
        ((ModalConfigurationContext)Mockito.verify((Object)this.modalConfigurationContext)).getComponentProperty("HTML_CODE");
        ((EditHTMLPresenter.View)Mockito.verify((Object)this.view)).getHtmlEditorPlaceHolder();
        ((HtmlEditorPresenter)Mockito.verify((Object)this.htmlEditor)).setContent(DEFAULT_CONTENT);
        ((HtmlEditorPresenter)Mockito.verify((Object)this.htmlEditor)).load();
    }

    @Test
    public void setupNotEmptyHTMLEditorTest() {
        ((ModalConfigurationContext)Mockito.doReturn((Object)SOME_CONTENT).when((Object)this.modalConfigurationContext)).getComponentProperty(Mockito.anyString());
        this.presenter.init(this.modalConfigurationContext);
        ((EditHTMLPresenter)Mockito.verify((Object)this.presenter)).setupHTMLEditor();
        ((ModalConfigurationContext)Mockito.verify((Object)this.modalConfigurationContext)).getComponentProperty("HTML_CODE");
        ((EditHTMLPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).getHtmlEditorPlaceHolder();
        ((HtmlEditorPresenter)Mockito.verify((Object)this.htmlEditor)).setContent(SOME_CONTENT);
        ((HtmlEditorPresenter)Mockito.verify((Object)this.htmlEditor)).load();
    }

    @Test
    public void showTest() {
        this.presenter.init(this.modalConfigurationContext);
        this.presenter.show();
        ((EditHTMLPresenter.View)Mockito.verify((Object)this.view)).show();
    }

    @Test
    public void okClickTest() {
        this.presenter.init(this.modalConfigurationContext);
        this.presenter.okClick();
        ((EditHTMLPresenter.View)Mockito.verify((Object)this.view)).hide();
        ((EditHTMLPresenter)Mockito.verify((Object)this.presenter)).destroyHtmlEditor();
        ((ModalConfigurationContext)Mockito.verify((Object)this.modalConfigurationContext, (VerificationMode)Mockito.never())).configurationCancelled();
        ((ModalConfigurationContext)Mockito.verify((Object)this.modalConfigurationContext)).configurationFinished();
    }

    @Test
    public void cancelButtonClickHandlerTest() {
        this.presenter.init(this.modalConfigurationContext);
        this.presenter.cancelClick();
        ((EditHTMLPresenter.View)Mockito.verify((Object)this.view)).hide();
        ((EditHTMLPresenter)Mockito.verify((Object)this.presenter)).destroyHtmlEditor();
        ((ModalConfigurationContext)Mockito.verify((Object)this.modalConfigurationContext)).configurationCancelled();
        ((ModalConfigurationContext)Mockito.verify((Object)this.modalConfigurationContext, (VerificationMode)Mockito.never())).configurationFinished();
    }

    @Test
    public void closeButtonClickHandlerTest() {
        this.presenter.init(this.modalConfigurationContext);
        this.presenter.closeClick();
        ((ModalConfigurationContext)Mockito.verify((Object)this.presenter.getModalConfigurationContext())).configurationCancelled();
        ((ModalConfigurationContext)Mockito.verify((Object)this.presenter.getModalConfigurationContext(), (VerificationMode)Mockito.never())).configurationFinished();
    }
}

