/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.ext.editor.commons.client.BaseEditor;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.file.DefaultMetadata;
import org.uberfire.ext.editor.commons.service.support.SupportsCopy;
import org.uberfire.ext.editor.commons.service.support.SupportsDelete;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.ext.layout.editor.api.PerspectiveServices;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.client.api.LayoutDragComponentPalette;
import org.uberfire.ext.layout.editor.client.api.LayoutEditor;
import org.uberfire.ext.layout.editor.client.api.LayoutEditorPlugin;
import org.uberfire.ext.layout.editor.client.widgets.LayoutComponentPaletteGroupProvider;
import org.uberfire.ext.plugin.client.perspective.editor.api.PerspectiveEditorComponentGroupProvider;
import org.uberfire.ext.plugin.client.perspective.editor.components.popup.AddTag;
import org.uberfire.ext.plugin.client.perspective.editor.events.PerspectiveEditorFocusEvent;
import org.uberfire.ext.plugin.client.perspective.editor.layout.editor.PerspectiveEditorSettings;
import org.uberfire.ext.plugin.client.perspective.editor.layout.editor.TargetDivList;
import org.uberfire.ext.plugin.client.security.PluginController;
import org.uberfire.ext.plugin.client.type.PerspectiveLayoutPluginResourceType;
import org.uberfire.ext.plugin.client.validation.PluginNameValidator;
import org.uberfire.ext.plugin.model.Activity;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnFocus;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="Perspective Editor", supportedTypes={PerspectiveLayoutPluginResourceType.class}, priority=0x7FFFFFFF)
public class PerspectiveEditorPresenter
extends BaseEditor<LayoutTemplate, DefaultMetadata> {
    public static final String ID = "Perspective Editor";
    @Inject
    private View perspectiveEditorView;
    @Inject
    private LayoutEditorPlugin layoutEditorPlugin;
    @Inject
    private Event<NotificationEvent> ufNotification;
    @Inject
    private PerspectiveLayoutPluginResourceType resourceType;
    @Inject
    private Caller<PerspectiveServices> perspectiveServices;
    @Inject
    private PluginNameValidator pluginNameValidator;
    @Inject
    private PluginController pluginController;
    @Inject
    private PerspectiveEditorSettings perspectiveEditorSettings;
    @Inject
    private SyncBeanManager beanManager;
    @Inject
    private LayoutDragComponentPalette layoutDragComponentPalette;
    @Inject
    Event<PerspectiveEditorFocusEvent> perspectiveEditorFocusEvent;
    private Plugin plugin;

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        this.baseView = this.perspectiveEditorView;
        String name = place.getParameter("name", "");
        this.plugin = new Plugin(name, PluginType.PERSPECTIVE_LAYOUT, (Path)path);
        ArrayList<MenuItems> menuItems = new ArrayList<MenuItems>();
        this.addMenuItem(menuItems, MenuItems.SAVE, this.pluginController.canUpdate((Activity)this.plugin));
        this.addMenuItem(menuItems, MenuItems.COPY, this.pluginController.canCreatePerspectives());
        this.addMenuItem(menuItems, MenuItems.RENAME, this.pluginController.canUpdate((Activity)this.plugin));
        this.addMenuItem(menuItems, MenuItems.DELETE, this.pluginController.canDelete((Activity)this.plugin));
        this.init(path, place, this.resourceType, true, false, menuItems);
        this.initLayoutDragComponentGroups();
        this.layoutEditorPlugin.init(name, org.uberfire.ext.plugin.client.resources.i18n.CommonConstants.INSTANCE.EmptyTitleText(), org.uberfire.ext.plugin.client.resources.i18n.CommonConstants.INSTANCE.EmptySubTitleText(), LayoutTemplate.Style.PAGE);
        this.layoutEditorPlugin.setPreviewEnabled(true);
        this.layoutEditorPlugin.setElementSelectionEnabled(true);
        this.perspectiveEditorView.setupLayoutEditor(this.layoutEditorPlugin.asWidget());
    }

    @OnFocus
    public void onFocus() {
        this.perspectiveEditorFocusEvent.fire((Object)new PerspectiveEditorFocusEvent((LayoutEditor)this.layoutEditorPlugin));
    }

    @OnClose
    public void onClose() {
        this.layoutEditorPlugin.clear();
    }

    protected void addMenuItem(List<MenuItems> menuItems, MenuItems item, boolean add) {
        if (add) {
            menuItems.add(item);
        }
    }

    public void initLayoutDragComponentGroups() {
        this.layoutDragComponentPalette.clear();
        this.layoutDragComponentPalette.addDraggableGroups(this.scanPerspectiveDragGroups());
    }

    private Collection<LayoutComponentPaletteGroupProvider> scanPerspectiveDragGroups() {
        List result = this.beanManager.lookupBeans(PerspectiveEditorComponentGroupProvider.class).stream().map(SyncBeanDef::getInstance).collect(Collectors.toList());
        Collections.sort(result);
        return result.stream().collect(Collectors.toList());
    }

    protected void makeMenuBar() {
        super.makeMenuBar();
        if (this.perspectiveEditorSettings.isTagsEnabled()) {
            this.menuBuilder.addNewTopLevelMenu((MenuItem)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)CommonConstants.INSTANCE.Tags()).respondsWith(() -> {
                AddTag addTag = new AddTag(this);
                addTag.show();
            })).endMenu()).build().getItems().get(0));
        }
    }

    @OnMayClose
    public boolean onMayClose() {
        return super.mayClose(Integer.valueOf(this.getCurrentModelHash()));
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return org.uberfire.ext.plugin.client.resources.i18n.CommonConstants.INSTANCE.PerspectiveEditor() + " [" + this.plugin.getName() + "]";
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }

    @WorkbenchPartView
    public UberView<PerspectiveEditorPresenter> getWidget() {
        return this.perspectiveEditorView;
    }

    protected void loadContent() {
        this.baseView.hideBusyIndicator();
        this.layoutEditorPlugin.load((Path)this.versionRecordManager.getCurrentPath(), this::afterLoad);
    }

    protected Supplier<LayoutTemplate> getContentSupplier() {
        return () -> ((LayoutEditorPlugin)this.layoutEditorPlugin).getLayout();
    }

    protected void afterLoad() {
        this.setOriginalHash(this.getCurrentModelHash());
        this.plugin = new Plugin(this.layoutEditorPlugin.getLayout().getName(), PluginType.PERSPECTIVE_LAYOUT, (Path)this.versionRecordManager.getCurrentPath());
    }

    protected void save() {
        this.layoutEditorPlugin.save((Path)this.versionRecordManager.getCurrentPath(), this.getSaveSuccessCallback(this.getCurrentModelHash()));
        this.concurrentUpdateSessionInfo = null;
    }

    public int getCurrentModelHash() {
        return this.layoutEditorPlugin.getLayout().hashCode();
    }

    protected void onRename() {
        ObservablePath currentPath = this.versionRecordManager.getCurrentPath();
        this.layoutEditorPlugin.load((Path)currentPath, this::afterRename);
    }

    protected void afterRename() {
        this.afterLoad();
        this.changeTitleNotification.fire((Object)new ChangeTitleWidgetEvent(this.place, this.getTitleText(), this.getTitle()));
    }

    public Validator getRenameValidator() {
        return this.pluginNameValidator;
    }

    public Validator getCopyValidator() {
        return this.pluginNameValidator;
    }

    protected Caller<? extends SupportsDelete> getDeleteServiceCaller() {
        return this.perspectiveServices;
    }

    protected Caller<? extends SupportsSaveAndRename<LayoutTemplate, DefaultMetadata>> getSaveAndRenameServiceCaller() {
        return this.perspectiveServices;
    }

    protected Caller<? extends SupportsCopy> getCopyServiceCaller() {
        return this.perspectiveServices;
    }

    public void saveProperty(String key, String value) {
        this.layoutEditorPlugin.addLayoutProperty(key, value);
    }

    public String getLayoutProperty(String key) {
        return this.layoutEditorPlugin.getLayoutProperty(key);
    }

    public List<String> getAllTargetDivs() {
        return TargetDivList.list(this.layoutEditorPlugin.getLayout());
    }

    public static interface View
    extends BaseEditorView,
    UberView<PerspectiveEditorPresenter> {
        public void setupLayoutEditor(Widget var1);
    }
}

