/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilder;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.client.LayoutEditorPresenter;
import org.uberfire.ext.layout.editor.client.api.LayoutDragComponentGroup;
import org.uberfire.ext.layout.editor.client.api.LayoutEditorPlugin;
import org.uberfire.ext.plugin.client.perspective.editor.PerspectiveEditorPresenter;
import org.uberfire.ext.plugin.client.perspective.editor.api.PerspectiveEditorComponentGroupProvider;
import org.uberfire.ext.plugin.client.perspective.editor.layout.editor.PerspectiveEditorSettings;
import org.uberfire.ext.plugin.client.security.PluginController;
import org.uberfire.ext.plugin.model.Activity;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class PerspectiveEditorPresenterTest {
    @Mock
    PerspectiveEditorPresenter.View view;
    @Mock
    PluginController pluginController;
    @Mock
    ObservablePath observablePath;
    @Mock
    PlaceRequest placeRequest;
    @Mock
    VersionRecordManager versionRecordManager;
    @Mock
    BasicFileMenuBuilder menuBuilder;
    @Mock
    LayoutEditorPlugin layoutEditorPlugin;
    @Mock
    SyncBeanManager beanManager;
    @Mock
    PerspectiveEditorSettings settings;
    @Mock
    PerspectiveEditorComponentGroupProvider perspectiveEditorGroupA;
    @Mock
    PerspectiveEditorComponentGroupProvider perspectiveEditorGroupB;
    @Mock
    SyncBeanDef<PerspectiveEditorComponentGroupProvider> perspectiveEditorGroupBeanA;
    @Mock
    SyncBeanDef<PerspectiveEditorComponentGroupProvider> perspectiveEditorGroupBeanB;
    @Mock
    LayoutEditorPresenter layoutEditorPresenter;
    @InjectMocks
    PerspectiveEditorPresenter presenter;
    LayoutDragComponentGroup dragComponentGroupA;
    LayoutDragComponentGroup dragComponentGroupB;
    public static final String COMPONENT_GROUP_A = "A";
    public static final String COMPONENT_GROUP_B = "B";

    @Before
    public void setUp() {
        Mockito.when((Object)this.pluginController.canCreatePerspectives()).thenReturn((Object)true);
        Mockito.when((Object)this.pluginController.canDelete((Activity)Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)this.pluginController.canUpdate((Activity)Mockito.any())).thenReturn((Object)true);
        this.dragComponentGroupA = new LayoutDragComponentGroup(COMPONENT_GROUP_A);
        Mockito.when((Object)this.perspectiveEditorGroupA.getName()).thenReturn((Object)COMPONENT_GROUP_A);
        Mockito.when((Object)this.perspectiveEditorGroupA.getInstance()).thenReturn((Object)this.dragComponentGroupA);
        Mockito.when((Object)this.perspectiveEditorGroupBeanA.getInstance()).thenReturn((Object)this.perspectiveEditorGroupA);
        this.dragComponentGroupB = new LayoutDragComponentGroup(COMPONENT_GROUP_B);
        Mockito.when((Object)this.perspectiveEditorGroupB.getName()).thenReturn((Object)COMPONENT_GROUP_B);
        Mockito.when((Object)this.perspectiveEditorGroupB.getInstance()).thenReturn((Object)this.dragComponentGroupB);
        Mockito.when((Object)this.perspectiveEditorGroupBeanB.getInstance()).thenReturn((Object)this.perspectiveEditorGroupB);
        Mockito.when((Object)this.beanManager.lookupBeans(PerspectiveEditorComponentGroupProvider.class)).thenReturn(Arrays.asList(this.perspectiveEditorGroupBeanB, this.perspectiveEditorGroupBeanA));
    }

    @Test
    public void testInitDragComponentGroups() {
        this.presenter.onStartup(this.observablePath, this.placeRequest);
        ArgumentCaptor groupListArg = ArgumentCaptor.forClass(List.class);
        ((LayoutEditorPlugin)Mockito.verify((Object)this.layoutEditorPlugin)).init(Mockito.anyString(), (List)groupListArg.capture(), Mockito.anyString(), Mockito.anyString(), (LayoutTemplate.Style)Mockito.any());
        List groupList = (List)groupListArg.getValue();
        Assert.assertEquals((long)groupList.size(), (long)2L);
        Assert.assertEquals((Object)((LayoutDragComponentGroup)groupList.get(0)).getName(), (Object)COMPONENT_GROUP_A);
        Assert.assertEquals((Object)((LayoutDragComponentGroup)groupList.get(1)).getName(), (Object)COMPONENT_GROUP_B);
    }

    @Test
    public void testTagsDisabledByDefault() {
        this.presenter.onStartup(this.observablePath, this.placeRequest);
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addSave((Command)Mockito.any(Command.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addCopy((Path)Mockito.any(Path.class), (Validator)Mockito.any(Validator.class), (Caller)Mockito.any(Caller.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addRename((Path)Mockito.any(Path.class), (Validator)Mockito.any(Validator.class), (Caller)Mockito.any(Caller.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addDelete((Path)Mockito.any(Path.class), (Caller)Mockito.any(Caller.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addDelete((Path)Mockito.any(Path.class), (Caller)Mockito.any(Caller.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder, (VerificationMode)Mockito.never())).addNewTopLevelMenu((MenuItem)Mockito.any());
    }

    @Test
    public void testTagsEnabled() {
        Mockito.when((Object)this.settings.isTagsEnabled()).thenReturn((Object)true);
        this.presenter.onStartup(this.observablePath, this.placeRequest);
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addSave((Command)Mockito.any(Command.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addCopy((Path)Mockito.any(Path.class), (Validator)Mockito.any(Validator.class), (Caller)Mockito.any(Caller.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addRename((Path)Mockito.any(Path.class), (Validator)Mockito.any(Validator.class), (Caller)Mockito.any(Caller.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addDelete((Path)Mockito.any(Path.class), (Caller)Mockito.any(Caller.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addDelete((Path)Mockito.any(Path.class), (Caller)Mockito.any(Caller.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addNewTopLevelMenu((MenuItem)Mockito.any());
    }
}

