/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilder;
import org.uberfire.ext.editor.commons.client.menu.common.SaveAndRenameCommandBuilder;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.file.DefaultMetadata;
import org.uberfire.ext.layout.editor.api.PerspectiveServices;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.client.LayoutEditorPresenter;
import org.uberfire.ext.layout.editor.client.api.LayoutDragComponentGroup;
import org.uberfire.ext.layout.editor.client.api.LayoutDragComponentPalette;
import org.uberfire.ext.layout.editor.client.api.LayoutEditorPlugin;
import org.uberfire.ext.layout.editor.client.widgets.LayoutComponentPaletteGroupProvider;
import org.uberfire.ext.plugin.client.perspective.editor.PerspectiveEditorPresenter;
import org.uberfire.ext.plugin.client.perspective.editor.api.PerspectiveEditorComponentGroupProvider;
import org.uberfire.ext.plugin.client.perspective.editor.events.PerspectiveEditorFocusEvent;
import org.uberfire.ext.plugin.client.perspective.editor.layout.editor.PerspectiveEditorSettings;
import org.uberfire.ext.plugin.client.security.PluginController;
import org.uberfire.ext.plugin.model.Activity;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.promise.SyncPromises;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class PerspectiveEditorPresenterTest {
    @Mock
    PerspectiveEditorPresenter.View view;
    @Mock
    PluginController pluginController;
    @Mock
    ObservablePath observablePath;
    @Mock
    PlaceRequest placeRequest;
    @Mock
    VersionRecordManager versionRecordManager;
    @Mock
    BasicFileMenuBuilder menuBuilder;
    @Mock
    LayoutEditorPlugin layoutEditorPlugin;
    @Mock
    SyncBeanManager beanManager;
    @Mock
    PerspectiveEditorSettings settings;
    @Mock
    SyncBeanDef<PerspectiveEditorComponentGroupProvider> perspectiveEditorGroupBeanA;
    @Mock
    SyncBeanDef<PerspectiveEditorComponentGroupProvider> perspectiveEditorGroupBeanB;
    @Mock
    LayoutEditorPresenter layoutEditorPresenter;
    @Mock
    LayoutDragComponentPalette layoutDragComponentPalette;
    @Mock
    EventSourceMock<PerspectiveEditorFocusEvent> perspectiveEditorFocusEvent;
    @Mock
    Caller<PerspectiveServices> perspectiveServices;
    @Mock
    SaveAndRenameCommandBuilder<LayoutTemplate, DefaultMetadata> saveAndRenameCommandBuilder;
    @Spy
    SyncPromises promises;
    @InjectMocks
    PerspectiveEditorPresenter presenter;
    @Captor
    private ArgumentCaptor<Collection<LayoutComponentPaletteGroupProvider>> providersCaptor;
    PerspectiveEditorComponentGroupProvider perspectiveEditorGroupA;
    PerspectiveEditorComponentGroupProvider perspectiveEditorGroupB;
    LayoutDragComponentGroup dragComponentGroupA;
    LayoutDragComponentGroup dragComponentGroupB;
    public static final String COMPONENT_GROUP_A = "A";
    public static final String COMPONENT_GROUP_B = "B";

    @Before
    public void setUp() {
        this.presenter.perspectiveEditorFocusEvent = this.perspectiveEditorFocusEvent;
        Mockito.when((Object)this.pluginController.canCreatePerspectives()).thenReturn((Object)true);
        Mockito.when((Object)this.pluginController.canDelete((Activity)Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)this.pluginController.canUpdate((Activity)Mockito.any())).thenReturn((Object)true);
        this.dragComponentGroupA = new LayoutDragComponentGroup(COMPONENT_GROUP_A);
        this.perspectiveEditorGroupA = new PerspectiveEditorTestGroupProvider(COMPONENT_GROUP_A, this.dragComponentGroupA);
        Mockito.when((Object)this.perspectiveEditorGroupBeanA.getInstance()).thenReturn((Object)this.perspectiveEditorGroupA);
        this.dragComponentGroupB = new LayoutDragComponentGroup(COMPONENT_GROUP_B);
        this.perspectiveEditorGroupB = new PerspectiveEditorTestGroupProvider(COMPONENT_GROUP_B, this.dragComponentGroupB);
        Mockito.when((Object)this.perspectiveEditorGroupBeanB.getInstance()).thenReturn((Object)this.perspectiveEditorGroupB);
        Mockito.when((Object)this.beanManager.lookupBeans(PerspectiveEditorComponentGroupProvider.class)).thenReturn(Arrays.asList(this.perspectiveEditorGroupBeanB, this.perspectiveEditorGroupBeanA));
        this.mockSaveAndRenameCommandBuilder();
    }

    @Test
    public void testInitLayoutEditor() {
        this.presenter.onStartup(this.observablePath, this.placeRequest);
        ((LayoutEditorPlugin)Mockito.verify((Object)this.layoutEditorPlugin)).init(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), (LayoutTemplate.Style)Mockito.eq((Object)LayoutTemplate.Style.PAGE));
        ((LayoutEditorPlugin)Mockito.verify((Object)this.layoutEditorPlugin)).setPreviewEnabled(true);
        ((LayoutEditorPlugin)Mockito.verify((Object)this.layoutEditorPlugin)).setElementSelectionEnabled(true);
    }

    @Test
    public void testInitDragComponentGroups() {
        this.presenter.onStartup(this.observablePath, this.placeRequest);
        ((LayoutDragComponentPalette)Mockito.verify((Object)this.layoutDragComponentPalette)).clear();
        ((LayoutDragComponentPalette)Mockito.verify((Object)this.layoutDragComponentPalette)).addDraggableGroups((Collection)this.providersCaptor.capture());
        Collection providers = (Collection)this.providersCaptor.getValue();
        ((IterableAssert)Assertions.assertThat((Iterable)providers).hasSize(2)).containsExactly((Object[])new LayoutComponentPaletteGroupProvider[]{this.perspectiveEditorGroupA, this.perspectiveEditorGroupB});
    }

    @Test
    public void testTagsDisabledByDefault() {
        this.presenter.onStartup(this.observablePath, this.placeRequest);
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addSave((Command)Mockito.any(Command.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addCopy((Path)Mockito.any(Path.class), (Validator)Mockito.any(Validator.class), (Caller)Mockito.any(Caller.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addRename((Command)Mockito.any(Command.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addDelete((Path)Mockito.any(Path.class), (Caller)Mockito.any(Caller.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addDelete((Path)Mockito.any(Path.class), (Caller)Mockito.any(Caller.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder, (VerificationMode)Mockito.never())).addNewTopLevelMenu((MenuItem)Mockito.any());
    }

    @Test
    public void testTagsEnabled() {
        Mockito.when((Object)this.settings.isTagsEnabled()).thenReturn((Object)true);
        this.presenter.onStartup(this.observablePath, this.placeRequest);
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addSave((Command)Mockito.any(Command.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addCopy((Path)Mockito.any(Path.class), (Validator)Mockito.any(Validator.class), (Caller)Mockito.any(Caller.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addRename((Command)Mockito.any(Command.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addDelete((Path)Mockito.any(Path.class), (Caller)Mockito.any(Caller.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addDelete((Path)Mockito.any(Path.class), (Caller)Mockito.any(Caller.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addNewTopLevelMenu((MenuItem)Mockito.any());
    }

    @Test
    public void testGetContentSupplier() {
        LayoutTemplate layoutTemplate = (LayoutTemplate)Mockito.mock(LayoutTemplate.class);
        ((LayoutEditorPlugin)Mockito.doReturn((Object)layoutTemplate).when((Object)this.layoutEditorPlugin)).getLayout();
        Supplier contentSupplier = this.presenter.getContentSupplier();
        Assert.assertEquals((Object)layoutTemplate, contentSupplier.get());
    }

    @Test
    public void testGetSaveAndRenameServiceCaller() {
        Assert.assertEquals(this.perspectiveServices, (Object)this.presenter.getSaveAndRenameServiceCaller());
    }

    private void mockSaveAndRenameCommandBuilder() {
        Mockito.when((Object)this.saveAndRenameCommandBuilder.addPathSupplier((Supplier)Mockito.any())).thenReturn(this.saveAndRenameCommandBuilder);
        Mockito.when((Object)this.saveAndRenameCommandBuilder.addValidator((Validator)Mockito.any(Validator.class))).thenReturn(this.saveAndRenameCommandBuilder);
        Mockito.when((Object)this.saveAndRenameCommandBuilder.addValidator((Supplier)Mockito.any(Supplier.class))).thenReturn(this.saveAndRenameCommandBuilder);
        Mockito.when((Object)this.saveAndRenameCommandBuilder.addRenameService((Caller)Mockito.any())).thenReturn(this.saveAndRenameCommandBuilder);
        Mockito.when((Object)this.saveAndRenameCommandBuilder.addMetadataSupplier((Supplier)Mockito.any())).thenReturn(this.saveAndRenameCommandBuilder);
        Mockito.when((Object)this.saveAndRenameCommandBuilder.addContentSupplier((Supplier)Mockito.any())).thenReturn(this.saveAndRenameCommandBuilder);
        Mockito.when((Object)this.saveAndRenameCommandBuilder.addIsDirtySupplier((Supplier)Mockito.any())).thenReturn(this.saveAndRenameCommandBuilder);
        Mockito.when((Object)this.saveAndRenameCommandBuilder.addSuccessCallback((ParameterizedCommand)Mockito.any())).thenReturn(this.saveAndRenameCommandBuilder);
        Mockito.when((Object)this.saveAndRenameCommandBuilder.build()).thenReturn(() -> {});
    }

    class PerspectiveEditorTestGroupProvider
    implements PerspectiveEditorComponentGroupProvider {
        private String name;
        private LayoutDragComponentGroup componentGroup;

        public PerspectiveEditorTestGroupProvider(String name, LayoutDragComponentGroup componentGroup) {
            this.name = name;
            this.componentGroup = componentGroup;
        }

        public String getName() {
            return this.name;
        }

        public LayoutDragComponentGroup getComponentGroup() {
            return this.componentGroup;
        }
    }
}

