/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.editor;

import com.google.gwt.core.client.ScriptInjector;
import com.google.gwt.dom.client.StyleInjector;
import java.util.Collection;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.client.BaseEditor;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.ext.editor.commons.client.file.popups.SavePopUpPresenter;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.service.support.SupportsCopy;
import org.uberfire.ext.editor.commons.service.support.SupportsDelete;
import org.uberfire.ext.editor.commons.service.support.SupportsRename;
import org.uberfire.ext.plugin.client.editor.RuntimePluginBaseView;
import org.uberfire.ext.plugin.client.validation.PluginNameValidator;
import org.uberfire.ext.plugin.event.NewPluginRegistered;
import org.uberfire.ext.plugin.event.PluginAdded;
import org.uberfire.ext.plugin.event.PluginDeleted;
import org.uberfire.ext.plugin.event.PluginRenamed;
import org.uberfire.ext.plugin.event.PluginSaved;
import org.uberfire.ext.plugin.event.PluginUnregistered;
import org.uberfire.ext.plugin.model.Media;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginContent;
import org.uberfire.ext.plugin.model.PluginSimpleContent;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.plugin.model.RuntimePlugin;
import org.uberfire.ext.plugin.service.PluginServices;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;

public abstract class RuntimePluginBaseEditor
extends BaseEditor {
    protected Plugin plugin;
    @Inject
    private Caller<PluginServices> pluginServices;
    @Inject
    private PluginNameValidator pluginNameValidator;
    @Inject
    private Event<NewPluginRegistered> newPluginRegisteredEvent;
    @Inject
    private Event<PluginUnregistered> pluginUnregisteredEvent;
    @Inject
    private SavePopUpPresenter savePopUpPresenter;

    protected RuntimePluginBaseEditor(BaseEditorView baseView) {
        super(baseView);
    }

    protected abstract PluginType getPluginType();

    protected abstract ClientResourceType getResourceType();

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        this.init(path, place, this.getResourceType(), true, false, new MenuItems[]{MenuItems.SAVE, MenuItems.COPY, MenuItems.RENAME, MenuItems.DELETE});
        this.plugin = new Plugin(place.getParameter("name", ""), this.getPluginType(), (Path)path);
        this.place = place;
    }

    protected void onPlugInRenamed(@Observes PluginRenamed pluginRenamed) {
        if (pluginRenamed.getOldPluginName().equals(this.plugin.getName()) && pluginRenamed.getPlugin().getType().equals((Object)this.plugin.getType())) {
            this.plugin = new Plugin(pluginRenamed.getPlugin().getName(), this.getPluginType(), pluginRenamed.getPlugin().getPath());
            this.changeTitleNotification.fire((Object)new ChangeTitleWidgetEvent(this.place, this.getTitleText(), this.getTitle()));
        }
    }

    protected Caller<? extends SupportsDelete> getDeleteServiceCaller() {
        return this.pluginServices;
    }

    protected Caller<? extends SupportsRename> getRenameServiceCaller() {
        return this.pluginServices;
    }

    protected Caller<? extends SupportsCopy> getCopyServiceCaller() {
        return this.pluginServices;
    }

    protected void loadContent() {
        ((PluginServices)this.getPluginServices().call((RemoteCallback)new RemoteCallback<PluginContent>(){

            public void callback(PluginContent response) {
                RuntimePluginBaseEditor.this.view().setFramework(response.getFrameworks());
                RuntimePluginBaseEditor.this.view().setupContent(response, new ParameterizedCommand<Media>(){

                    public void execute(Media media) {
                        ((PluginServices)RuntimePluginBaseEditor.this.getPluginServices().call()).deleteMedia(media);
                    }
                });
                RuntimePluginBaseEditor.this.view().hideBusyIndicator();
                RuntimePluginBaseEditor.this.setOriginalHash(RuntimePluginBaseEditor.this.getContent().hashCode());
            }
        })).getPluginContent((Path)this.getCurrentPath());
    }

    ObservablePath getCurrentPath() {
        return this.versionRecordManager.getCurrentPath();
    }

    public PluginSimpleContent getContent() {
        return new PluginSimpleContent(this.view().getContent(), this.view().getTemplate(), this.view().getCss(), this.view().getCodeMap(), this.view().getFrameworks(), this.view().getContent().getLanguage());
    }

    protected void save() {
        this.savePopUpPresenter.show((Path)this.getCurrentPath(), this.getSaveCommand());
        this.concurrentUpdateSessionInfo = null;
    }

    ParameterizedCommand<String> getSaveCommand() {
        return new ParameterizedCommand<String>(){

            public void execute(String commitMessage) {
                ((PluginServices)RuntimePluginBaseEditor.this.getPluginServices().call(RuntimePluginBaseEditor.this.getSaveSuccessCallback(RuntimePluginBaseEditor.this.getContent().hashCode()))).save(RuntimePluginBaseEditor.this.getContent(), commitMessage);
                RuntimePluginBaseEditor.this.view().onSave();
            }
        };
    }

    public boolean mayClose() {
        this.view().onClose();
        return super.mayClose(Integer.valueOf(this.getContent().hashCode()));
    }

    abstract RuntimePluginBaseView view();

    Caller<PluginServices> getPluginServices() {
        return this.pluginServices;
    }

    Integer getOriginalHash() {
        return this.originalHash;
    }

    public Validator getRenameValidator() {
        return this.pluginNameValidator;
    }

    public Validator getCopyValidator() {
        return this.pluginNameValidator;
    }

    public void onPluginSaved(@Observes PluginSaved pluginSaved) {
        this.registerPlugin(pluginSaved.getPlugin());
    }

    public void onPluginAdded(@Observes PluginAdded pluginAdded) {
        this.registerPlugin(pluginAdded.getPlugin());
    }

    public void onPluginDeleted(@Observes PluginDeleted pluginDeleted) {
        this.unregisterPlugin(pluginDeleted.getPluginName(), pluginDeleted.getPluginType());
    }

    public void onPluginRenamed(@Observes PluginRenamed pluginRenamed) {
        this.unregisterPlugin(pluginRenamed.getOldPluginName(), pluginRenamed.getOldPluginType());
        this.registerPlugin(pluginRenamed.getPlugin());
    }

    void unregisterPlugin(String name, PluginType type) {
        this.pluginUnregisteredEvent.fire((Object)new PluginUnregistered(name, type));
    }

    void registerPlugin(final Plugin plugin) {
        ((PluginServices)this.pluginServices.call((RemoteCallback)new RemoteCallback<Collection<RuntimePlugin>>(){

            public void callback(Collection<RuntimePlugin> runtimePlugins) {
                for (RuntimePlugin plugin2 : runtimePlugins) {
                    ScriptInjector.fromString((String)plugin2.getScript()).setWindow(ScriptInjector.TOP_WINDOW).inject();
                    StyleInjector.inject((String)plugin2.getStyle(), (boolean)true);
                }
                RuntimePluginBaseEditor.this.newPluginRegisteredEvent.fire((Object)new NewPluginRegistered(plugin.getName(), plugin.getType()));
            }
        })).listPluginRuntimePlugins(plugin.getPath());
    }
}

