/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.editor;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.ext.plugin.client.editor.DynamicMenuEditorPresenter;
import org.uberfire.ext.plugin.model.DynamicMenuItem;

public class DynamicMenuUpdateIndexTest {
    private DynamicMenuEditorPresenter presenter;
    private DynamicMenuItem firstMenuItem;
    private DynamicMenuItem secondMenuItem;

    @Test
    public void validateItemIndexes() {
        this.presenter = this.createDynamicMenuEditorPresenter((DynamicMenuEditorPresenter.View)Mockito.mock(DynamicMenuEditorPresenter.View.class));
        this.firstMenuItem = new DynamicMenuItem("firstId", "firstLabel");
        this.secondMenuItem = new DynamicMenuItem("secondId", "secondLabel");
        this.presenter.addMenuItem(this.firstMenuItem);
        this.presenter.addMenuItem(this.secondMenuItem);
        this.presenter.updateIndex(this.firstMenuItem, 0, DynamicMenuEditorPresenter.UpdateIndexOperation.UP);
        this.checkMenuItemIndexes(0, 1);
        this.presenter.updateIndex(this.secondMenuItem, 1, DynamicMenuEditorPresenter.UpdateIndexOperation.DOWN);
        this.checkMenuItemIndexes(0, 1);
        this.presenter.updateIndex(this.firstMenuItem, 0, DynamicMenuEditorPresenter.UpdateIndexOperation.DOWN);
        this.checkMenuItemIndexes(1, 0);
        this.presenter.updateIndex(this.firstMenuItem, 1, DynamicMenuEditorPresenter.UpdateIndexOperation.UP);
        this.checkMenuItemIndexes(0, 1);
    }

    private DynamicMenuEditorPresenter createDynamicMenuEditorPresenter(DynamicMenuEditorPresenter.View view) {
        return new DynamicMenuEditorPresenter(view){
            private List<DynamicMenuItem> dynamicMenuItems;
            {
                this.dynamicMenuItems = new ArrayList<DynamicMenuItem>();
            }

            public List<DynamicMenuItem> getDynamicMenuItems() {
                return this.dynamicMenuItems;
            }

            public void addMenuItem(DynamicMenuItem menuItem) {
                this.dynamicMenuItems.add(menuItem);
            }
        };
    }

    private void checkMenuItemIndexes(int firstMenuItemIndex, int secondMenuItemIndex) {
        Assert.assertEquals((long)firstMenuItemIndex, (long)this.presenter.getDynamicMenuItems().indexOf(this.firstMenuItem));
        Assert.assertEquals((long)secondMenuItemIndex, (long)this.presenter.getDynamicMenuItems().indexOf(this.secondMenuItem));
    }
}

