/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.security;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.authz.PerspectiveAction;
import org.uberfire.ext.plugin.model.Activity;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;

@ApplicationScoped
public class PluginController {
    private AuthorizationManager authorizationManager;
    private User user;

    @Inject
    public PluginController(AuthorizationManager authorizationManager, User user) {
        this.authorizationManager = authorizationManager;
        this.user = user;
    }

    public boolean canCreatePerspectives() {
        return this.authorizationManager.authorize((ResourceType)ActivityResourceType.PERSPECTIVE, (ResourceAction)PerspectiveAction.CREATE, this.user);
    }

    public boolean canRead(Activity activity) {
        if (PluginType.PERSPECTIVE.equals((Object)activity.getType()) || PluginType.PERSPECTIVE_LAYOUT.equals((Object)activity.getType())) {
            ResourceRef ref = new ResourceRef(activity.getName(), (ResourceType)ActivityResourceType.PERSPECTIVE);
            return this.authorizationManager.authorize((Resource)ref, PerspectiveAction.READ, this.user);
        }
        return true;
    }

    public boolean canUpdate(Activity activity) {
        if (PluginType.PERSPECTIVE.equals((Object)activity.getType()) || PluginType.PERSPECTIVE_LAYOUT.equals((Object)activity.getType())) {
            ResourceRef ref = new ResourceRef(activity.getName(), (ResourceType)ActivityResourceType.PERSPECTIVE);
            return this.authorizationManager.authorize((Resource)ref, (ResourceAction)PerspectiveAction.UPDATE, this.user);
        }
        return true;
    }

    public boolean canDelete(Activity activity) {
        if (PluginType.PERSPECTIVE.equals((Object)activity.getType()) || PluginType.PERSPECTIVE_LAYOUT.equals((Object)activity.getType())) {
            ResourceRef ref = new ResourceRef(activity.getName(), (ResourceType)ActivityResourceType.PERSPECTIVE);
            return this.authorizationManager.authorize((Resource)ref, (ResourceAction)PerspectiveAction.DELETE, this.user);
        }
        return true;
    }
}

