/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.generator;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.bus.client.util.BusToolsCli;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.QualifierUtil;
import org.jboss.errai.ioc.client.api.EntryPoint;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.WorkbenchScreenActivity;
import org.uberfire.ext.layout.editor.api.PerspectiveServices;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.client.generator.LayoutGenerator;
import org.uberfire.ext.plugin.client.perspective.editor.generator.PerspectiveEditorActivity;
import org.uberfire.ext.plugin.client.perspective.editor.generator.PerspectiveEditorScreenActivity;
import org.uberfire.ext.plugin.event.PluginAdded;
import org.uberfire.ext.plugin.event.PluginDeleted;
import org.uberfire.ext.plugin.event.PluginRenamed;
import org.uberfire.ext.plugin.event.PluginSaved;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.jsbridge.client.cdi.SingletonBeanDefinition;

@EntryPoint
@ApplicationScoped
public class PerspectiveEditorGenerator {
    private SyncBeanManager beanManager;
    private ActivityBeansCache activityBeansCache;
    private LayoutGenerator layoutGenerator;
    private Caller<PerspectiveServices> perspectiveServices;

    @Inject
    public PerspectiveEditorGenerator(SyncBeanManager beanManager, ActivityBeansCache activityBeansCache, LayoutGenerator layoutGenerator, Caller<PerspectiveServices> perspectiveServices) {
        this.beanManager = beanManager;
        this.activityBeansCache = activityBeansCache;
        this.layoutGenerator = layoutGenerator;
        this.perspectiveServices = perspectiveServices;
    }

    @PostConstruct
    public void loadPerspectives() {
        if (!BusToolsCli.isRemoteCommunicationEnabled()) {
            return;
        }
        ((PerspectiveServices)this.perspectiveServices.call(response -> response.forEach(this::generatePerspective))).listLayoutTemplates();
    }

    public void generatePerspective(String layoutEditorModel) {
        ((PerspectiveServices)this.perspectiveServices.call(perspective -> {
            if (perspective != null) {
                this.generatePerspective((LayoutTemplate)perspective);
            }
        })).convertToLayoutTemplate(layoutEditorModel);
    }

    public PerspectiveEditorActivity generatePerspective(LayoutTemplate layoutTemplate) {
        if (this.isANewPerspective(layoutTemplate)) {
            PerspectiveEditorScreenActivity screen = this.createNewScreen(layoutTemplate);
            return this.createNewPerspective(layoutTemplate, screen);
        }
        PerspectiveEditorScreenActivity screen = this.updateScreen(layoutTemplate);
        return this.updatePerspective(layoutTemplate, screen);
    }

    private PerspectiveEditorActivity updatePerspective(LayoutTemplate layoutTemplate, PerspectiveEditorScreenActivity screen) {
        SyncBeanDef activity = this.activityBeansCache.getActivity(layoutTemplate.getName());
        PerspectiveEditorActivity perspectiveEditorActivity = (PerspectiveEditorActivity)activity.getInstance();
        perspectiveEditorActivity.update(layoutTemplate, screen);
        return perspectiveEditorActivity;
    }

    public void removePerspective(String perspectiveName) {
        String perspectiveScreenId = PerspectiveEditorScreenActivity.buildScreenId(perspectiveName);
        this.activityBeansCache.removeActivity(perspectiveName);
        this.activityBeansCache.removeActivity(perspectiveScreenId);
    }

    private PerspectiveEditorScreenActivity updateScreen(LayoutTemplate layoutTemplate) {
        String perspectiveScreenId = PerspectiveEditorScreenActivity.buildScreenId(layoutTemplate.getName());
        SyncBeanDef activity = this.activityBeansCache.getActivity(perspectiveScreenId);
        PerspectiveEditorScreenActivity screenActivity = (PerspectiveEditorScreenActivity)activity.getInstance();
        screenActivity.setLayoutTemplate(layoutTemplate);
        return screenActivity;
    }

    private PerspectiveEditorActivity createNewPerspective(LayoutTemplate perspective, PerspectiveEditorScreenActivity screen) {
        PerspectiveEditorActivity activity = new PerspectiveEditorActivity(perspective, screen);
        this.beanManager.registerBean((SyncBeanDef)new SingletonBeanDefinition((Object)activity, PerspectiveActivity.class, new HashSet<Annotation>(Arrays.asList(QualifierUtil.DEFAULT_QUALIFIERS)), perspective.getName(), true, new Class[0]));
        this.activityBeansCache.addNewPerspectiveActivity((SyncBeanDef)this.beanManager.lookupBeans(perspective.getName()).iterator().next());
        return activity;
    }

    private PerspectiveEditorScreenActivity createNewScreen(LayoutTemplate perspective) {
        PerspectiveEditorScreenActivity activity = new PerspectiveEditorScreenActivity(perspective, this.layoutGenerator);
        HashSet<Annotation> qualifiers = new HashSet<Annotation>(Arrays.asList(QualifierUtil.DEFAULT_QUALIFIERS));
        SingletonBeanDefinition beanDef = new SingletonBeanDefinition((Object)activity, PerspectiveEditorScreenActivity.class, qualifiers, activity.getIdentifier(), true, new Class[]{WorkbenchScreenActivity.class, Activity.class});
        this.beanManager.registerBean((SyncBeanDef)beanDef);
        this.beanManager.registerBeanTypeAlias((SyncBeanDef)beanDef, Activity.class);
        this.beanManager.registerBeanTypeAlias((SyncBeanDef)beanDef, WorkbenchScreenActivity.class);
        this.activityBeansCache.addNewScreenActivity((SyncBeanDef)this.beanManager.lookupBeans(activity.getIdentifier()).iterator().next());
        return activity;
    }

    private boolean isANewPerspective(LayoutTemplate layoutTemplate) {
        SyncBeanDef activity = this.activityBeansCache.getActivity(layoutTemplate.getName());
        return activity == null;
    }

    private void onPlugInAdded(@Observes PluginAdded event) {
        PortablePreconditions.checkNotNull((String)"PluginAdded event", (Object)event);
        Plugin plugin = event.getPlugin();
        ((PerspectiveServices)this.perspectiveServices.call(this::generatePerspective)).getLayoutTemplate(plugin);
    }

    private void onPlugInSaved(@Observes PluginSaved event) {
        PortablePreconditions.checkNotNull((String)"PluginSaved event", (Object)event);
        Plugin plugin = event.getPlugin();
        ((PerspectiveServices)this.perspectiveServices.call(this::generatePerspective)).getLayoutTemplate(plugin);
    }

    private void onPlugInRenamed(@Observes PluginRenamed event) {
        PortablePreconditions.checkNotNull((String)"PluginRenamed event", (Object)event);
        Plugin plugin = event.getPlugin();
        this.removePerspective(event.getOldPluginName());
        ((PerspectiveServices)this.perspectiveServices.call(this::generatePerspective)).getLayoutTemplate(plugin);
    }

    private void onPlugInDeleted(@Observes PluginDeleted event) {
        PortablePreconditions.checkNotNull((String)"PluginDeleted event", (Object)event);
        if (PluginType.PERSPECTIVE_LAYOUT.equals((Object)event.getPluginType())) {
            String pluginName = event.getPluginName();
            this.removePerspective(pluginName);
        }
    }
}

