/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.validation;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.uberfire.ext.plugin.client.validation.RuleValidator;

@RunWith(value=GwtMockitoTestRunner.class)
public class RuleValidatorTest {
    private static final String INVALID_VALUE = "invalid*";
    private static final String VALID_VALUE = "valid";
    private static final String ERROR_MESSAGE = "error";
    private FormGroup field;
    private HelpBlock help;
    private RuleValidator validRuleValidator;
    private RuleValidator invalidRuleValidator;

    @Before
    public void setup() {
        this.field = (FormGroup)Mockito.mock(FormGroup.class);
        this.help = (HelpBlock)Mockito.mock(HelpBlock.class);
        this.validRuleValidator = new RuleValidator(){

            public boolean isValid(String value) {
                return true;
            }

            public String getValidationError() {
                return null;
            }
        };
        this.invalidRuleValidator = new RuleValidator(){

            public boolean isValid(String value) {
                return false;
            }

            public String getValidationError() {
                return RuleValidatorTest.ERROR_MESSAGE;
            }
        };
    }

    @Test
    public void validRuleValidatorTest() {
        this.validRuleValidator.validateFieldInline(VALID_VALUE, this.field, this.help);
        ((FormGroup)Mockito.verify((Object)this.field)).setValidationState(ValidationState.NONE);
        ((HelpBlock)Mockito.verify((Object)this.help)).setText("");
    }

    @Test
    public void invalidRuleValidatorTest() {
        this.invalidRuleValidator.validateFieldInline(INVALID_VALUE, this.field, this.help);
        ((FormGroup)Mockito.verify((Object)this.field)).setValidationState(ValidationState.ERROR);
        ((HelpBlock)Mockito.verify((Object)this.help)).setText(ERROR_MESSAGE);
    }
}

