/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.plugins;

import com.google.gwt.core.client.ScriptInjector;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.bus.client.util.BusToolsCli;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.api.EnabledByProperty;
import org.jboss.errai.ioc.client.api.EntryPoint;
import org.uberfire.backend.plugin.PluginProcessor;
import org.uberfire.backend.plugin.RuntimePlugin;
import org.uberfire.backend.plugin.RuntimePluginService;
import org.uberfire.client.workbench.Workbench;
import org.uberfire.ext.plugin.client.perspective.editor.generator.PerspectiveEditorGenerator;
import org.uberfire.workbench.events.UberfireJSAPIReadyEvent;

@EntryPoint
@EnabledByProperty(value="uberfire.plugin.mode.active", negated=true)
public class RuntimePluginStartup {
    @Inject
    PerspectiveEditorGenerator perspectiveEditorGenerator;
    @Inject
    private Workbench workbench;
    @Inject
    private Caller<RuntimePluginService> runtimePlugins;

    @PostConstruct
    public void init() {
        if (!BusToolsCli.isRemoteCommunicationEnabled()) {
            return;
        }
        this.workbench.addStartupBlocker(RuntimePluginStartup.class);
    }

    void startPlugins(@Observes UberfireJSAPIReadyEvent event) {
        if (!BusToolsCli.isRemoteCommunicationEnabled()) {
            return;
        }
        ((RuntimePluginService)this.runtimePlugins.call((RemoteCallback)new RemoteCallback<List<RuntimePlugin>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void callback(List<RuntimePlugin> plugins) {
                try {
                    for (RuntimePlugin p : plugins) {
                        if (RuntimePluginStartup.this.isJSPlugin(p)) {
                            ScriptInjector.fromString((String)p.getPluginContent()).setWindow(ScriptInjector.TOP_WINDOW).inject();
                            continue;
                        }
                        if (!RuntimePluginStartup.this.isPerspectivePlugin(p)) continue;
                        RuntimePluginStartup.this.perspectiveEditorGenerator.generatePerspective(p.getPluginContent());
                    }
                }
                finally {
                    RuntimePluginStartup.this.workbench.removeStartupBlocker(RuntimePluginStartup.class);
                }
            }
        })).getRuntimePlugins();
    }

    private boolean isPerspectivePlugin(RuntimePlugin p) {
        return p.getType().name() == PluginProcessor.PluginProcessorType.PERSPECTIVE_EDITOR.name();
    }

    private boolean isJSPlugin(RuntimePlugin p) {
        return p.getType().name() == PluginProcessor.PluginProcessorType.JS.name();
    }
}

