/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.layout.editor;

import java.util.ArrayList;
import java.util.HashMap;
import org.jgroups.util.Util;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.client.mvp.ActivityBeansInfo;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.client.api.RenderingContext;
import org.uberfire.ext.plugin.client.perspective.editor.api.PerspectiveEditorCoreComponent;
import org.uberfire.ext.plugin.client.perspective.editor.layout.editor.ScreenLayoutDragComponent;
import org.uberfire.ext.plugin.event.NewPluginRegistered;
import org.uberfire.ext.plugin.event.PluginUnregistered;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@RunWith(value=MockitoJUnitRunner.class)
public class ScreenLayoutDragComponentTest {
    private ScreenLayoutDragComponent screenLayoutDragComponent;
    @Mock
    private ActivityBeansInfo activityBeansInfo;
    @Mock
    private PlaceManager placeManager;

    @Before
    public void setup() {
        this.screenLayoutDragComponent = (ScreenLayoutDragComponent)Mockito.spy((Object)new ScreenLayoutDragComponent(this.placeManager));
        this.activityBeansInfo = (ActivityBeansInfo)Mockito.spy((Object)new ActivityBeansInfo(null, null));
        ArrayList<String> availableWorkbenchScreensIds = new ArrayList<String>();
        availableWorkbenchScreensIds.add("screen1");
        availableWorkbenchScreensIds.add("screen2");
        availableWorkbenchScreensIds.add("screen3");
        ((ActivityBeansInfo)Mockito.doReturn(availableWorkbenchScreensIds).when((Object)this.activityBeansInfo)).getAvailableWorkbenchScreensIds();
        ((ScreenLayoutDragComponent)Mockito.doReturn((Object)this.activityBeansInfo).when((Object)this.screenLayoutDragComponent)).getActivityBeansInfo();
        this.screenLayoutDragComponent.setup();
    }

    @Test
    public void newNotScreenPluginRegisteredTest() {
        this.screenLayoutDragComponent.onNewPluginRegistered(new NewPluginRegistered("newPlugin", PluginType.EDITOR));
        Util.assertEquals((Object)3, (Object)this.screenLayoutDragComponent.getAvailableWorkbenchScreensIds().size());
    }

    @Test
    public void existingScreenRegisteredTest() {
        this.screenLayoutDragComponent.onNewPluginRegistered(new NewPluginRegistered("screen1", PluginType.SCREEN));
        Util.assertEquals((Object)3, (Object)this.screenLayoutDragComponent.getAvailableWorkbenchScreensIds().size());
    }

    @Test
    public void newScreenRegisteredTest() {
        this.screenLayoutDragComponent.onNewPluginRegistered(new NewPluginRegistered("newScreen", PluginType.SCREEN));
        Util.assertEquals((Object)4, (Object)this.screenLayoutDragComponent.getAvailableWorkbenchScreensIds().size());
    }

    @Test
    public void notScreenPluginUnregisteredTest() {
        this.screenLayoutDragComponent.onPluginUnregistered(new PluginUnregistered("screen1", PluginType.EDITOR));
        Util.assertEquals((Object)3, (Object)this.screenLayoutDragComponent.getAvailableWorkbenchScreensIds().size());
    }

    @Test
    public void existingScreenUnregisteredTest() {
        this.screenLayoutDragComponent.onPluginUnregistered(new PluginUnregistered("screen1", PluginType.SCREEN));
        Util.assertEquals((Object)2, (Object)this.screenLayoutDragComponent.getAvailableWorkbenchScreensIds().size());
    }

    @Test
    public void unexistingScreenUnregisteredTest() {
        this.screenLayoutDragComponent.onPluginUnregistered(new PluginUnregistered("unexistingPlugin", PluginType.SCREEN));
        Util.assertEquals((Object)3, (Object)this.screenLayoutDragComponent.getAvailableWorkbenchScreensIds().size());
    }

    @Test
    public void removeCurrentWidgetTest() {
        RenderingContext renderingContext = (RenderingContext)Mockito.mock(RenderingContext.class);
        LayoutComponent t = new LayoutComponent();
        t.addProperty("Place Name", "dora");
        Mockito.when((Object)renderingContext.getComponent()).thenReturn((Object)t);
        this.screenLayoutDragComponent.removeCurrentWidget(renderingContext);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).closePlace((PlaceRequest)Mockito.any(DefaultPlaceRequest.class));
    }

    @Test
    public void buildPlaceRequestTest() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("Place Name", "dora");
        properties.put("dora1", "dora1");
        DefaultPlaceRequest defaultPlaceRequest = this.screenLayoutDragComponent.buildPlaceRequest(properties);
        Util.assertEquals((Object)"dora", (Object)defaultPlaceRequest.getIdentifier());
        Util.assertEquals((Object)2, (Object)defaultPlaceRequest.getParameters().size());
    }

    @Test
    public void createCleanupPlaceRequestTest() {
        DefaultPlaceRequest dora = new DefaultPlaceRequest("dora");
        this.screenLayoutDragComponent.createCleanupPlaceRequest(dora).execute();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).closePlace((PlaceRequest)dora);
    }

    @Test
    public void componentDisabledTest() {
        Util.assertFalse((boolean)(this.screenLayoutDragComponent instanceof PerspectiveEditorCoreComponent));
    }
}

