/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.validation;

import org.uberfire.ext.plugin.client.resources.i18n.CommonConstants;
import org.uberfire.ext.plugin.client.validation.RuleValidator;

public class NameValidator
extends RuleValidator {
    public static final String VALID_DIR_REGEX = "^([^*\"\\/><?\\\\\\!|;:]*)$";
    private String emptyError;
    private String invalidError;
    private String error;

    private NameValidator(String emptyError, String invalidError) {
        this.emptyError = emptyError;
        this.invalidError = invalidError;
    }

    public static NameValidator createNameValidator(String emptyError, String invalidError) {
        return new NameValidator(emptyError, invalidError);
    }

    public static NameValidator tagNameValidator() {
        return new NameValidator(CommonConstants.INSTANCE.EmptyTagName(), CommonConstants.INSTANCE.InvalidTagName());
    }

    public static NameValidator parameterNameValidator() {
        return new NameValidator(CommonConstants.INSTANCE.EmptyParameterName(), CommonConstants.INSTANCE.InvalidParameterName());
    }

    @Override
    public String getValidationError() {
        return this.error;
    }

    @Override
    public boolean isValid(String dirName) {
        if (dirName == null || dirName.trim().isEmpty()) {
            this.error = this.emptyError;
            return Boolean.FALSE;
        }
        if (!dirName.matches(VALID_DIR_REGEX)) {
            this.error = this.invalidError;
            return Boolean.FALSE;
        }
        this.error = null;
        return Boolean.TRUE;
    }
}

