/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.commons.data.Cacheable;
import org.uberfire.security.Identity;
import org.uberfire.security.Resource;
import org.uberfire.security.Role;
import org.uberfire.security.Subject;
import org.uberfire.security.authz.RuntimeResource;
import org.uberfire.security.impl.RoleImpl;
import org.uberfire.security.impl.authz.RuntimeAuthorizationManager;

public class RuntimeAuthorizationManagerTest {
    @Test
    public void testAuthorizeWithCacheRefreshOnRemoveAllRoles() {
        RuntimeAuthorizationManager authorizationManager = new RuntimeAuthorizationManager();
        TestRuntimeResource resource = new TestRuntimeResource("test1234", "author");
        TestIdentity john = new TestIdentity("john", "admin");
        TestIdentity mary = new TestIdentity("mary", "author");
        Assert.assertTrue((boolean)(resource instanceof Cacheable));
        Assert.assertTrue((boolean)((Cacheable)resource).requiresRefresh());
        boolean authorized = authorizationManager.authorize((Resource)resource, (Subject)john);
        Assert.assertFalse((boolean)authorized);
        Assert.assertFalse((boolean)((Cacheable)resource).requiresRefresh());
        authorized = authorizationManager.authorize((Resource)resource, (Subject)mary);
        Assert.assertTrue((boolean)authorized);
        TestRuntimeResource resource2 = new TestRuntimeResource("test1234", null);
        Assert.assertTrue((boolean)((Cacheable)resource2).requiresRefresh());
        authorized = authorizationManager.authorize((Resource)resource2, (Subject)john);
        Assert.assertTrue((boolean)authorized);
        authorized = authorizationManager.authorize((Resource)resource2, (Subject)mary);
        Assert.assertTrue((boolean)authorized);
    }

    @Test
    public void testAuthorizeWithCacheRefreshOnAddedRole() {
        RuntimeAuthorizationManager authorizationManager = new RuntimeAuthorizationManager();
        TestRuntimeResource resource = new TestRuntimeResource("test1234", "author");
        TestIdentity john = new TestIdentity("john", "admin");
        TestIdentity mary = new TestIdentity("mary", "author");
        Assert.assertTrue((boolean)(resource instanceof Cacheable));
        Assert.assertTrue((boolean)((Cacheable)resource).requiresRefresh());
        boolean authorized = authorizationManager.authorize((Resource)resource, (Subject)john);
        Assert.assertFalse((boolean)authorized);
        Assert.assertFalse((boolean)((Cacheable)resource).requiresRefresh());
        authorized = authorizationManager.authorize((Resource)resource, (Subject)mary);
        Assert.assertTrue((boolean)authorized);
        TestRuntimeResource resource2 = new TestRuntimeResource("test1234", "admin", "author");
        Assert.assertTrue((boolean)((Cacheable)resource2).requiresRefresh());
        authorized = authorizationManager.authorize((Resource)resource2, (Subject)john);
        Assert.assertTrue((boolean)authorized);
        Assert.assertFalse((boolean)((Cacheable)resource2).requiresRefresh());
        authorized = authorizationManager.authorize((Resource)resource2, (Subject)mary);
        Assert.assertTrue((boolean)authorized);
    }

    @Test
    public void testAuthorizeWithCacheRefreshOnRemovedRole() {
        RuntimeAuthorizationManager authorizationManager = new RuntimeAuthorizationManager();
        TestRuntimeResource resource = new TestRuntimeResource("test1234", "admin", "author");
        TestIdentity john = new TestIdentity("john", "admin");
        TestIdentity mary = new TestIdentity("mary", "author");
        Assert.assertTrue((boolean)(resource instanceof Cacheable));
        Assert.assertTrue((boolean)((Cacheable)resource).requiresRefresh());
        boolean authorized = authorizationManager.authorize((Resource)resource, (Subject)john);
        Assert.assertTrue((boolean)authorized);
        Assert.assertFalse((boolean)((Cacheable)resource).requiresRefresh());
        authorized = authorizationManager.authorize((Resource)resource, (Subject)mary);
        Assert.assertTrue((boolean)authorized);
        TestRuntimeResource resource2 = new TestRuntimeResource("test1234", "author");
        Assert.assertTrue((boolean)((Cacheable)resource2).requiresRefresh());
        authorized = authorizationManager.authorize((Resource)resource2, (Subject)john);
        Assert.assertFalse((boolean)authorized);
        Assert.assertFalse((boolean)((Cacheable)resource2).requiresRefresh());
        authorized = authorizationManager.authorize((Resource)resource2, (Subject)mary);
        Assert.assertTrue((boolean)authorized);
    }

    private class TestIdentity
    implements Identity {
        private String name;
        private List<Role> roles;

        protected TestIdentity(String name, String ... rolesIn) {
            this.name = name;
            this.roles = new ArrayList<Role>();
            for (String role : rolesIn) {
                this.roles.add((Role)new RoleImpl(role));
            }
        }

        public String getName() {
            return this.name;
        }

        public List<Role> getRoles() {
            return this.roles;
        }

        public boolean hasRole(Role role) {
            return this.roles.contains(role);
        }

        public Map<String, String> getProperties() {
            return Collections.emptyMap();
        }

        public void aggregateProperty(String name, String value) {
        }

        public void removeProperty(String name) {
        }

        public String getProperty(String name, String defaultValue) {
            return null;
        }
    }

    private class TestRuntimeResource
    implements RuntimeResource,
    Cacheable {
        private String signatureId;
        private List<String> roles;
        private boolean requiresRefresh = true;

        protected TestRuntimeResource(String signatureId, String ... roles) {
            this.signatureId = signatureId;
            this.roles = roles != null ? Arrays.asList(roles) : Collections.EMPTY_LIST;
        }

        public String getSignatureId() {
            return this.signatureId;
        }

        public Collection<String> getRoles() {
            return this.roles;
        }

        public Collection<String> getTraits() {
            return Collections.emptySet();
        }

        public void markAsCached() {
            this.requiresRefresh = false;
        }

        public boolean requiresRefresh() {
            return this.requiresRefresh;
        }
    }
}

