/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.commons.data.Cacheable;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.RuntimeResource;
import org.uberfire.security.impl.authz.RuntimeAuthorizationManager;

public class RuntimeAuthorizationManagerTest {
    @Test
    public void testAuthorizeWithCacheRefreshOnRemoveAllRoles() {
        RuntimeAuthorizationManager authorizationManager = new RuntimeAuthorizationManager();
        TestRuntimeResource resource = new TestRuntimeResource("test1234", "author");
        TestIdentity john = new TestIdentity("john", "admin");
        TestIdentity mary = new TestIdentity("mary", "author");
        Assert.assertTrue((boolean)(resource instanceof Cacheable));
        Assert.assertTrue((boolean)((Cacheable)resource).requiresRefresh());
        boolean authorized = authorizationManager.authorize((Resource)resource, (User)john);
        Assert.assertFalse((boolean)authorized);
        Assert.assertFalse((boolean)((Cacheable)resource).requiresRefresh());
        authorized = authorizationManager.authorize((Resource)resource, (User)mary);
        Assert.assertTrue((boolean)authorized);
        TestRuntimeResource resource2 = new TestRuntimeResource("test1234", null);
        Assert.assertTrue((boolean)((Cacheable)resource2).requiresRefresh());
        authorized = authorizationManager.authorize((Resource)resource2, (User)john);
        Assert.assertTrue((boolean)authorized);
        authorized = authorizationManager.authorize((Resource)resource2, (User)mary);
        Assert.assertTrue((boolean)authorized);
    }

    @Test
    public void testAuthorizeWithCacheRefreshOnAddedRole() {
        RuntimeAuthorizationManager authorizationManager = new RuntimeAuthorizationManager();
        TestRuntimeResource resource = new TestRuntimeResource("test1234", "author");
        TestIdentity john = new TestIdentity("john", "admin");
        TestIdentity mary = new TestIdentity("mary", "author");
        Assert.assertTrue((boolean)(resource instanceof Cacheable));
        Assert.assertTrue((boolean)((Cacheable)resource).requiresRefresh());
        boolean authorized = authorizationManager.authorize((Resource)resource, (User)john);
        Assert.assertFalse((boolean)authorized);
        Assert.assertFalse((boolean)((Cacheable)resource).requiresRefresh());
        authorized = authorizationManager.authorize((Resource)resource, (User)mary);
        Assert.assertTrue((boolean)authorized);
        TestRuntimeResource resource2 = new TestRuntimeResource("test1234", "admin", "author");
        Assert.assertTrue((boolean)((Cacheable)resource2).requiresRefresh());
        authorized = authorizationManager.authorize((Resource)resource2, (User)john);
        Assert.assertTrue((boolean)authorized);
        Assert.assertFalse((boolean)((Cacheable)resource2).requiresRefresh());
        authorized = authorizationManager.authorize((Resource)resource2, (User)mary);
        Assert.assertTrue((boolean)authorized);
    }

    @Test
    public void testAuthorizeWithCacheRefreshOnRemovedRole() {
        RuntimeAuthorizationManager authorizationManager = new RuntimeAuthorizationManager();
        TestRuntimeResource resource = new TestRuntimeResource("test1234", "admin", "author");
        TestIdentity john = new TestIdentity("john", "admin");
        TestIdentity mary = new TestIdentity("mary", "author");
        Assert.assertTrue((boolean)(resource instanceof Cacheable));
        Assert.assertTrue((boolean)((Cacheable)resource).requiresRefresh());
        boolean authorized = authorizationManager.authorize((Resource)resource, (User)john);
        Assert.assertTrue((boolean)authorized);
        Assert.assertFalse((boolean)((Cacheable)resource).requiresRefresh());
        authorized = authorizationManager.authorize((Resource)resource, (User)mary);
        Assert.assertTrue((boolean)authorized);
        TestRuntimeResource resource2 = new TestRuntimeResource("test1234", "author");
        Assert.assertTrue((boolean)((Cacheable)resource2).requiresRefresh());
        authorized = authorizationManager.authorize((Resource)resource2, (User)john);
        Assert.assertFalse((boolean)authorized);
        Assert.assertFalse((boolean)((Cacheable)resource2).requiresRefresh());
        authorized = authorizationManager.authorize((Resource)resource2, (User)mary);
        Assert.assertTrue((boolean)authorized);
    }

    private class TestIdentity
    implements User {
        private final String name;
        private final Set<Role> roles;

        protected TestIdentity(String name, String ... rolesIn) {
            this.name = name;
            this.roles = new HashSet<Role>();
            for (String role : rolesIn) {
                this.roles.add((Role)new RoleImpl(role));
            }
        }

        public String getIdentifier() {
            return this.name;
        }

        public Set<Role> getRoles() {
            return this.roles;
        }

        public boolean hasAllRoles(String ... roleNames) {
            for (String roleName : roleNames) {
                boolean foundThisOne = false;
                for (Role role : this.roles) {
                    if (!roleName.equals(role.getName())) continue;
                    foundThisOne = true;
                    break;
                }
                if (foundThisOne) continue;
                return false;
            }
            return true;
        }

        public boolean hasAnyRoles(String ... roleNames) {
            for (Role role : this.roles) {
                for (String roleName : roleNames) {
                    if (!roleName.equals(role.getName())) continue;
                    return true;
                }
            }
            return false;
        }

        public Map<String, String> getProperties() {
            return Collections.emptyMap();
        }

        public void removeProperty(String name) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public void setProperty(String name, String value) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public String getProperty(String name) {
            throw new UnsupportedOperationException("Not implemented.");
        }
    }

    private class TestRuntimeResource
    implements RuntimeResource,
    Cacheable {
        private final String signatureId;
        private List<String> roles;
        private boolean requiresRefresh = true;

        protected TestRuntimeResource(String signatureId, String ... roles) {
            this.signatureId = signatureId;
            this.roles = roles != null ? Arrays.asList(roles) : Collections.emptyList();
        }

        public String getSignatureId() {
            return this.signatureId;
        }

        public Collection<String> getRoles() {
            return this.roles;
        }

        public Collection<String> getTraits() {
            return Collections.emptySet();
        }

        public void markAsCached() {
            this.requiresRefresh = false;
        }

        public boolean requiresRefresh() {
            return this.requiresRefresh;
        }
    }
}

