/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.uberfire.commons.data.Cacheable;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceManager;
import org.uberfire.security.authz.RuntimeContentResource;
import org.uberfire.security.authz.RuntimeFeatureResource;
import org.uberfire.security.authz.RuntimeResource;

public class RuntimeResourceManager
implements ResourceManager {
    final Map<String, RuntimeRestriction> restrictions = new HashMap<String, RuntimeRestriction>();

    private RuntimeRestriction addResource(RuntimeResource resource) {
        RuntimeRestriction runtimeRestriction = null;
        if (resource instanceof RuntimeFeatureResource) {
            runtimeRestriction = new FeatureRestriction(((RuntimeFeatureResource)resource).getRoles(), resource.getTraits());
        } else if (resource instanceof RuntimeContentResource) {
            runtimeRestriction = new ContentRestriction(((RuntimeContentResource)resource).getGroups(), resource.getTraits());
        }
        this.restrictions.put(resource.getSignatureId(), runtimeRestriction);
        return runtimeRestriction;
    }

    public RuntimeRestriction getRestriction(RuntimeResource resource) {
        return this.restrictions.get(resource.getSignatureId());
    }

    @Override
    public boolean supports(Resource resource) {
        return resource instanceof RuntimeResource;
    }

    @Override
    public boolean requiresAuthentication(Resource resource) {
        RuntimeResource runtimeResource;
        RuntimeRestriction restriction;
        if (!(resource instanceof RuntimeResource)) {
            throw new IllegalArgumentException("Parameter named 'resource' is not instance of clazz 'RuntimeResource'!");
        }
        boolean refreshCache = false;
        if (resource instanceof Cacheable) {
            refreshCache = ((Cacheable)resource).requiresRefresh();
        }
        if ((restriction = this.restrictions.get((runtimeResource = (RuntimeResource)resource).getSignatureId())) == null || refreshCache) {
            restriction = this.addResource(runtimeResource);
        }
        return restriction != null && !restriction.isEmpty();
    }

    public static class ContentRestriction
    extends RuntimeRestriction {
        final Collection<Group> groups;

        public ContentRestriction(Collection<String> groups, Collection<String> traits) {
            super(traits);
            if (groups != null) {
                ArrayList<GroupImpl> tempGroups = new ArrayList<GroupImpl>(groups.size());
                for (String tempGroup : groups) {
                    tempGroups.add(new GroupImpl(tempGroup));
                }
                this.groups = Collections.unmodifiableList(tempGroups);
            } else {
                this.groups = Collections.emptyList();
            }
        }

        public Collection<Group> getGroups() {
            return this.groups;
        }

        @Override
        public boolean isEmpty() {
            return this.groups.isEmpty() && super.isEmpty();
        }
    }

    public static class FeatureRestriction
    extends RuntimeRestriction {
        final Collection<Role> roles;

        public FeatureRestriction(Collection<String> roles, Collection<String> traits) {
            super(traits);
            if (roles != null) {
                ArrayList<RoleImpl> tempRoles = new ArrayList<RoleImpl>(roles.size());
                for (String tempRole : roles) {
                    tempRoles.add(new RoleImpl(tempRole));
                }
                this.roles = Collections.unmodifiableList(tempRoles);
            } else {
                this.roles = Collections.emptyList();
            }
        }

        public Collection<Role> getRoles() {
            return this.roles;
        }

        @Override
        public boolean isEmpty() {
            return this.roles.isEmpty() && super.isEmpty();
        }
    }

    public static abstract class RuntimeRestriction {
        final Collection<String> traits;

        public RuntimeRestriction(Collection<String> traits) {
            this.traits = traits != null ? traits : Collections.emptyList();
        }

        public Collection<String> getTraits() {
            return this.traits;
        }

        public boolean isEmpty() {
            return this.traits.isEmpty();
        }
    }
}

