/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import java.util.Collection;
import java.util.HashSet;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.VotingStrategy;
import org.uberfire.security.impl.authz.DefaultAuthorizationEntry;
import org.uberfire.security.impl.authz.DefaultAuthorizationPolicy;
import org.uberfire.security.impl.authz.DefaultPermissionCollection;
import org.uberfire.security.impl.authz.DefaultPermissionManager;
import org.uberfire.security.impl.authz.DotNamedPermission;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultPermissionManagerTest {
    private static final String PERMISSION_NAME = "guideddecisiontable.edit.columns";
    private DefaultAuthorizationPolicy authorizationPolicy;
    private DefaultPermissionManager defaultPermissionManager;

    @Before
    public void setUp() {
        this.defaultPermissionManager = (DefaultPermissionManager)Mockito.spy((Object)new DefaultPermissionManager());
        this.authorizationPolicy = (DefaultAuthorizationPolicy)Mockito.spy((Object)new DefaultAuthorizationPolicy());
        this.defaultPermissionManager.setAuthorizationPolicy((AuthorizationPolicy)this.authorizationPolicy);
    }

    @Test
    public void testResolvePermissionsPriority() {
        VotingStrategy priority = VotingStrategy.PRIORITY;
        UserImpl user = this.makeUser("director", (Role)new RoleImpl("business-user"));
        this.mockAuthorizationPolicy((User)user);
        PermissionCollection resolvedPermission = this.defaultPermissionManager.resolvePermissions((User)user, priority);
        Permission permission = resolvedPermission.get(PERMISSION_NAME);
        Assert.assertEquals((Object)AuthorizationResult.ACCESS_DENIED, (Object)permission.getResult());
    }

    private void mockAuthorizationPolicy(User user) {
        this.mockDefaultPermissions(this.authorizationPolicy);
        this.mockRolePermissions(this.authorizationPolicy, user);
        this.mockGroupPermissions(this.authorizationPolicy, user);
    }

    private void mockGroupPermissions(DefaultAuthorizationPolicy authorizationPolicy, User user) {
        final Group group = (Group)user.getGroups().iterator().next();
        DefaultAuthorizationEntry groupAuthorizationEntry = new DefaultAuthorizationEntry(){
            {
                this.setGroup(group);
            }
        };
        authorizationPolicy.registerAuthzEntry(groupAuthorizationEntry);
        ((DefaultAuthorizationPolicy)Mockito.doReturn((Object)this.makeGrantedPermission()).when((Object)authorizationPolicy)).getPermissions(group);
    }

    private void mockRolePermissions(DefaultAuthorizationPolicy authorizationPolicy, User user) {
        final Role role = (Role)user.getRoles().iterator().next();
        DefaultAuthorizationEntry roleAuthorizationEntry = new DefaultAuthorizationEntry(){
            {
                this.setRole(role);
                this.setPriority(0);
            }
        };
        authorizationPolicy.registerAuthzEntry(roleAuthorizationEntry);
        ((DefaultAuthorizationPolicy)Mockito.doReturn((Object)this.makeDeniedPermissionCollection()).when((Object)authorizationPolicy)).getPermissions(role);
    }

    private void mockDefaultPermissions(DefaultAuthorizationPolicy authorizationPolicy) {
        ((DefaultAuthorizationPolicy)Mockito.doReturn((Object)this.makeGrantedPermission()).when((Object)authorizationPolicy)).getPermissions();
    }

    private UserImpl makeUser(final String name, final Role role) {
        HashSet<Role> roles = new HashSet<Role>(){
            {
                this.add(role);
            }
        };
        HashSet<Group> groups = new HashSet<Group>(){
            {
                this.add(new GroupImpl(name));
            }
        };
        return new UserImpl(name, (Collection)roles, (Collection)groups);
    }

    private DefaultPermissionCollection makeDeniedPermissionCollection() {
        return new DefaultPermissionCollection(){
            {
                this.add(new Permission[]{DefaultPermissionManagerTest.this.makePermissionDenied()});
            }
        };
    }

    private DefaultPermissionCollection makeGrantedPermission() {
        return new DefaultPermissionCollection(){
            {
                this.add(new Permission[]{DefaultPermissionManagerTest.this.makePermissionGranted()});
            }
        };
    }

    private DotNamedPermission makePermissionDenied() {
        return new DotNamedPermission(PERMISSION_NAME, Boolean.valueOf(false));
    }

    private DotNamedPermission makePermissionGranted() {
        return new DotNamedPermission(PERMISSION_NAME, Boolean.valueOf(true));
    }
}

