/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.authz.PermissionTypeRegistry;
import org.uberfire.security.impl.authz.DefaultPermissionManager;
import org.uberfire.security.impl.authz.DefaultPermissionTypeRegistry;

@RunWith(value=MockitoJUnitRunner.class)
public class HomePerspectiveTest {
    PermissionManager permissionManager;
    AuthorizationPolicy authorizationPolicy;

    protected User createUserMock(String ... roles) {
        User user = (User)Mockito.mock(User.class);
        Set roleSet = Stream.of(roles).map(RoleImpl::new).collect(Collectors.toSet());
        Mockito.when((Object)user.getRoles()).thenReturn(roleSet);
        Mockito.when((Object)user.getGroups()).thenReturn(null);
        return user;
    }

    @Before
    public void setUp() {
        this.permissionManager = new DefaultPermissionManager((PermissionTypeRegistry)new DefaultPermissionTypeRegistry());
        this.authorizationPolicy = (AuthorizationPolicy)Mockito.spy((Object)this.permissionManager.newAuthorizationPolicy().bydefault().home("H").role("admin").home("A").priority(10).role("user").home("U").priority(0).role("manager").home("M").priority(5).build());
        this.permissionManager.setAuthorizationPolicy(this.authorizationPolicy);
    }

    @Test
    public void testUserWithoutRoles() {
        User userMock = this.createUserMock(new String[0]);
        String home = this.authorizationPolicy.getHomePerspective(userMock);
        Assert.assertEquals((Object)home, (Object)"H");
    }

    @Test
    public void testSingleRoleHome() {
        User userMock = this.createUserMock("admin");
        String home = this.authorizationPolicy.getHomePerspective(userMock);
        Assert.assertEquals((Object)home, (Object)"A");
        userMock = this.createUserMock("manager");
        home = this.authorizationPolicy.getHomePerspective(userMock);
        Assert.assertEquals((Object)home, (Object)"M");
        userMock = this.createUserMock("user");
        home = this.authorizationPolicy.getHomePerspective(userMock);
        Assert.assertEquals((Object)home, (Object)"U");
    }

    @Test
    public void testHighestPriorityWins() {
        User userMock = this.createUserMock("admin", "user");
        String home = this.authorizationPolicy.getHomePerspective(userMock);
        Assert.assertEquals((Object)home, (Object)"A");
        userMock = this.createUserMock("admin", "user", "manager");
        home = this.authorizationPolicy.getHomePerspective(userMock);
        Assert.assertEquals((Object)home, (Object)"A");
        userMock = this.createUserMock("user", "manager");
        home = this.authorizationPolicy.getHomePerspective(userMock);
        Assert.assertEquals((Object)home, (Object)"M");
    }
}

