/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.authz.PermissionTypeRegistry;
import org.uberfire.security.authz.VotingAlgorithm;
import org.uberfire.security.authz.VotingStrategy;
import org.uberfire.security.impl.authz.DefaultAuthzResultCache;
import org.uberfire.security.impl.authz.DefaultPermissionManager;
import org.uberfire.security.impl.authz.DefaultPermissionTypeRegistry;
import org.uberfire.security.impl.authz.DotNamedPermission;

@RunWith(value=MockitoJUnitRunner.class)
public class PermissionManagerTest {
    PermissionManager permissionManager;
    DefaultAuthzResultCache authzResultCache;
    AuthorizationPolicy authorizationPolicy;
    Permission viewAll = new DotNamedPermission("resource.read", Boolean.valueOf(true));
    Permission denyAll = new DotNamedPermission("resource.read", Boolean.valueOf(false));
    Permission view1 = new DotNamedPermission("resource.read.1", Boolean.valueOf(true));
    Permission noView1 = new DotNamedPermission("resource.read.1", Boolean.valueOf(false));
    Permission view2 = new DotNamedPermission("resource.read.2", Boolean.valueOf(true));
    Permission view12 = new DotNamedPermission("resource.read.1.2", Boolean.valueOf(true));

    protected User createUserMock(String ... roles) {
        User user = (User)Mockito.mock(User.class);
        Set roleSet = Stream.of(roles).map(RoleImpl::new).collect(Collectors.toSet());
        Mockito.when((Object)user.getIdentifier()).thenReturn((Object)Integer.toString(user.hashCode()));
        Mockito.when((Object)user.getRoles()).thenReturn(roleSet);
        Mockito.when((Object)user.getGroups()).thenReturn(null);
        return user;
    }

    @Before
    public void setUp() {
        this.authzResultCache = (DefaultAuthzResultCache)Mockito.spy((Object)new DefaultAuthzResultCache());
        this.permissionManager = (PermissionManager)Mockito.spy((Object)new DefaultPermissionManager((PermissionTypeRegistry)new DefaultPermissionTypeRegistry(), this.authzResultCache));
        this.authorizationPolicy = (AuthorizationPolicy)Mockito.spy((Object)this.permissionManager.newAuthorizationPolicy().role("viewAll").permission("resource.read", Boolean.valueOf(true)).role("noViewAll").permission("resource.read", Boolean.valueOf(false)).role("onlyView1", 5).permission("resource.read", Boolean.valueOf(false)).permission("resource.read.1", Boolean.valueOf(true)).role("noView1").permission("resource.read.1", Boolean.valueOf(false)).role("onlyView12").permission("resource.read.1.2", Boolean.valueOf(true)).build());
        this.permissionManager.setAuthorizationPolicy(this.authorizationPolicy);
    }

    @Test
    public void testSetNullPolicy() {
        this.permissionManager.setAuthorizationPolicy(null);
        AuthorizationPolicy policy = this.permissionManager.getAuthorizationPolicy();
        Assert.assertNotNull((Object)policy);
        Assert.assertTrue((boolean)policy.getRoles().isEmpty());
        Assert.assertTrue((boolean)policy.getGroups().isEmpty());
    }

    @Test
    public void testCreateGlobalPermissions() {
        ResourceType type = () -> "type";
        Permission p = this.permissionManager.createPermission(type, null, true);
        Assert.assertEquals((Object)p.getName(), (Object)"type.read");
        p = this.permissionManager.createPermission(type, () -> "edit", true);
        Assert.assertEquals((Object)p.getName(), (Object)"type.edit");
    }

    @Test
    public void testCreateTypedPermissions() {
        ResourceType type = () -> "type";
        ResourceRef r = new ResourceRef("r1", type, null);
        Permission p = this.permissionManager.createPermission((Resource)r, null, true);
        Assert.assertEquals((Object)p.getName(), (Object)"type.read.r1");
        p = this.permissionManager.createPermission((Resource)r, ResourceAction.READ, true);
        Assert.assertEquals((Object)p.getName(), (Object)"type.read.r1");
    }

    @Test
    public void testUnknownTypePermissions() {
        ResourceRef r = new ResourceRef("r1", ResourceType.UNKNOWN, null);
        Permission p = this.permissionManager.createPermission((Resource)r, null, true);
        Assert.assertEquals((Object)p.getName(), (Object)"r1");
        p = this.permissionManager.createPermission((Resource)r, ResourceAction.READ, true);
        Assert.assertEquals((Object)p.getName(), (Object)"r1");
    }

    @Test
    public void testCreateNonTypedPermissions() {
        ResourceRef r = new ResourceRef("r1", null, null);
        Permission p = this.permissionManager.createPermission((Resource)r, null, true);
        Assert.assertEquals((Object)p.getName(), (Object)"r1");
        p = this.permissionManager.createPermission((Resource)r, ResourceAction.READ, true);
        Assert.assertEquals((Object)p.getName(), (Object)"r1");
    }

    @Test
    public void testResolveResourceId() {
        ResourceType type = () -> "type";
        ResourceRef r = new ResourceRef("r1", type, null);
        Permission p = this.permissionManager.createPermission((Resource)r, null, true);
        Assert.assertEquals((Object)p.getName(), (Object)"type.read.r1");
        String id = this.permissionManager.resolveResourceId(p);
        Assert.assertEquals((Object)id, (Object)"r1");
    }

    @Test
    public void testResolveResourceNull() {
        Permission p = this.permissionManager.createPermission("feature", true);
        Assert.assertEquals((Object)p.getName(), (Object)"feature");
        String id = this.permissionManager.resolveResourceId(p);
        Assert.assertNull((Object)id);
    }

    @Test
    public void testCheckPermission1() {
        User user = this.createUserMock("viewAll");
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.viewAll, user), (Object)AuthorizationResult.ACCESS_GRANTED);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.view1, user), (Object)AuthorizationResult.ACCESS_GRANTED);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.view2, user), (Object)AuthorizationResult.ACCESS_GRANTED);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.noView1, user), (Object)AuthorizationResult.ACCESS_DENIED);
    }

    @Test
    public void testCheckPermission2() {
        User user = this.createUserMock("viewAll", "onlyView1");
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.viewAll, user), (Object)AuthorizationResult.ACCESS_DENIED);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.view1, user), (Object)AuthorizationResult.ACCESS_GRANTED);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.view2, user), (Object)AuthorizationResult.ACCESS_DENIED);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.noView1, user), (Object)AuthorizationResult.ACCESS_DENIED);
    }

    @Test
    public void testCheckPermission3() {
        User user = this.createUserMock("viewAll", "onlyView1", "noView1");
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.viewAll, user), (Object)AuthorizationResult.ACCESS_DENIED);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.view1, user), (Object)AuthorizationResult.ACCESS_GRANTED);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.view2, user), (Object)AuthorizationResult.ACCESS_DENIED);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.noView1, user), (Object)AuthorizationResult.ACCESS_DENIED);
    }

    @Test
    public void testCheckPermission4() {
        User user = this.createUserMock("viewAll", "noView1");
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.viewAll, user), (Object)AuthorizationResult.ACCESS_GRANTED);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.view1, user), (Object)AuthorizationResult.ACCESS_GRANTED);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.view2, user), (Object)AuthorizationResult.ACCESS_GRANTED);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.noView1, user), (Object)AuthorizationResult.ACCESS_DENIED);
    }

    @Test
    public void testCheckPermission5() {
        User user = this.createUserMock("onlyView1");
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.viewAll, user), (Object)AuthorizationResult.ACCESS_DENIED);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.view1, user), (Object)AuthorizationResult.ACCESS_GRANTED);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.view2, user), (Object)AuthorizationResult.ACCESS_DENIED);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.noView1, user), (Object)AuthorizationResult.ACCESS_DENIED);
    }

    @Test
    public void testCheckPermission6() {
        User user = this.createUserMock("noView1");
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.viewAll, user), (Object)AuthorizationResult.ACCESS_ABSTAIN);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.view1, user), (Object)AuthorizationResult.ACCESS_DENIED);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.view2, user), (Object)AuthorizationResult.ACCESS_ABSTAIN);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.noView1, user), (Object)AuthorizationResult.ACCESS_GRANTED);
    }

    @Test
    public void testCheckPermission7() {
        User user = this.createUserMock("onlyView1", "noView1");
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.viewAll, user), (Object)AuthorizationResult.ACCESS_DENIED);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.view1, user), (Object)AuthorizationResult.ACCESS_GRANTED);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.view2, user), (Object)AuthorizationResult.ACCESS_DENIED);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.noView1, user), (Object)AuthorizationResult.ACCESS_DENIED);
    }

    @Test
    public void testCheckPermission8() {
        User user = this.createUserMock("noView1", "onlyView12");
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.viewAll, user), (Object)AuthorizationResult.ACCESS_ABSTAIN);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.view1, user), (Object)AuthorizationResult.ACCESS_DENIED);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.view2, user), (Object)AuthorizationResult.ACCESS_ABSTAIN);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.view12, user), (Object)AuthorizationResult.ACCESS_GRANTED);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.noView1, user), (Object)AuthorizationResult.ACCESS_GRANTED);
    }

    @Test
    public void testCacheHits() {
        User user = this.createUserMock("viewAll");
        this.permissionManager.checkPermission(this.viewAll, user);
        this.permissionManager.checkPermission(this.viewAll, user);
        this.permissionManager.checkPermission(this.viewAll, user);
        this.permissionManager.checkPermission(this.viewAll, user);
        ((PermissionManager)Mockito.verify((Object)this.permissionManager, (VerificationMode)Mockito.times((int)1))).resolvePermissions(user, VotingStrategy.PRIORITY);
        ((DefaultAuthzResultCache)Mockito.verify((Object)this.authzResultCache, (VerificationMode)Mockito.times((int)1))).put(user, this.viewAll, AuthorizationResult.ACCESS_GRANTED);
        ((DefaultAuthzResultCache)Mockito.verify((Object)this.authzResultCache, (VerificationMode)Mockito.times((int)4))).get(user, this.viewAll);
        Assert.assertEquals((long)this.authzResultCache.size(user), (long)1L);
        Assert.assertEquals((long)this.authzResultCache.size(this.createUserMock(new String[0])), (long)0L);
        this.permissionManager.invalidate(user);
        Assert.assertEquals((long)this.authzResultCache.size(user), (long)0L);
        this.permissionManager.checkPermission(this.viewAll, user);
        ((PermissionManager)Mockito.verify((Object)this.permissionManager, (VerificationMode)Mockito.times((int)2))).resolvePermissions(user, VotingStrategy.PRIORITY);
        ((DefaultAuthzResultCache)Mockito.verify((Object)this.authzResultCache, (VerificationMode)Mockito.times((int)2))).put(user, this.viewAll, AuthorizationResult.ACCESS_GRANTED);
        ((DefaultAuthzResultCache)Mockito.verify((Object)this.authzResultCache, (VerificationMode)Mockito.times((int)5))).get(user, this.viewAll);
        Assert.assertEquals((long)this.authzResultCache.size(user), (long)1L);
        Assert.assertEquals((long)this.authzResultCache.size(this.createUserMock(new String[0])), (long)0L);
    }

    @Test
    public void testDefaultVotingStrategy() {
        User user = this.createUserMock("role1");
        Assert.assertEquals((Object)this.permissionManager.getDefaultVotingStrategy(), (Object)VotingStrategy.PRIORITY);
        VotingAlgorithm unanimousVoter = (VotingAlgorithm)Mockito.mock(VotingAlgorithm.class);
        Mockito.when((Object)unanimousVoter.vote((Iterable)Mockito.any())).thenReturn((Object)AuthorizationResult.ACCESS_GRANTED);
        this.permissionManager.setDefaultVotingStrategy(VotingStrategy.UNANIMOUS);
        this.permissionManager.setVotingAlgorithm(VotingStrategy.UNANIMOUS, unanimousVoter);
        this.permissionManager.checkPermission(this.viewAll, user);
        ((VotingAlgorithm)Mockito.verify((Object)unanimousVoter)).vote((Iterable)Mockito.any());
        this.permissionManager.checkPermission(this.viewAll, user, null);
        ((VotingAlgorithm)Mockito.verify((Object)unanimousVoter)).vote((Iterable)Mockito.any());
        VotingAlgorithm affirmativeVoter = (VotingAlgorithm)Mockito.mock(VotingAlgorithm.class);
        Mockito.when((Object)affirmativeVoter.vote((Iterable)Mockito.any())).thenReturn((Object)AuthorizationResult.ACCESS_GRANTED);
        this.authzResultCache.clear();
        this.permissionManager.setDefaultVotingStrategy(VotingStrategy.AFFIRMATIVE);
        this.permissionManager.setVotingAlgorithm(VotingStrategy.AFFIRMATIVE, affirmativeVoter);
        this.permissionManager.checkPermission(this.viewAll, user);
        ((VotingAlgorithm)Mockito.verify((Object)affirmativeVoter)).vote((Iterable)Mockito.any());
        VotingAlgorithm consensusVoter = (VotingAlgorithm)Mockito.mock(VotingAlgorithm.class);
        Mockito.when((Object)consensusVoter.vote((Iterable)Mockito.any())).thenReturn((Object)AuthorizationResult.ACCESS_GRANTED);
        this.authzResultCache.clear();
        this.permissionManager.setDefaultVotingStrategy(VotingStrategy.CONSENSUS);
        this.permissionManager.setVotingAlgorithm(VotingStrategy.CONSENSUS, consensusVoter);
        this.permissionManager.checkPermission(this.viewAll, user);
        ((VotingAlgorithm)Mockito.verify((Object)consensusVoter)).vote((Iterable)Mockito.any());
    }

    @Test
    public void testPriorityVoting1() {
        User user = this.createUserMock("role1", "role2", "role3");
        AuthorizationPolicy policy = this.permissionManager.newAuthorizationPolicy().role("role1", 1).permission("resource.read", Boolean.valueOf(true)).role("role2", 2).permission("resource.read", Boolean.valueOf(false)).role("role3", 3).permission("resource.read.1", Boolean.valueOf(true)).build();
        this.permissionManager.setAuthorizationPolicy(policy);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.view1, user), (Object)AuthorizationResult.ACCESS_GRANTED);
        PermissionCollection pc = this.permissionManager.resolvePermissions(user, VotingStrategy.PRIORITY);
        Collection permissions = pc.collection();
        Assert.assertEquals((long)permissions.size(), (long)2L);
        Assert.assertTrue((boolean)permissions.contains(this.denyAll));
        Assert.assertTrue((boolean)permissions.contains(this.view1));
    }

    @Test
    public void testPriorityVoting2() {
        User user = this.createUserMock("role1", "role2", "role3");
        AuthorizationPolicy policy = this.permissionManager.newAuthorizationPolicy().role("role1", 3).permission("resource.read", Boolean.valueOf(true)).role("role2", 2).permission("resource.read", Boolean.valueOf(false)).role("role3", 1).permission("resource.read.1", Boolean.valueOf(true)).build();
        this.permissionManager.setAuthorizationPolicy(policy);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.view1, user), (Object)AuthorizationResult.ACCESS_GRANTED);
        PermissionCollection pc = this.permissionManager.resolvePermissions(user, VotingStrategy.PRIORITY);
        Collection permissions = pc.collection();
        Assert.assertEquals((long)permissions.size(), (long)1L);
        Assert.assertTrue((boolean)permissions.contains(this.viewAll));
    }

    @Test
    public void testPriorityVoting3() {
        User user = this.createUserMock("role1", "role2", "role3");
        AuthorizationPolicy policy = this.permissionManager.newAuthorizationPolicy().role("role1", 1).permission("resource.read", Boolean.valueOf(true)).role("role2", 2).permission("resource.read", Boolean.valueOf(false)).role("role3", 1).permission("resource.read.1", Boolean.valueOf(true)).build();
        this.permissionManager.setAuthorizationPolicy(policy);
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.view1, user), (Object)AuthorizationResult.ACCESS_DENIED);
        PermissionCollection pc = this.permissionManager.resolvePermissions(user, VotingStrategy.PRIORITY);
        Collection permissions = pc.collection();
        Assert.assertEquals((long)permissions.size(), (long)1L);
        Assert.assertTrue((boolean)permissions.contains(this.denyAll));
    }

    @Test
    public void testUnanimousVoting() {
        this.permissionManager.setAuthorizationPolicy(this.permissionManager.newAuthorizationPolicy().role("role1").permission("resource.read", Boolean.valueOf(true)).role("role2").permission("resource.read", Boolean.valueOf(false)).role("role3").permission("resource.read", Boolean.valueOf(true)).build());
        User user = this.createUserMock("role1", "role2", "role3");
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.viewAll, user, VotingStrategy.UNANIMOUS), (Object)AuthorizationResult.ACCESS_DENIED);
        user = this.createUserMock("role1", "role3");
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.viewAll, user, VotingStrategy.UNANIMOUS), (Object)AuthorizationResult.ACCESS_GRANTED);
    }

    @Test
    public void testConsensusVoting() {
        this.permissionManager.setAuthorizationPolicy(this.permissionManager.newAuthorizationPolicy().role("role1").permission("resource.read", Boolean.valueOf(true)).role("role2").permission("resource.read", Boolean.valueOf(false)).role("role3").permission("resource.read", Boolean.valueOf(true)).build());
        User user = this.createUserMock("role1", "role2", "role3");
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.viewAll, user, VotingStrategy.CONSENSUS), (Object)AuthorizationResult.ACCESS_DENIED);
        user = this.createUserMock("role1", "role3");
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.viewAll, user, VotingStrategy.CONSENSUS), (Object)AuthorizationResult.ACCESS_GRANTED);
    }

    @Test
    public void testAffirmativeVoting() {
        this.permissionManager.setAuthorizationPolicy(this.permissionManager.newAuthorizationPolicy().role("role1").permission("resource.read", Boolean.valueOf(true)).role("role2").permission("resource.read", Boolean.valueOf(false)).role("role3").permission("resource.read", Boolean.valueOf(true)).build());
        User user = this.createUserMock("role1", "role2", "role3");
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.viewAll, user, VotingStrategy.AFFIRMATIVE), (Object)AuthorizationResult.ACCESS_GRANTED);
        user = this.createUserMock("role1", "role3");
        Assert.assertEquals((Object)this.permissionManager.checkPermission(this.viewAll, user, VotingStrategy.AFFIRMATIVE), (Object)AuthorizationResult.ACCESS_GRANTED);
    }
}

