/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.authz.PermissionType;
import org.uberfire.security.authz.PermissionTypeRegistry;
import org.uberfire.security.authz.RuntimeResource;
import org.uberfire.security.authz.VotingStrategy;
import org.uberfire.security.impl.authz.DefaultAuthorizationManager;
import org.uberfire.security.impl.authz.DefaultPermissionManager;
import org.uberfire.security.impl.authz.DefaultPermissionTypeRegistry;

@RunWith(value=MockitoJUnitRunner.class)
public class AuthorizationManagerTest {
    @Mock
    Resource perspective1;
    @Mock
    Resource perspective2;
    @Mock
    Resource perspective3;
    @Mock
    ResourceType perspectiveType;
    @Mock
    Resource resource1;
    @Mock
    RuntimeResource resource2;
    @Mock
    Resource menuPerspective1;
    @Mock
    Command onGranted;
    @Mock
    Command onDenied;
    @Mock
    Resource menuPerspective2;
    User user;
    DefaultAuthorizationManager authorizationManager;
    PermissionManager permissionManager;
    PermissionTypeRegistry permissionTypeRegistry;

    protected User createUserMock(String ... roles) {
        User user = (User)Mockito.mock(User.class);
        Set roleSet = Stream.of(roles).map(RoleImpl::new).collect(Collectors.toSet());
        Mockito.when((Object)user.getRoles()).thenReturn(roleSet);
        Mockito.when((Object)user.getGroups()).thenReturn(null);
        return user;
    }

    @Before
    public void setUp() {
        this.user = this.createUserMock("admin");
        Mockito.when((Object)this.perspectiveType.getName()).thenReturn((Object)"perspective");
        Mockito.when((Object)this.resource1.getDependencies()).thenReturn(null);
        Mockito.when((Object)this.resource2.getDependencies()).thenReturn(null);
        Mockito.when((Object)this.perspective1.getIdentifier()).thenReturn((Object)"p1");
        Mockito.when((Object)this.perspective2.getIdentifier()).thenReturn((Object)"p2");
        Mockito.when((Object)this.perspective1.getDependencies()).thenReturn(null);
        Mockito.when((Object)this.perspective2.getDependencies()).thenReturn(null);
        Mockito.when((Object)this.perspective3.getDependencies()).thenReturn(null);
        Mockito.when((Object)this.perspective1.getResourceType()).thenReturn((Object)this.perspectiveType);
        Mockito.when((Object)this.perspective2.getResourceType()).thenReturn((Object)this.perspectiveType);
        Mockito.when((Object)this.perspective3.getResourceType()).thenReturn((Object)this.perspectiveType);
        Mockito.when((Object)this.menuPerspective1.getDependencies()).thenReturn(Arrays.asList(this.perspective1));
        Mockito.when((Object)this.menuPerspective2.getDependencies()).thenReturn(Arrays.asList(this.perspective2));
        this.permissionTypeRegistry = new DefaultPermissionTypeRegistry();
        this.permissionManager = (PermissionManager)Mockito.spy((Object)new DefaultPermissionManager(this.permissionTypeRegistry));
        this.authorizationManager = new DefaultAuthorizationManager(this.permissionManager);
        this.permissionManager.setAuthorizationPolicy(this.permissionManager.newAuthorizationPolicy().role("admin").priority(0).permission("perspective.read", Boolean.valueOf(true)).permission("perspective.read.p2", Boolean.valueOf(false)).permission("custom.resource2", Boolean.valueOf(true)).role("manager").priority(0).permission("perspective.read", Boolean.valueOf(false)).role("developer").priority(10).permission("perspective.read", Boolean.valueOf(true)).build());
    }

    @Test
    public void avoidPermissionTypesCollision() {
        PermissionType permissionType = (PermissionType)Mockito.mock(PermissionType.class);
        Mockito.when((Object)permissionType.getType()).thenReturn((Object)"type");
        this.permissionTypeRegistry.register(permissionType);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.permissionTypeRegistry.register(permissionType)).isInstanceOf(IllegalStateException.class)).hasMessage("PermissionType already exists: type");
    }

    @Test
    public void testUnknownResource() {
        boolean result = this.authorizationManager.authorize(this.resource1, this.user);
        Assert.assertEquals((Object)result, (Object)true);
    }

    @Test
    public void testAuthorizationPolicyUndefined() {
        User user = this.createUserMock("role1");
        this.permissionManager.setAuthorizationPolicy(null);
        PermissionCollection pc = this.permissionManager.resolvePermissions(user, VotingStrategy.PRIORITY);
        boolean result = this.authorizationManager.authorize(this.resource1, user);
        Assert.assertNotNull((Object)pc);
        Assert.assertEquals((long)pc.collection().size(), (long)0L);
        Assert.assertEquals((Object)result, (Object)true);
    }

    @Test
    public void testNonManagedResource() {
        boolean result = this.authorizationManager.authorize((Resource)this.resource2, this.user);
        Assert.assertEquals((Object)result, (Object)true);
        ((PermissionManager)Mockito.verify((Object)this.permissionManager, (VerificationMode)Mockito.never())).checkPermission((Permission)Mockito.any(Permission.class), (User)Mockito.any(User.class));
    }

    @Test
    public void testCustomResourceAccess() {
        Mockito.when((Object)this.resource2.getIdentifier()).thenReturn((Object)"custom.resource2");
        boolean result = this.authorizationManager.authorize((Resource)this.resource2, this.user);
        Assert.assertEquals((Object)result, (Object)true);
        ((PermissionManager)Mockito.verify((Object)this.permissionManager)).checkPermission((Permission)Mockito.any(Permission.class), (User)Mockito.any(User.class), (VotingStrategy)Mockito.eq(null));
    }

    @Test
    public void testResourceTypeAccess() {
        User user1 = this.createUserMock("manager");
        boolean result = this.authorizationManager.authorize(this.perspective3, user1);
        Assert.assertEquals((Object)result, (Object)false);
    }

    @Test
    public void testPerspectiveAccessGranted() {
        boolean result = this.authorizationManager.authorize(this.perspective1, this.user);
        Assert.assertEquals((Object)result, (Object)true);
        ((PermissionManager)Mockito.verify((Object)this.permissionManager)).checkPermission((Permission)Mockito.any(Permission.class), (User)Mockito.any(User.class), (VotingStrategy)Mockito.eq(null));
    }

    @Test
    public void testPerspectiveAccessDenied() {
        boolean result = this.authorizationManager.authorize(this.perspective2, this.user);
        Assert.assertEquals((Object)result, (Object)false);
        ((PermissionManager)Mockito.verify((Object)this.permissionManager)).checkPermission((Permission)Mockito.any(Permission.class), (User)Mockito.any(User.class), (VotingStrategy)Mockito.eq(null));
    }

    @Test
    public void testMenuItemGranted() {
        boolean result = this.authorizationManager.authorize(this.menuPerspective1, this.user);
        Assert.assertEquals((Object)result, (Object)true);
        ((PermissionManager)Mockito.verify((Object)this.permissionManager)).checkPermission((Permission)Mockito.any(Permission.class), (User)Mockito.any(User.class), (VotingStrategy)Mockito.eq(null));
    }

    @Test
    public void testMenuItemDenied() {
        boolean result = this.authorizationManager.authorize(this.menuPerspective2, this.user);
        Assert.assertEquals((Object)result, (Object)false);
    }

    @Test
    public void testMenuItemAbstain() {
        this.permissionManager.setAuthorizationPolicy(null);
        boolean result = this.authorizationManager.authorize(this.menuPerspective1, this.user);
        Assert.assertEquals((Object)result, (Object)true);
    }

    @Test
    public void testMenuGroupGranted() {
        ResourceRef resource = new ResourceRef(null, null, Arrays.asList(this.menuPerspective1, this.menuPerspective2));
        boolean result = this.authorizationManager.authorize((Resource)resource, this.user);
        Assert.assertEquals((Object)result, (Object)true);
        resource = new ResourceRef(null, null, Arrays.asList(this.menuPerspective1));
        result = this.authorizationManager.authorize((Resource)resource, this.user);
        Assert.assertEquals((Object)result, (Object)true);
    }

    @Test
    public void testMenuGroupDenied() {
        ResourceRef resource = new ResourceRef(null, null, Arrays.asList(this.menuPerspective2));
        boolean result = this.authorizationManager.authorize((Resource)resource, this.user);
        Assert.assertEquals((Object)result, (Object)false);
    }

    @Test
    public void testEmptyMenuGranted() {
        ResourceRef resource = new ResourceRef(null, null, Arrays.asList(new Resource[0]));
        boolean result = this.authorizationManager.authorize((Resource)resource, this.user);
        Assert.assertEquals((Object)result, (Object)true);
    }

    @Test
    public void testPermissionGranted() {
        boolean result = this.authorizationManager.authorize("perspective.read.p1", this.user);
        Assert.assertEquals((Object)result, (Object)true);
    }

    @Test
    public void testPermissionDenied() {
        boolean result = this.authorizationManager.authorize("perspective.read.p2", this.user);
        Assert.assertEquals((Object)result, (Object)false);
    }

    @Test
    public void testGrantCommandInvoked() throws Exception {
        this.authorizationManager.check(this.perspective1, this.user).granted(this.onGranted);
        ((Command)Mockito.verify((Object)this.onGranted)).execute();
        Mockito.reset((Object[])new Command[]{this.onGranted});
        this.authorizationManager.check(this.perspective1, this.user).granted(this.onGranted).denied(this.onDenied);
        ((Command)Mockito.verify((Object)this.onGranted)).execute();
        ((Command)Mockito.verify((Object)this.onDenied, (VerificationMode)Mockito.never())).execute();
    }

    @Test
    public void testGrantCommandNotInvoked() throws Exception {
        this.authorizationManager.check(this.perspective2, this.user).granted(this.onGranted);
        ((Command)Mockito.verify((Object)this.onGranted, (VerificationMode)Mockito.never())).execute();
    }

    @Test
    public void testDenyCommandInvoked() throws Exception {
        this.authorizationManager.check(this.perspective2, this.user).denied(this.onDenied);
        ((Command)Mockito.verify((Object)this.onDenied)).execute();
        Mockito.reset((Object[])new Command[]{this.onDenied});
        this.authorizationManager.check(this.perspective2, this.user).granted(this.onGranted).denied(this.onDenied);
        ((Command)Mockito.verify((Object)this.onGranted, (VerificationMode)Mockito.never())).execute();
        ((Command)Mockito.verify((Object)this.onDenied)).execute();
    }

    @Test
    public void testDenyCommandNotInvoked() throws Exception {
        this.authorizationManager.check(this.perspective1, this.user).denied(this.onDenied);
        ((Command)Mockito.verify((Object)this.onDenied, (VerificationMode)Mockito.never())).execute();
    }

    @Test
    public void testPermissionCheck() throws Exception {
        this.authorizationManager.check("perspective.read.p1", this.user).granted(this.onGranted).denied(this.onDenied);
        ((Command)Mockito.verify((Object)this.onGranted)).execute();
        ((Command)Mockito.verify((Object)this.onDenied, (VerificationMode)Mockito.never())).execute();
    }

    @Test
    public void testVotingPriority() throws Exception {
        User user1 = this.createUserMock("admin", "developer");
        this.permissionManager.setDefaultVotingStrategy(VotingStrategy.PRIORITY);
        Assert.assertTrue((boolean)this.authorizationManager.authorize(this.perspective2, user1));
    }

    @Test
    public void testSamePriorityVoting() {
        User user = this.createUserMock("role1", "role2");
        this.permissionManager.setAuthorizationPolicy(this.permissionManager.newAuthorizationPolicy().role("role1").permission("perspective.read", Boolean.valueOf(false)).permission("perspective.read.p1", Boolean.valueOf(true)).permission("screen.read.s1", Boolean.valueOf(true)).role("role2").permission("perspective.read", Boolean.valueOf(true)).permission("perspective.read.p1", Boolean.valueOf(false)).permission("screen.read", Boolean.valueOf(false)).build());
        this.permissionManager.setDefaultVotingStrategy(VotingStrategy.PRIORITY);
        Assert.assertTrue((boolean)this.authorizationManager.authorize("perspective.read", user));
        Assert.assertTrue((boolean)this.authorizationManager.authorize("perspective.read.p1", user));
        Assert.assertTrue((boolean)this.authorizationManager.authorize("perspective.read.p2", user));
        Assert.assertFalse((boolean)this.authorizationManager.authorize("screen.read", user));
        Assert.assertTrue((boolean)this.authorizationManager.authorize("screen.read.s1", user));
    }

    @Test
    public void testHighPriorityVoting() {
        User user = this.createUserMock("role1", "role2", "role3");
        this.permissionManager.setAuthorizationPolicy(this.permissionManager.newAuthorizationPolicy().role("role1").priority(10).permission("perspective.read", Boolean.valueOf(false)).permission("perspective.read.p1", Boolean.valueOf(true)).permission("screen.read.s1", Boolean.valueOf(true)).role("role2").permission("perspective.read", Boolean.valueOf(true)).permission("perspective.read.p1", Boolean.valueOf(false)).permission("screen.read", Boolean.valueOf(false)).role("role3").priority(5).permission("perspective.read", Boolean.valueOf(true)).permission("perspective.read.p1", Boolean.valueOf(false)).permission("screen.read", Boolean.valueOf(false)).build());
        this.permissionManager.setDefaultVotingStrategy(VotingStrategy.PRIORITY);
        Assert.assertFalse((boolean)this.authorizationManager.authorize("perspective.read", user));
        Assert.assertTrue((boolean)this.authorizationManager.authorize("perspective.read.p1", user));
        Assert.assertFalse((boolean)this.authorizationManager.authorize("perspective.read.p2", user));
        Assert.assertFalse((boolean)this.authorizationManager.authorize("screen.read", user));
        Assert.assertTrue((boolean)this.authorizationManager.authorize("screen.read.s1", user));
    }

    @Test
    public void testLowPriorityVoting() {
        User user = this.createUserMock("role1", "role2");
        this.permissionManager.setAuthorizationPolicy(this.permissionManager.newAuthorizationPolicy().role("role1").permission("perspective.read", Boolean.valueOf(false)).permission("perspective.read.p1", Boolean.valueOf(true)).permission("screen.read.s1", Boolean.valueOf(true)).role("role2").priority(10).permission("perspective.read", Boolean.valueOf(true)).permission("perspective.read.p1", Boolean.valueOf(false)).permission("screen.read", Boolean.valueOf(false)).build());
        this.permissionManager.setDefaultVotingStrategy(VotingStrategy.PRIORITY);
        Assert.assertTrue((boolean)this.authorizationManager.authorize("perspective.read", user));
        Assert.assertFalse((boolean)this.authorizationManager.authorize("perspective.read.p1", user));
        Assert.assertTrue((boolean)this.authorizationManager.authorize("perspective.read.p2", user));
        Assert.assertFalse((boolean)this.authorizationManager.authorize("screen.read", user));
        Assert.assertFalse((boolean)this.authorizationManager.authorize("screen.read.s1", user));
    }

    @Test
    public void testVotingUnanimous() throws Exception {
        User user1 = this.createUserMock("admin", "manager");
        this.permissionManager.setDefaultVotingStrategy(VotingStrategy.UNANIMOUS);
        Assert.assertFalse((boolean)this.authorizationManager.authorize(this.perspective1, user1));
        this.authorizationManager.check(this.perspective1, user1).granted(this.onGranted).denied(this.onDenied);
        ((Command)Mockito.verify((Object)this.onGranted, (VerificationMode)Mockito.never())).execute();
        ((Command)Mockito.verify((Object)this.onDenied)).execute();
    }

    @Test
    public void testVotingAffirmative() throws Exception {
        User user1 = this.createUserMock("admin", "manager");
        this.permissionManager.setDefaultVotingStrategy(VotingStrategy.AFFIRMATIVE);
        Assert.assertTrue((boolean)this.authorizationManager.authorize(this.perspective1, user1));
        this.authorizationManager.check(this.perspective1, user1).granted(this.onGranted).denied(this.onDenied);
        ((Command)Mockito.verify((Object)this.onDenied, (VerificationMode)Mockito.never())).execute();
        ((Command)Mockito.verify((Object)this.onGranted)).execute();
    }

    @Test
    public void testInvalidateCache() throws Exception {
        User user1 = this.createUserMock("admin", "manager");
        this.permissionManager.setDefaultVotingStrategy(VotingStrategy.AFFIRMATIVE);
        Assert.assertTrue((boolean)this.authorizationManager.authorize(this.perspective1, user1));
        this.authorizationManager.check(this.perspective1, user1).granted(this.onGranted).denied(this.onDenied);
        ((Command)Mockito.verify((Object)this.onDenied, (VerificationMode)Mockito.never())).execute();
        ((Command)Mockito.verify((Object)this.onGranted)).execute();
        this.authorizationManager.invalidate(user1);
        ((PermissionManager)Mockito.verify((Object)this.permissionManager, (VerificationMode)Mockito.times((int)1))).invalidate(user1);
    }
}

