/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.client.authz;

import org.jboss.errai.codegen.Context;
import org.jboss.errai.codegen.Statement;
import org.jboss.errai.ioc.rebind.ioc.injector.api.Decorable;
import org.jboss.errai.ioc.rebind.ioc.injector.api.FactoryController;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.security.annotations.PermissionCheck;
import org.uberfire.security.processors.PermissionCheckProcessor;

@RunWith(value=MockitoJUnitRunner.class)
public class PermissionCheckProcessorTest {
    @Mock
    Decorable decorable;
    @Mock
    FactoryController controller;
    Context context = Context.create();
    PermissionCheckProcessor processor;

    @Before
    public void setUp() {
        this.processor = new PermissionCheckProcessor(PermissionCheck.class);
        this.context.addVariable("this", FunctionTest.class);
    }

    @Test
    public void testPermissionStatement() {
        Statement stmt = this.processor.createPermissionCheck("myfeature", null, null);
        String ifStr = stmt.generate(this.context);
        Assert.assertEquals((Object)ifStr, (Object)"if (!(org.uberfire.security.client.authz.AuthorizationManagerHelper.authorize(\"myfeature\"))) {\n  return;\n}");
    }

    @Test
    public void testEmptyCallback() {
        Statement stmt = this.processor.createPermissionCheck("myfeature", "", "");
        String ifStr = stmt.generate(this.context);
        Assert.assertEquals((Object)ifStr, (Object)"if (!(org.uberfire.security.client.authz.AuthorizationManagerHelper.authorize(\"myfeature\"))) {\n  return;\n}");
    }

    @Test
    public void testPermissionCallbacks() {
        Statement stmt = this.processor.createPermissionCheck("myfeature", "granted", "denied");
        String ifStr = stmt.generate(this.context);
        Assert.assertEquals((Object)ifStr, (Object)"if (!(org.uberfire.security.client.authz.AuthorizationManagerHelper.authorize(\"myfeature\"))) {\n  denied();\n  return;\n} else {\n  granted();\n}");
    }

    static interface FunctionTest {
        public void granted();

        public void denied();
    }
}

