/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.api.validation;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import org.jboss.errai.security.shared.api.Group;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.ext.security.management.api.validation.GroupValidator;

public class GroupValidatorTest {
    @Test
    public void testValid() {
        Group group = (Group)Mockito.mock(Group.class);
        Mockito.when((Object)group.getName()).thenReturn((Object)"group1");
        Set violations = new GroupValidatorTestImpl().validate(group);
        Assert.assertTrue((boolean)violations.isEmpty());
    }

    @Test
    public void testBlankGroupName() {
        Group blankGroup = (Group)Mockito.mock(Group.class);
        Mockito.when((Object)blankGroup.getName()).thenReturn((Object)"");
        Set violations1 = new GroupValidatorTestImpl().validate(blankGroup);
        Assert.assertTrue((violations1.size() == 1 ? 1 : 0) != 0);
        ConstraintViolation violation = (ConstraintViolation)violations1.iterator().next();
        Assert.assertEquals((Object)((Path.Node)violation.getPropertyPath().iterator().next()).getName(), (Object)"name");
        Assert.assertEquals((Object)violation.getMessage(), (Object)"nameNotEmpty");
    }

    public static class GroupValidatorTestImpl
    extends GroupValidator {
        public String getMessage(String key) {
            return key;
        }
    }
}

