/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.api.validation;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.ext.security.management.api.validation.UserValidator;

public class UserValidatorTest {
    @Test
    public void testValid() {
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getIdentifier()).thenReturn((Object)"user1");
        Set violations = new UserValidatorTestImpl().validate(user);
        Assert.assertTrue((boolean)violations.isEmpty());
    }

    @Test
    public void testBlankUsername() {
        User blankUser = (User)Mockito.mock(User.class);
        Mockito.when((Object)blankUser.getIdentifier()).thenReturn((Object)"");
        Set violations1 = new UserValidatorTestImpl().validate(blankUser);
        Assert.assertTrue((violations1.size() == 1 ? 1 : 0) != 0);
        ConstraintViolation violation = (ConstraintViolation)violations1.iterator().next();
        Assert.assertEquals((Object)((Path.Node)violation.getPropertyPath().iterator().next()).getName(), (Object)"identifier");
        Assert.assertEquals((Object)violation.getMessage(), (Object)"nameNotEmpty");
    }

    public static class UserValidatorTestImpl
    extends UserValidator {
        public String getMessage(String key) {
            return key;
        }
    }
}

