/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.service;

import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.security.management.BackendUserSystemManager;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.UserManager;
import org.uberfire.ext.security.management.api.UserManagerSettings;
import org.uberfire.ext.security.management.api.exception.NoImplementationAvailableException;
import org.uberfire.ext.security.management.api.exception.SecurityManagementException;
import org.uberfire.ext.security.management.api.service.UserManagerService;

@Service
@ApplicationScoped
public class UserManagerServiceImpl
implements UserManagerService {
    private static final Logger LOG = LoggerFactory.getLogger(UserManagerServiceImpl.class);
    @Inject
    private BackendUserSystemManager userSystemManager;
    private UserManager service;

    @PostConstruct
    public void init() {
        this.service = this.userSystemManager.users();
    }

    private UserManager getService() throws SecurityManagementException {
        if (!this.userSystemManager.isActive() || this.service == null) {
            throw new NoImplementationAvailableException();
        }
        return this.service;
    }

    public void assignGroups(String username, Collection<String> groups) {
        UserManager serviceImpl = this.getService();
        serviceImpl.assignGroups(username, groups);
    }

    public void assignRoles(String username, Collection<String> roles) {
        UserManager serviceImpl = this.getService();
        serviceImpl.assignRoles(username, roles);
    }

    public void changePassword(String username, String newPassword) {
        UserManager serviceImpl = this.getService();
        serviceImpl.changePassword(username, newPassword);
    }

    public AbstractEntityManager.SearchResponse<User> search(AbstractEntityManager.SearchRequest request) {
        UserManager serviceImpl = this.getService();
        AbstractEntityManager.SearchResponse response = null;
        try {
            if (request.getPage() == 0) {
                throw new IllegalArgumentException("First page must be 1.");
            }
            response = serviceImpl.search(request);
        }
        catch (RuntimeException e) {
            throw new SecurityManagementException((Throwable)e);
        }
        return response;
    }

    public User get(String identifier) {
        UserManager serviceImpl = this.getService();
        return (User)serviceImpl.get(identifier);
    }

    public User create(User entity) {
        UserManager serviceImpl = this.getService();
        return (User)serviceImpl.create((Object)entity);
    }

    public User update(User entity) {
        UserManager serviceImpl = this.getService();
        return (User)serviceImpl.update((Object)entity);
    }

    public void delete(String ... identifiers) {
        UserManager serviceImpl = this.getService();
        serviceImpl.delete(identifiers);
    }

    public UserManagerSettings getSettings() {
        UserManager serviceImpl = this.getService();
        return (UserManagerSettings)serviceImpl.getSettings();
    }
}

