/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.screens.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.screens.BaseScreen;
import org.uberfire.ext.security.management.client.screens.editor.GroupEditorScreen;
import org.uberfire.ext.security.management.client.widgets.management.editor.group.GroupEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.group.workflow.GroupCreationWorkflow;
import org.uberfire.ext.security.management.client.widgets.management.editor.group.workflow.GroupEditorWorkflow;
import org.uberfire.ext.security.management.client.widgets.management.events.DeleteGroupEvent;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class GroupEditorScreenTest {
    @Mock
    PlaceManager placeManager;
    @Mock
    EventSourceMock<ChangeTitleWidgetEvent> changeTitleNotification;
    @Mock
    ErrorPopupPresenter errorPopupPresenter;
    @Mock
    BaseScreen baseScreen;
    @Mock
    ClientUserSystemManager clientUserSystemManager;
    @Mock
    GroupEditorWorkflow groupEditorWorkflow;
    @Mock
    GroupCreationWorkflow groupCreationWorkflow;
    @Mock
    GroupEditor groupEditor;
    @InjectMocks
    GroupEditorScreen tested;

    @Before
    public void setup() {
        Mockito.when((Object)this.clientUserSystemManager.isUserCapabilityEnabled((Capability)Matchers.any(Capability.class))).thenReturn((Object)true);
    }

    @Test
    public void testOnStartupAddingGroup() {
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)placeRequest.getParameter("addGroup", "false")).thenReturn((Object)"true");
        this.tested.onStartup(placeRequest);
        ((BaseScreen)Mockito.verify((Object)this.baseScreen, (VerificationMode)Mockito.times((int)1))).init((IsWidget)this.groupCreationWorkflow);
        ((GroupCreationWorkflow)Mockito.verify((Object)this.groupCreationWorkflow, (VerificationMode)Mockito.times((int)1))).create();
    }

    @Test
    public void testOnStartupShowingUser() {
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)placeRequest.getParameter("addGroup", "false")).thenReturn((Object)"false");
        Mockito.when((Object)placeRequest.getParameter((String)Mockito.eq((Object)"groupName"), (String)Mockito.isNull(String.class))).thenReturn((Object)"group1");
        this.tested.onStartup(placeRequest);
        ((BaseScreen)Mockito.verify((Object)this.baseScreen, (VerificationMode)Mockito.times((int)1))).init((IsWidget)this.groupEditorWorkflow);
        ((GroupEditorWorkflow)Mockito.verify((Object)this.groupEditorWorkflow, (VerificationMode)Mockito.times((int)1))).show("group1");
    }

    @Test
    public void testOnMayCloseSuccess() {
        Mockito.when((Object)this.groupEditorWorkflow.isDirty()).thenReturn((Object)false);
        Assert.assertTrue((boolean)this.tested.onMayClose());
    }

    @Test
    public void testOnMayCloseFailed() {
        Mockito.when((Object)this.groupEditorWorkflow.isDirty()).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.tested.onMayClose());
    }

    @Test
    public void testOnClose() {
        this.tested.groupName = "group1";
        this.tested.onClose();
        Assert.assertNull((Object)this.tested.groupName);
        ((GroupEditorWorkflow)Mockito.verify((Object)this.groupEditorWorkflow, (VerificationMode)Mockito.times((int)1))).clear();
        ((GroupCreationWorkflow)Mockito.verify((Object)this.groupCreationWorkflow, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testShowError() {
        this.tested.showError("error");
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)1))).showMessage("error");
    }

    @Test
    public void testOnGroupDeleted() {
        DeleteGroupEvent deleteGroupEvent = (DeleteGroupEvent)Mockito.mock(DeleteGroupEvent.class);
        Mockito.when((Object)deleteGroupEvent.getName()).thenReturn((Object)"group1");
        this.tested.groupName = "group1";
        this.tested.onGroupDeleted(deleteGroupEvent);
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).closePlace((PlaceRequest)Matchers.any(PlaceRequest.class));
    }
}

