/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.wildfly.properties;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.security.management.BaseTest;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.api.CapabilityStatus;
import org.uberfire.ext.security.management.api.exception.GroupNotFoundException;
import org.uberfire.ext.security.management.api.exception.UnsupportedServiceCapabilityException;
import org.uberfire.ext.security.management.util.SecurityManagementUtils;
import org.uberfire.ext.security.management.wildfly.properties.WildflyGroupPropertiesManager;
import org.uberfire.ext.security.server.RolesRegistry;

@RunWith(value=MockitoJUnitRunner.class)
public class WildflyGroupsPropertiesManagerTest
extends BaseTest {
    protected static final String GROUPS_FILE = "org/uberfire/ext/security/management/wildfly/application-roles.properties";
    protected String groupsFilePath;
    @Spy
    private WildflyGroupPropertiesManager groupsPropertiesManager = new WildflyGroupPropertiesManager();
    private static File elHome;
    @ClassRule
    public static TemporaryFolder tempFolder;

    @BeforeClass
    public static void initWorkspace() throws Exception {
        elHome = tempFolder.newFolder("uf-extensions-security-management-wildfly");
        RolesRegistry.get().clear();
    }

    @Before
    public void setup() throws Exception {
        URL templateURL = Thread.currentThread().getContextClassLoader().getResource(GROUPS_FILE);
        File templateFile = new File(templateURL.getFile());
        FileUtils.cleanDirectory((File)elHome);
        FileUtils.copyFileToDirectory((File)templateFile, (File)elHome);
        this.groupsFilePath = new File(elHome, templateFile.getName()).getAbsolutePath();
        ((WildflyGroupPropertiesManager)Mockito.doReturn((Object)this.groupsFilePath).when((Object)this.groupsPropertiesManager)).getGroupsFilePath();
        this.groupsPropertiesManager.initialize(this.userSystemManager);
    }

    @After
    public void finishIt() throws Exception {
        this.groupsPropertiesManager.destroy();
    }

    @Test
    public void testCapabilities() {
        Assert.assertEquals((Object)this.groupsPropertiesManager.getCapabilityStatus(Capability.CAN_SEARCH_GROUPS), (Object)CapabilityStatus.ENABLED);
        Assert.assertEquals((Object)this.groupsPropertiesManager.getCapabilityStatus(Capability.CAN_READ_GROUP), (Object)CapabilityStatus.ENABLED);
        Assert.assertEquals((Object)this.groupsPropertiesManager.getCapabilityStatus(Capability.CAN_ADD_GROUP), (Object)CapabilityStatus.ENABLED);
        Assert.assertEquals((Object)this.groupsPropertiesManager.getCapabilityStatus(Capability.CAN_DELETE_GROUP), (Object)CapabilityStatus.ENABLED);
        Assert.assertEquals((Object)this.groupsPropertiesManager.getCapabilityStatus(Capability.CAN_UPDATE_GROUP), (Object)CapabilityStatus.UNSUPPORTED);
    }

    @Test
    public void testAllowsEmpty() {
        Assert.assertFalse((boolean)this.groupsPropertiesManager.getSettings().allowEmpty());
    }

    @Test(expected=RuntimeException.class)
    public void testSearchPageZero() {
        AbstractEntityManager.SearchRequest request = this.buildSearchRequestMock("", 0, 5);
        AbstractEntityManager.SearchResponse response = this.groupsPropertiesManager.search(request);
    }

    @Test
    public void testSearchAll() {
        AbstractEntityManager.SearchRequest request = this.buildSearchRequestMock("", 1, 5);
        AbstractEntityManager.SearchResponse response = this.groupsPropertiesManager.search(request);
        Assert.assertNotNull((Object)response);
        List groups = response.getResults();
        int total = response.getTotal();
        boolean hasNextPage = response.hasNextPage();
        Assert.assertEquals((long)total, (long)5L);
        Assert.assertTrue((!hasNextPage ? 1 : 0) != 0);
        Assert.assertEquals((long)groups.size(), (long)5L);
        List<Group> expectedGroups = this.createGroupList("ADMIN", "admin", "role3", "role2", "role1");
        Assert.assertEquals(new HashSet<Group>(expectedGroups), new HashSet(groups));
    }

    @Test
    public void testGroupsForUser() {
        Set groups = this.groupsPropertiesManager.getGroupsAndRolesForUser("admin")[0];
        this.assertGroupsForUser(groups, new String[]{"ADMIN"});
        groups = this.groupsPropertiesManager.getGroupsAndRolesForUser("user1")[0];
        this.assertGroupsForUser(groups, new String[]{"role1"});
        groups = this.groupsPropertiesManager.getGroupsAndRolesForUser("user2")[0];
        this.assertGroupsForUser(groups, new String[]{"role1", "role2"});
        groups = this.groupsPropertiesManager.getGroupsAndRolesForUser("user3")[0];
        this.assertGroupsForUser(groups, new String[]{"role3"});
    }

    @Test
    public void testGet() {
        this.assertGet("admin");
        this.assertGet("role1");
        this.assertGet("role2");
        this.assertGet("role3");
        this.assertGet("ADMIN");
    }

    @Test
    public void testCreateGroup() {
        HashSet<String> users = new HashSet<String>();
        users.add("user10");
        this.groupsPropertiesManager.assignUsers("role10", users);
        Group created = this.groupsPropertiesManager.get("role10");
        Set groups = this.groupsPropertiesManager.getGroupsAndRolesForUser("user10")[0];
        Assert.assertNotNull((Object)created);
        this.assertGroupsForUser(groups, new String[]{"role10"});
    }

    @Test(expected=UnsupportedServiceCapabilityException.class)
    public void testUpdateGroup() {
        Group group = (Group)Mockito.mock(Group.class);
        Mockito.when((Object)group.getName()).thenReturn((Object)"role10");
        this.groupsPropertiesManager.update(group);
    }

    @Test(expected=GroupNotFoundException.class)
    public void testDeleteGroup() {
        this.groupsPropertiesManager.delete(new String[]{"role3"});
        this.groupsPropertiesManager.get("role3");
    }

    private List<Group> createGroupList(String ... names) {
        if (names != null) {
            ArrayList<Group> result = new ArrayList<Group>(names.length);
            for (int x = 0; x < names.length; ++x) {
                String name = names[x];
                Group g = SecurityManagementUtils.createGroup((String)name);
                result.add(g);
            }
            return result;
        }
        return null;
    }

    private void assertGet(String name) {
        Group group = this.groupsPropertiesManager.get(name);
        Assert.assertNotNull((Object)group);
        Assert.assertEquals((Object)group.getName(), (Object)name);
    }

    private void assertGroupsForUser(Set<Group> groupsSet, String[] groups) {
        Assert.assertNotNull(groupsSet);
        Assert.assertEquals((long)groupsSet.size(), (long)groups.length);
        int x = 0;
        for (Group g : groupsSet) {
            String gName = groups[x];
            Assert.assertTrue((boolean)groupsSet.contains(new GroupImpl(gName)));
            ++x;
        }
    }

    static {
        tempFolder = new TemporaryFolder();
    }
}

