/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.wildfly.properties;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.BaseTest;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.api.CapabilityStatus;
import org.uberfire.ext.security.management.api.UserManager;
import org.uberfire.ext.security.management.api.exception.UserNotFoundException;
import org.uberfire.ext.security.management.wildfly.properties.WildflyGroupPropertiesManager;
import org.uberfire.ext.security.management.wildfly.properties.WildflyUserPropertiesManager;

@RunWith(value=MockitoJUnitRunner.class)
public class WildflyUsersPropertiesManagerTest
extends BaseTest {
    protected static final String ADMIN = "admin";
    protected static final String USERS_FILE = "org/uberfire/ext/security/management/wildfly/application-users.properties";
    protected String usersFilePath;
    @Spy
    private WildflyUserPropertiesManager usersPropertiesManager = new WildflyUserPropertiesManager();
    @Mock
    private WildflyGroupPropertiesManager groupPropertiesManager;
    private static File elHome;
    @ClassRule
    public static TemporaryFolder tempFolder;

    @BeforeClass
    public static void initWorkspace() throws Exception {
        elHome = tempFolder.newFolder("uf-extensions-security-management-wildfly");
    }

    @Before
    public void setup() throws Exception {
        URL templateURL = Thread.currentThread().getContextClassLoader().getResource(USERS_FILE);
        File templateFile = new File(templateURL.getFile());
        FileUtils.cleanDirectory((File)elHome);
        FileUtils.copyFileToDirectory((File)templateFile, (File)elHome);
        this.usersFilePath = new File(elHome, templateFile.getName()).getAbsolutePath();
        ((WildflyUserPropertiesManager)Mockito.doReturn((Object)this.usersFilePath).when((Object)this.usersPropertiesManager)).getUsersFilePath();
        this.usersPropertiesManager.initialize(this.userSystemManager);
        ((WildflyUserPropertiesManager)Mockito.doReturn((Object)this.groupPropertiesManager).when((Object)this.usersPropertiesManager)).getGroupsPropertiesManager();
    }

    @After
    public void finishIt() throws Exception {
        this.usersPropertiesManager.destroy();
    }

    @Test
    public void testCapabilities() {
        Assert.assertEquals((Object)this.usersPropertiesManager.getCapabilityStatus(Capability.CAN_SEARCH_USERS), (Object)CapabilityStatus.ENABLED);
        Assert.assertEquals((Object)this.usersPropertiesManager.getCapabilityStatus(Capability.CAN_READ_USER), (Object)CapabilityStatus.ENABLED);
        Assert.assertEquals((Object)this.usersPropertiesManager.getCapabilityStatus(Capability.CAN_UPDATE_USER), (Object)CapabilityStatus.ENABLED);
        Assert.assertEquals((Object)this.usersPropertiesManager.getCapabilityStatus(Capability.CAN_ADD_USER), (Object)CapabilityStatus.ENABLED);
        Assert.assertEquals((Object)this.usersPropertiesManager.getCapabilityStatus(Capability.CAN_DELETE_USER), (Object)CapabilityStatus.ENABLED);
        Assert.assertEquals((Object)this.usersPropertiesManager.getCapabilityStatus(Capability.CAN_MANAGE_ATTRIBUTES), (Object)CapabilityStatus.UNSUPPORTED);
        Assert.assertEquals((Object)this.usersPropertiesManager.getCapabilityStatus(Capability.CAN_ASSIGN_GROUPS), (Object)CapabilityStatus.ENABLED);
        Assert.assertEquals((Object)this.usersPropertiesManager.getCapabilityStatus(Capability.CAN_CHANGE_PASSWORD), (Object)CapabilityStatus.ENABLED);
        Assert.assertEquals((Object)this.usersPropertiesManager.getCapabilityStatus(Capability.CAN_ASSIGN_ROLES), (Object)CapabilityStatus.ENABLED);
    }

    @Test
    public void testAttributes() {
        Assert.assertNull((Object)this.usersPropertiesManager.getSettings().getSupportedAttributes());
    }

    @Test(expected=RuntimeException.class)
    public void testSearchPageZero() {
        AbstractEntityManager.SearchRequest request = this.buildSearchRequestMock("", 0, 5);
        AbstractEntityManager.SearchResponse response = this.usersPropertiesManager.search(request);
    }

    @Test
    public void testSearchAll() {
        AbstractEntityManager.SearchRequest request = this.buildSearchRequestMock("", 1, 5);
        AbstractEntityManager.SearchResponse response = this.usersPropertiesManager.search(request);
        Assert.assertNotNull((Object)response);
        List users = response.getResults();
        int total = response.getTotal();
        boolean hasNextPage = response.hasNextPage();
        Assert.assertEquals((long)total, (long)4L);
        Assert.assertTrue((!hasNextPage ? 1 : 0) != 0);
        Assert.assertEquals((long)users.size(), (long)4L);
        HashSet<User> expectedUsers = new HashSet<User>(4);
        expectedUsers.add(this.create(ADMIN));
        expectedUsers.add(this.create("user1"));
        expectedUsers.add(this.create("user2"));
        expectedUsers.add(this.create("user3"));
        Assert.assertThat(new HashSet(users), (Matcher)CoreMatchers.is(expectedUsers));
    }

    @Test
    public void testGetAdmin() {
        User user = this.usersPropertiesManager.get(ADMIN);
        this.assertUser(user, ADMIN);
    }

    @Test
    public void testGetUser1() {
        User user = this.usersPropertiesManager.get("user1");
        this.assertUser(user, "user1");
    }

    @Test
    public void testGetUser2() {
        User user = this.usersPropertiesManager.get("user2");
        this.assertUser(user, "user2");
    }

    @Test
    public void testGetUser3() {
        User user = this.usersPropertiesManager.get("user3");
        this.assertUser(user, "user3");
    }

    @Test
    public void testCreateUser() {
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getIdentifier()).thenReturn((Object)"user4");
        User userCreated = this.usersPropertiesManager.create(user);
        this.assertUser(userCreated, "user4");
    }

    @Test(expected=UserNotFoundException.class)
    public void testDeleteUser() {
        this.usersPropertiesManager.delete(new String[]{"user1"});
        this.usersPropertiesManager.get("user1");
        try {
            ((WildflyGroupPropertiesManager)Mockito.verify((Object)this.groupPropertiesManager, (VerificationMode)Mockito.times((int)1))).removeEntry("user1");
        }
        catch (IOException e) {
            Assert.fail();
        }
    }

    @Test
    public void testAssignGroups() {
        final User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getIdentifier()).thenReturn((Object)"user1");
        Mockito.when((Object)user.getRoles()).thenReturn(new HashSet());
        UserManager userManagerMock = (UserManager)Mockito.mock(UserManager.class);
        ((UserManager)Mockito.doAnswer((Answer)new Answer<User>(){

            public User answer(InvocationOnMock invocationOnMock) throws Throwable {
                return user;
            }
        }).when((Object)userManagerMock)).get("user1");
        Mockito.when((Object)this.userSystemManager.users()).thenReturn((Object)userManagerMock);
        ArrayList<String> groups = new ArrayList<String>(2);
        groups.add("group1");
        groups.add("group2");
        this.usersPropertiesManager.assignGroups("user1", groups);
        ArgumentCaptor groupsCaptor = ArgumentCaptor.forClass(Collection.class);
        ((WildflyGroupPropertiesManager)Mockito.verify((Object)this.groupPropertiesManager, (VerificationMode)Mockito.times((int)1))).setGroupsForUser((String)Matchers.eq((Object)"user1"), (Collection)groupsCaptor.capture());
        Collection groupsCaptured = (Collection)groupsCaptor.getValue();
        Assert.assertTrue((groupsCaptured.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)groupsCaptured.contains("group1"));
        Assert.assertTrue((boolean)groupsCaptured.contains("group2"));
    }

    @Test
    public void testAssignRoles() {
        final User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getIdentifier()).thenReturn((Object)"user1");
        Mockito.when((Object)user.getGroups()).thenReturn(new HashSet());
        UserManager userManagerMock = (UserManager)Mockito.mock(UserManager.class);
        ((UserManager)Mockito.doAnswer((Answer)new Answer<User>(){

            public User answer(InvocationOnMock invocationOnMock) throws Throwable {
                return user;
            }
        }).when((Object)userManagerMock)).get("user1");
        Mockito.when((Object)this.userSystemManager.users()).thenReturn((Object)userManagerMock);
        ArrayList<String> roles = new ArrayList<String>(2);
        roles.add("group1");
        roles.add("group2");
        this.usersPropertiesManager.assignRoles("user1", roles);
        ArgumentCaptor groupsCaptor = ArgumentCaptor.forClass(Collection.class);
        ((WildflyGroupPropertiesManager)Mockito.verify((Object)this.groupPropertiesManager, (VerificationMode)Mockito.times((int)1))).setGroupsForUser((String)Matchers.eq((Object)"user1"), (Collection)groupsCaptor.capture());
        Collection groupsCaptured = (Collection)groupsCaptor.getValue();
        Assert.assertTrue((groupsCaptured.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)groupsCaptured.contains("group1"));
        Assert.assertTrue((boolean)groupsCaptured.contains("group2"));
    }

    @Test
    public void testChangePassword() throws Exception {
        String oldHash = this.usersPropertiesManager.usersFileLoader.getProperties().getProperty("user1");
        this.usersPropertiesManager.changePassword("user1", "newUser1Password");
        String currentHash = this.usersPropertiesManager.usersFileLoader.getProperties().getProperty("user1");
        Assert.assertNotEquals((Object)oldHash, (Object)currentHash);
    }

    private User create(String username) {
        return new UserImpl(username);
    }

    private void assertUser(User user, String username) {
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)user.getIdentifier(), (Object)username);
    }

    static {
        tempFolder = new TemporaryFolder();
    }
}

