/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.wildfly.properties;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jboss.as.domain.management.security.PropertiesFileLoader;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.Role;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.config.ConfigProperties;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.api.CapabilityStatus;
import org.uberfire.ext.security.management.api.ContextualManager;
import org.uberfire.ext.security.management.api.GroupManager;
import org.uberfire.ext.security.management.api.GroupManagerSettings;
import org.uberfire.ext.security.management.api.UserSystemManager;
import org.uberfire.ext.security.management.api.exception.GroupNotFoundException;
import org.uberfire.ext.security.management.api.exception.SecurityManagementException;
import org.uberfire.ext.security.management.api.exception.UnsupportedServiceCapabilityException;
import org.uberfire.ext.security.management.impl.GroupManagerSettingsImpl;
import org.uberfire.ext.security.management.search.GroupsIdentifierRuntimeSearchEngine;
import org.uberfire.ext.security.management.search.IdentifierRuntimeSearchEngine;
import org.uberfire.ext.security.management.util.SecurityManagementUtils;
import org.uberfire.ext.security.management.wildfly.properties.BaseWildflyPropertiesManager;

public class WildflyGroupPropertiesManager
extends BaseWildflyPropertiesManager
implements GroupManager,
ContextualManager {
    public static final String DEFAULT_GROUPS_FILE = "./standalone/configuration/application-roles.properties";
    private static final Logger LOG = LoggerFactory.getLogger(WildflyGroupPropertiesManager.class);
    private static final String GROUP_SEPARATOR = ",";
    protected final IdentifierRuntimeSearchEngine<Group> groupsSearchEngine = new GroupsIdentifierRuntimeSearchEngine();
    protected String groupsFilePath;
    protected PropertiesFileLoader groupsPropertiesFileLoader;

    public WildflyGroupPropertiesManager() {
        this(new ConfigProperties(System.getProperties()));
    }

    public WildflyGroupPropertiesManager(Map<String, String> gitPrefs) {
        this(new ConfigProperties(gitPrefs));
    }

    public WildflyGroupPropertiesManager(ConfigProperties gitPrefs) {
        this.loadConfig(gitPrefs);
    }

    @Override
    protected void loadConfig(ConfigProperties config) {
        LOG.debug("Configuring JBoss provider from properties.");
        super.loadConfig(config);
        ConfigProperties.ConfigProperty groupsFilePathProperty = config.get("org.uberfire.ext.security.management.wildfly.properties.groups-file-path", DEFAULT_GROUPS_FILE);
        if (!WildflyGroupPropertiesManager.isConfigPropertySet(groupsFilePathProperty)) {
            throw new IllegalArgumentException("Property 'org.uberfire.ext.security.management.wildfly.properties.groups-file-path' is mandatory and not set.");
        }
        this.groupsFilePath = groupsFilePathProperty.getValue();
        LOG.debug("Configuration of JBoss provider provider finished.");
    }

    public void initialize(UserSystemManager userSystemManager) throws Exception {
        this.groupsPropertiesFileLoader = this.getFileLoader(this.getGroupsFilePath());
    }

    public void destroy() throws Exception {
        this.groupsPropertiesFileLoader.stop(null);
    }

    public AbstractEntityManager.SearchResponse<Group> search(AbstractEntityManager.SearchRequest request) throws SecurityManagementException {
        Set<String> result = this.getAllGroups();
        return this.groupsSearchEngine.searchByIdentifiers(result, request);
    }

    public Group get(String identifier) throws SecurityManagementException {
        if (identifier == null) {
            throw new NullPointerException();
        }
        Set<String> result = this.getAllGroups();
        if (result != null && result.contains(identifier)) {
            return this.createGroup(identifier);
        }
        throw new GroupNotFoundException(identifier);
    }

    public Set[] getGroupsAndRolesForUser(String username) {
        if (this.groupsPropertiesFileLoader != null && username != null) {
            try {
                Set<String> allGroups;
                String groupsStr = this.groupsPropertiesFileLoader.getProperties().getProperty(username);
                Set<String> groups = WildflyGroupPropertiesManager.parseGroupIdentifiers(groupsStr);
                Set registeredRoles = SecurityManagementUtils.getRegisteredRoleNames();
                if (groups != null && (allGroups = this.getAllGroups()) != null) {
                    HashSet _groups = new HashSet();
                    HashSet _roles = new HashSet();
                    for (String name : groups) {
                        if (!allGroups.contains(name)) {
                            String error = "Error getting groups for user. User's group '" + name + "' does not exist.";
                            LOG.error(error);
                            throw new SecurityManagementException(error);
                        }
                        SecurityManagementUtils.populateGroupOrRoles((String)name, (Set)registeredRoles, _groups, _roles);
                    }
                    return new Set[]{_groups, _roles};
                }
            }
            catch (IOException e) {
                LOG.error("Error getting groups for user " + username, (Throwable)e);
                throw new SecurityManagementException((Throwable)e);
            }
        }
        return null;
    }

    public void setGroupsForUser(String username, Collection<String> groups) {
        if (username == null) {
            throw new NullPointerException();
        }
        String errorMsg = "Error updating groups for user " + username + ". Groups to assign must exist!";
        if (groups != null && !this.existGroups(groups)) {
            LOG.error(errorMsg);
            throw new SecurityManagementException(errorMsg);
        }
        String g = groups != null ? StringUtils.join(groups, (char)',') : null;
        this.updateGroupProperty(username, g, errorMsg);
    }

    public String getGroupsFilePath() {
        return this.groupsFilePath;
    }

    public Group create(Group entity) throws SecurityManagementException {
        if (entity == null) {
            throw new NullPointerException();
        }
        return new GroupImpl(entity.getName());
    }

    public Group update(Group entity) throws SecurityManagementException {
        throw new UnsupportedServiceCapabilityException(Capability.CAN_UPDATE_GROUP);
    }

    public void delete(String ... identifiers) throws SecurityManagementException {
        if (identifiers == null) {
            throw new NullPointerException();
        }
        try {
            Set<Map.Entry<Object, Object>> propertiesSet = this.groupsPropertiesFileLoader.getProperties().entrySet();
            if (!propertiesSet.isEmpty()) {
                for (Map.Entry<Object, Object> entry : propertiesSet) {
                    String username = entry.getKey().toString();
                    String groupsStr = entry.getValue().toString();
                    if (groupsStr == null || groupsStr.trim().length() <= 0) continue;
                    String newGroupsStr = this.deleteGroupsFromSerliazedValue(groupsStr, identifiers);
                    String errorMsg = "Error deleting groups for user " + username;
                    this.updateGroupProperty(username, newGroupsStr, errorMsg);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error removing the folowing group names: " + identifiers, (Throwable)e);
            throw new SecurityManagementException((Throwable)e);
        }
    }

    private String deleteGroupsFromSerliazedValue(String groupsStr, String ... identifiers) {
        if (groupsStr != null && groupsStr.trim().length() > 0) {
            String[] gs = groupsStr.split(GROUP_SEPARATOR);
            HashSet groupSet = new HashSet(gs.length);
            Collections.addAll(groupSet, gs);
            for (String name : identifiers) {
                groupSet.remove(name);
            }
            return StringUtils.join(groupSet, (char)',');
        }
        return null;
    }

    public void assignUsers(String name, Collection<String> users) throws SecurityManagementException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (users != null) {
            if (users.isEmpty()) {
                throw new RuntimeException("The realm based on properties file does not allow groups with no users assigned.");
            }
            for (String username : users) {
                try {
                    String groupsStr = this.groupsPropertiesFileLoader.getProperties().getProperty(username);
                    HashSet<String> groupSet = null;
                    if (groupsStr != null && groupsStr.trim().length() > 0) {
                        String[] gs = groupsStr.split(GROUP_SEPARATOR);
                        groupSet = new HashSet(gs.length);
                        Collections.addAll(groupSet, gs);
                    } else {
                        groupSet = new HashSet<String>(1);
                    }
                    groupSet.add(name);
                    String errorMsg = "Error updating groups for user " + username;
                    String newGroupsStr = StringUtils.join(groupSet, (char)',');
                    this.updateGroupProperty(username, newGroupsStr, errorMsg);
                }
                catch (IOException e) {
                    LOG.error("Error setting groups for user " + username, (Throwable)e);
                    throw new SecurityManagementException((Throwable)e);
                }
            }
        }
    }

    public GroupManagerSettings getSettings() {
        HashMap<Capability, CapabilityStatus> capabilityStatusMap = new HashMap<Capability, CapabilityStatus>(8);
        for (Capability capability : SecurityManagementUtils.GROUPS_CAPABILITIES) {
            capabilityStatusMap.put(capability, this.getCapabilityStatus(capability));
        }
        return new GroupManagerSettingsImpl(capabilityStatusMap, false);
    }

    protected CapabilityStatus getCapabilityStatus(Capability capability) {
        if (capability != null) {
            switch (capability) {
                case CAN_ADD_GROUP: 
                case CAN_DELETE_GROUP: 
                case CAN_SEARCH_GROUPS: 
                case CAN_READ_GROUP: {
                    return CapabilityStatus.ENABLED;
                }
            }
        }
        return CapabilityStatus.UNSUPPORTED;
    }

    protected Group createGroup(String name) {
        return SecurityManagementUtils.createGroup((String)name);
    }

    protected Role createRole(String name) {
        return SecurityManagementUtils.createRole((String)name);
    }

    protected Set<String> getAllGroups() {
        try {
            Collection<Object> values = this.groupsPropertiesFileLoader.getProperties().values();
            HashSet<String> result = new HashSet<String>();
            for (Object value : values) {
                Set<String> s = WildflyGroupPropertiesManager.parseGroupIdentifiers(value.toString());
                if (s == null) continue;
                result.addAll(s);
            }
            return result;
        }
        catch (IOException e) {
            LOG.error("Error getting all groups.", (Throwable)e);
            throw new SecurityManagementException((Throwable)e);
        }
    }

    void updateGroupProperty(String name, String groups, String errorMessage) {
        if (name != null) {
            try {
                String g;
                String string = g = groups != null ? groups : this.groupsPropertiesFileLoader.getProperties().getProperty(name);
                if (g != null && g.trim().length() > 0) {
                    this.groupsPropertiesFileLoader.getProperties().put(name, g);
                } else {
                    this.removeEntry(name);
                }
                this.groupsPropertiesFileLoader.persistProperties();
            }
            catch (IOException e) {
                LOG.error(errorMessage, (Throwable)e);
                throw new SecurityManagementException((Throwable)e);
            }
        }
    }

    void removeEntry(String username) throws IOException {
        this.groupsPropertiesFileLoader.getProperties().remove(username);
        this.groupsPropertiesFileLoader.persistProperties();
    }

    protected static Set<String> parseGroupIdentifiers(String groupsStr) {
        if (groupsStr != null && groupsStr.trim().length() > 0) {
            String[] groupsArray = groupsStr.split(GROUP_SEPARATOR);
            HashSet<String> result = new HashSet<String>(groupsArray.length);
            Collections.addAll(result, groupsArray);
            return result;
        }
        return null;
    }

    protected boolean existGroups(Collection<String> groups) {
        if (groups != null) {
            Set<String> allGroups = this.getAllGroups();
            Set registeredRoles = SecurityManagementUtils.getRegisteredRoleNames();
            if (allGroups != null && !allGroups.isEmpty()) {
                for (String name : groups) {
                    if (registeredRoles.contains(name) || allGroups.contains(name)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    protected PropertiesFileLoader getFileLoader(String filePath) {
        File propertiesFile = new File(filePath);
        if (!propertiesFile.exists()) {
            throw new RuntimeException("Cannot load roles/groups properties file from '" + filePath + "'.");
        }
        PropertiesFileLoader propertiesLoad = null;
        try {
            propertiesLoad = new PropertiesFileLoader(propertiesFile.getCanonicalPath(), null);
            propertiesLoad.start(null);
        }
        catch (Exception e) {
            LOG.error("Error getting properties file.", (Throwable)e);
            throw new SecurityManagementException((Throwable)e);
        }
        return propertiesLoad;
    }
}

