/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.wildfly.cli;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.errai.security.shared.api.Group;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.config.ConfigProperties;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.ContextualManager;
import org.uberfire.ext.security.management.api.GroupManager;
import org.uberfire.ext.security.management.api.GroupManagerSettings;
import org.uberfire.ext.security.management.api.UserSystemManager;
import org.uberfire.ext.security.management.api.exception.SecurityManagementException;
import org.uberfire.ext.security.management.wildfly.cli.BaseWildflyCLIManager;
import org.uberfire.ext.security.management.wildfly.properties.WildflyGroupPropertiesManager;

public class WildflyGroupPropertiesCLIManager
extends BaseWildflyCLIManager
implements GroupManager,
ContextualManager {
    private static final Logger LOG = LoggerFactory.getLogger(WildflyGroupPropertiesCLIManager.class);
    protected WildflyGroupPropertiesManager groupsPropertiesManager;

    public WildflyGroupPropertiesCLIManager() {
        this(new ConfigProperties(System.getProperties()));
    }

    public WildflyGroupPropertiesCLIManager(Map<String, String> gitPrefs) {
        this(new ConfigProperties(gitPrefs));
    }

    public WildflyGroupPropertiesCLIManager(ConfigProperties gitPrefs) {
        this.loadConfig(gitPrefs);
    }

    protected String getGroupsPropertiesFilePath() throws Exception {
        return super.getPropertiesFilePath("authorization");
    }

    private void init() {
        try {
            String groupsFilePath = this.getGroupsPropertiesFilePath();
            HashMap<String, String> arguments = new HashMap<String, String>(2);
            arguments.put("org.uberfire.ext.security.management.wildfly.properties.realm", this.realm);
            arguments.put("org.uberfire.ext.security.management.wildfly.properties.groups-file-path", groupsFilePath);
            this.groupsPropertiesManager = new WildflyGroupPropertiesManager(arguments);
        }
        catch (Exception e) {
            LOG.error("Cannot find groups properties file using the configuration present in the server instance.", (Throwable)e);
        }
    }

    public void initialize(UserSystemManager userSystemManager) throws Exception {
        this.init();
        this.groupsPropertiesManager.initialize(userSystemManager);
    }

    public void destroy() throws Exception {
        this.groupsPropertiesManager.destroy();
    }

    public AbstractEntityManager.SearchResponse<Group> search(AbstractEntityManager.SearchRequest request) throws SecurityManagementException {
        return this.groupsPropertiesManager.search(request);
    }

    public Group get(String identifier) throws SecurityManagementException {
        return this.groupsPropertiesManager.get(identifier);
    }

    public List<Group> getAll() throws SecurityManagementException {
        return this.groupsPropertiesManager.getAll();
    }

    public Group create(Group entity) throws SecurityManagementException {
        return this.groupsPropertiesManager.create(entity);
    }

    public Group update(Group entity) throws SecurityManagementException {
        return this.groupsPropertiesManager.update(entity);
    }

    public void delete(String ... identifiers) throws SecurityManagementException {
        this.groupsPropertiesManager.delete(identifiers);
    }

    public GroupManagerSettings getSettings() {
        return this.groupsPropertiesManager.getSettings();
    }

    public void assignUsers(String name, Collection<String> users) throws SecurityManagementException {
        this.groupsPropertiesManager.assignUsers(name, users);
    }
}

