/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.crypt;

import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.uberfire.security.crypt.CryptProvider;

public class DefaultCryptProvider
implements CryptProvider {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Base64 BASE64 = new Base64();
    private static final String HASH_FUNCTION = "SHA-256";
    private static final String KEY = "UFG00D3N0U6HT";

    public String encrypt(String content, Object salt) {
        try {
            Cipher cipher = this.buildCipher(salt, 1);
            byte[] plainTextBytes = content.getBytes(UTF8);
            byte[] cipherText = cipher.doFinal(plainTextBytes);
            return BASE64.encodeAsString(cipherText);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to encrypt", e);
        }
    }

    public String decrypt(String content, Object salt) {
        try {
            Cipher decipher = this.buildCipher(salt, 2);
            byte[] plainText = decipher.doFinal(BASE64.decode(content));
            return new String(plainText, UTF8);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Cipher buildCipher(Object salt, int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        MessageDigest md = MessageDigest.getInstance(HASH_FUNCTION);
        if (salt != null) {
            md.update(salt.toString().getBytes(UTF8));
        }
        byte[] digestOfPassword = md.digest(KEY.getBytes(UTF8));
        byte[] keyBytes = Arrays.copyOf(digestOfPassword, 24);
        int j = 0;
        int k = 16;
        while (j < 8) {
            keyBytes[k++] = keyBytes[j++];
        }
        SecretKeySpec key = new SecretKeySpec(keyBytes, "DESede");
        IvParameterSpec iv = new IvParameterSpec(new byte[8]);
        Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
        cipher.init(mode, (Key)key, iv);
        return cipher;
    }
}

