/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kie.commons.validation.PortablePreconditions;
import org.kie.commons.validation.Preconditions;
import org.uberfire.security.ResourceManager;
import org.uberfire.security.SecurityContext;
import org.uberfire.security.SecurityManager;
import org.uberfire.security.Subject;
import org.uberfire.security.auth.AuthenticatedStorageProvider;
import org.uberfire.security.auth.AuthenticationException;
import org.uberfire.security.auth.AuthenticationManager;
import org.uberfire.security.auth.AuthenticationProvider;
import org.uberfire.security.auth.AuthenticationScheme;
import org.uberfire.security.auth.AuthenticationSource;
import org.uberfire.security.auth.RoleProvider;
import org.uberfire.security.auth.SubjectPropertiesProvider;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.authz.ResourceDecisionManager;
import org.uberfire.security.authz.RoleDecisionManager;
import org.uberfire.security.authz.VotingStrategy;
import org.uberfire.security.impl.authz.DefaultAuthorizationManager;
import org.uberfire.security.impl.authz.DefaultRoleDecisionManager;
import org.uberfire.security.server.HttpSecurityContext;
import org.uberfire.security.server.URLResourceManager;
import org.uberfire.security.server.auth.DefaultAuthenticationProvider;
import org.uberfire.security.server.auth.HttpAuthenticationManager;
import org.uberfire.security.server.auth.RememberMeCookieAuthProvider;
import org.uberfire.security.server.authz.URLAccessDecisionManager;

public class HttpSecurityManagerImpl
implements SecurityManager {
    private AuthenticationManager authManager;
    private List<AuthorizationManager> authzManagers = new ArrayList<AuthorizationManager>();

    private HttpSecurityManagerImpl(AuthenticationManager authManager, List<AuthenticationScheme> authSchemes, List<AuthenticationProvider> authProviders, List<RoleProvider> roleProviders, List<SubjectPropertiesProvider> subjectPropertiesProviders, List<AuthenticatedStorageProvider> authStorageProviders, List<AuthorizationManager> authzManagers, ResourceManager resourceManager, Collection<ResourceDecisionManager> resourceDecisionManagers, VotingStrategy votingStrategy, RoleDecisionManager roleDecisionManager) {
        if (authManager == null) {
            this.authManager = new HttpAuthenticationManager(authSchemes, authProviders, roleProviders, subjectPropertiesProviders, authStorageProviders, resourceManager);
        } else {
            Method method;
            this.authManager = authManager;
            try {
                method = this.authManager.getClass().getMethod("addSchemes", Collection.class);
                method.invoke((Object)this.authManager, authSchemes);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                method = this.authManager.getClass().getMethod("addRoleProviders", Collection.class);
                method.invoke((Object)this.authManager, roleProviders);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                method = this.authManager.getClass().getMethod("addSubjectPropertiesProviders", Collection.class);
                method.invoke((Object)this.authManager, subjectPropertiesProviders);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                method = this.authManager.getClass().getMethod("addStorageProviders", Collection.class);
                method.invoke((Object)this.authManager, authStorageProviders);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                method = this.authManager.getClass().getMethod("setResourceManager", ResourceManager.class);
                method.invoke((Object)this.authManager, resourceManager);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (authProviders != null && authProviders.size() > 0) {
                try {
                    method = this.authManager.getClass().getMethod("addProviders", Collection.class);
                    method.invoke((Object)this.authManager, authProviders);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                method = this.authManager.getClass().getMethod("init", new Class[0]);
                method.invoke((Object)this.authManager, new Object[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Object roleDecision = roleDecisionManager != null ? roleDecisionManager : new DefaultRoleDecisionManager();
        if (resourceDecisionManagers == null || resourceDecisionManagers.isEmpty()) {
            URLResourceManager urlResourceManager = null;
            if (resourceManager instanceof URLResourceManager) {
                urlResourceManager = (URLResourceManager)resourceManager;
            }
            if (urlResourceManager == null) {
                throw new IllegalStateException("Can't find URLResourceManager.");
            }
            resourceDecisionManagers.add(new URLAccessDecisionManager(urlResourceManager));
        }
        if (authzManagers == null || authzManagers.isEmpty()) {
            this.authzManagers.add((AuthorizationManager)new DefaultAuthorizationManager(resourceDecisionManagers, resourceManager, votingStrategy, roleDecision));
        } else {
            for (AuthorizationManager authzManager : authzManagers) {
                Method method;
                try {
                    method = authzManager.getClass().getMethod("addDecisionManagers", Collection.class);
                    method.invoke((Object)authzManager, resourceDecisionManagers);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    method = authzManager.getClass().getMethod("setResourceManager", ResourceManager.class);
                    method.invoke((Object)authzManager, resourceManager);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    method = authzManager.getClass().getMethod("setVotingStrategy", VotingStrategy.class);
                    method.invoke((Object)authzManager, votingStrategy);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    method = authzManager.getClass().getMethod("init", new Class[0]);
                    method.invoke((Object)authzManager, new Object[0]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.authzManagers.add(authzManager);
            }
        }
    }

    public SecurityContext newSecurityContext(Object ... params) {
        PortablePreconditions.checkNotEmpty((String)"params", (Object[])params);
        PortablePreconditions.checkCondition((String)"at least two params should be provided", (params.length >= 2 ? 1 : 0) != 0);
        HttpServletRequest httpRequest = null;
        HttpServletResponse httpResponse = null;
        List<Object> others = params.length == 2 ? Collections.emptyList() : new ArrayList(params.length - 2);
        for (Object param : params) {
            if (param instanceof HttpServletRequest) {
                httpRequest = (HttpServletRequest)param;
                continue;
            }
            if (param instanceof HttpServletResponse) {
                httpResponse = (HttpServletResponse)param;
                continue;
            }
            others.add(param);
        }
        PortablePreconditions.checkNotNull((String)"param.http.request", httpRequest);
        PortablePreconditions.checkNotNull((String)"param.http.response", httpResponse);
        return new HttpSecurityContext(httpRequest, httpResponse, others.toArray(new Object[others.size()]));
    }

    public void logout(SecurityContext context) {
        this.authManager.logout(context);
    }

    public Subject authenticate(SecurityContext context) throws AuthenticationException {
        HttpSecurityContext httpContext = (HttpSecurityContext)Preconditions.checkInstanceOf((String)"context", (Object)context, HttpSecurityContext.class);
        try {
            Subject subject = this.authManager.authenticate((SecurityContext)httpContext);
            httpContext.setCurrentSubject(subject);
            return subject;
        }
        catch (Exception ex) {
            throw new AuthenticationException("Validation fails.", ex);
        }
    }

    public boolean authorize(SecurityContext context) {
        HttpSecurityContext httpContext = (HttpSecurityContext)Preconditions.checkInstanceOf((String)"context", (Object)context, HttpSecurityContext.class);
        for (AuthorizationManager authzManager : this.authzManagers) {
            if (!authzManager.supports(httpContext.getResource())) continue;
            return authzManager.authorize(httpContext.getResource(), httpContext.getCurrentSubject());
        }
        return false;
    }

    public void dispose() {
    }

    public void start() {
    }

    public static HttpSecurityManagerBuilder newBuilder() {
        return new HttpSecurityManagerBuilder();
    }

    public static class HttpSecurityManagerBuilder {
        private AuthenticationManager authManager = null;
        private RoleDecisionManager roleDecisionManager = null;
        private VotingStrategy votingStrategy = null;
        private ResourceManager resourceManager = null;
        private List<AuthorizationManager> authzManagers = new ArrayList<AuthorizationManager>();
        private List<AuthenticationScheme> authSchemes = new ArrayList<AuthenticationScheme>();
        private List<AuthenticationProvider> authProviders = new ArrayList<AuthenticationProvider>();
        private List<RoleProvider> roleProviders = new ArrayList<RoleProvider>();
        private List<SubjectPropertiesProvider> subjectPropertiesProviders = new ArrayList<SubjectPropertiesProvider>();
        private List<AuthenticatedStorageProvider> authStorageProviders = new ArrayList<AuthenticatedStorageProvider>();
        private List<ResourceDecisionManager> accessDecisionManagers = new ArrayList<ResourceDecisionManager>();

        HttpSecurityManagerImpl build(Map<String, String> options) {
            if (this.authProviders != null && !this.authProviders.isEmpty()) {
                for (AuthenticationProvider provider : this.authProviders) {
                    provider.initialize(options);
                }
            }
            return new HttpSecurityManagerImpl(this.authManager, this.authSchemes, this.authProviders, this.roleProviders, this.subjectPropertiesProviders, this.authStorageProviders, this.authzManagers, this.resourceManager, this.accessDecisionManagers, this.votingStrategy, this.roleDecisionManager);
        }

        HttpSecurityManagerBuilder addAuthScheme(AuthenticationScheme authScheme) {
            if (authScheme != null) {
                this.authSchemes.add(authScheme);
            }
            return this;
        }

        HttpSecurityManagerBuilder addAuthManager(AuthenticationManager authManager) {
            this.authManager = authManager;
            return this;
        }

        HttpSecurityManagerBuilder addAuthProvider(AuthenticationProvider authProvider) {
            if (authProvider != null) {
                this.authProviders.add(authProvider);
            }
            return this;
        }

        HttpSecurityManagerBuilder addResourceManager(ResourceManager resourceManager) {
            this.resourceManager = resourceManager;
            return this;
        }

        HttpSecurityManagerBuilder addAccessDecisionManager(ResourceDecisionManager accessDecisionManager) {
            if (accessDecisionManager != null) {
                this.accessDecisionManagers.add(accessDecisionManager);
            }
            return this;
        }

        public HttpSecurityManagerBuilder addRoleProvider(RoleProvider roleProvider) {
            if (roleProvider != null) {
                this.roleProviders.add(roleProvider);
            }
            return this;
        }

        public HttpSecurityManagerBuilder addSubjectPropertiesProvider(SubjectPropertiesProvider subjectPropertiesProvider) {
            if (subjectPropertiesProvider != null) {
                this.subjectPropertiesProviders.add(subjectPropertiesProvider);
            }
            return this;
        }

        public HttpSecurityManagerBuilder addAuthenticatedStorageProvider(AuthenticatedStorageProvider authStorageProvider) {
            if (authStorageProvider != null) {
                this.authStorageProviders.add(authStorageProvider);
            }
            return this;
        }

        HttpSecurityManagerBuilder addAuthzManager(AuthorizationManager authzManager) {
            if (authzManager != null) {
                this.authzManagers.add(authzManager);
            }
            return this;
        }

        HttpSecurityManagerBuilder addVotingStrategy(VotingStrategy votingStrategy) {
            this.votingStrategy = votingStrategy;
            return this;
        }

        HttpSecurityManagerBuilder loadAvailableAuthenticationSources() {
            ServiceLoader<AuthenticationSource> sources = ServiceLoader.load(AuthenticationSource.class);
            if (sources != null) {
                for (AuthenticationSource source : sources) {
                    this.authProviders.add(new DefaultAuthenticationProvider(source));
                    if (!(source instanceof RoleProvider)) continue;
                    this.roleProviders.add((RoleProvider)source);
                }
            }
            this.authProviders.add(new RememberMeCookieAuthProvider());
            return this;
        }

        HttpSecurityManagerBuilder addRoleDecisionManager(RoleDecisionManager roleDecisionManager) {
            this.roleDecisionManager = roleDecisionManager;
            return this;
        }
    }
}

