/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.uberfire.security.Resource;
import org.uberfire.security.server.MapSecurityContext;
import org.uberfire.security.server.URLResource;

public class HttpSecurityContext
extends MapSecurityContext {
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public HttpSecurityContext(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Object ... objects) {
        super(HttpSecurityContext.buildResource(httpRequest));
        this.request = httpRequest;
        this.response = httpResponse;
    }

    private static Resource buildResource(HttpServletRequest request) {
        StringBuilder url = new StringBuilder(request.getServletPath());
        if (request.getQueryString() != null) {
            url.append("?").append(request.getQueryString());
        }
        return new URLResource(url.toString());
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }
}

